/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaTaskRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<CreateOtaTaskRequest.Builder, CreateOtaTaskRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateOtaTaskRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(CreateOtaTaskRequest::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(CreateOtaTaskRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<String>> TARGET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Target")
            .getter(getter(CreateOtaTaskRequest::target))
            .setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskConfigurationId").getter(getter(CreateOtaTaskRequest::taskConfigurationId))
            .setter(setter(Builder::taskConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build())
            .build();

    private static final SdkField<String> OTA_MECHANISM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaMechanism").getter(getter(CreateOtaTaskRequest::otaMechanismAsString))
            .setter(setter(Builder::otaMechanism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaMechanism").build()).build();

    private static final SdkField<String> OTA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaType").getter(getter(CreateOtaTaskRequest::otaTypeAsString)).setter(setter(Builder::otaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaType").build()).build();

    private static final SdkField<String> OTA_TARGET_QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaTargetQueryString").getter(getter(CreateOtaTaskRequest::otaTargetQueryString))
            .setter(setter(Builder::otaTargetQueryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTargetQueryString").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateOtaTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<OtaTaskSchedulingConfig> OTA_SCHEDULING_CONFIG_FIELD = SdkField
            .<OtaTaskSchedulingConfig> builder(MarshallingType.SDK_POJO).memberName("OtaSchedulingConfig")
            .getter(getter(CreateOtaTaskRequest::otaSchedulingConfig)).setter(setter(Builder::otaSchedulingConfig))
            .constructor(OtaTaskSchedulingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaSchedulingConfig").build())
            .build();

    private static final SdkField<OtaTaskExecutionRetryConfig> OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD = SdkField
            .<OtaTaskExecutionRetryConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OtaTaskExecutionRetryConfig")
            .getter(getter(CreateOtaTaskRequest::otaTaskExecutionRetryConfig))
            .setter(setter(Builder::otaTaskExecutionRetryConfig))
            .constructor(OtaTaskExecutionRetryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTaskExecutionRetryConfig")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateOtaTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            S3_URL_FIELD, PROTOCOL_FIELD, TARGET_FIELD, TASK_CONFIGURATION_ID_FIELD, OTA_MECHANISM_FIELD, OTA_TYPE_FIELD,
            OTA_TARGET_QUERY_STRING_FIELD, CLIENT_TOKEN_FIELD, OTA_SCHEDULING_CONFIG_FIELD,
            OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String s3Url;

    private final String protocol;

    private final List<String> target;

    private final String taskConfigurationId;

    private final String otaMechanism;

    private final String otaType;

    private final String otaTargetQueryString;

    private final String clientToken;

    private final OtaTaskSchedulingConfig otaSchedulingConfig;

    private final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;

    private final Map<String, String> tags;

    private CreateOtaTaskRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.s3Url = builder.s3Url;
        this.protocol = builder.protocol;
        this.target = builder.target;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.otaMechanism = builder.otaMechanism;
        this.otaType = builder.otaType;
        this.otaTargetQueryString = builder.otaTargetQueryString;
        this.clientToken = builder.clientToken;
        this.otaSchedulingConfig = builder.otaSchedulingConfig;
        this.otaTaskExecutionRetryConfig = builder.otaTaskExecutionRetryConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The description of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The description of the over-the-air (OTA) task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
     * </p>
     * 
     * @return The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
     */
    public final String s3Url() {
        return s3Url;
    }

    /**
     * <p>
     * The connection protocol the over-the-air (OTA) task uses to update the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OtaProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The connection protocol the over-the-air (OTA) task uses to update the device.
     * @see OtaProtocol
     */
    public final OtaProtocol protocol() {
        return OtaProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The connection protocol the over-the-air (OTA) task uses to update the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OtaProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The connection protocol the over-the-air (OTA) task uses to update the device.
     * @see OtaProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the Target property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTarget() {
        return target != null && !(target instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device targeted for the over-the-air (OTA) task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTarget} method.
     * </p>
     * 
     * @return The device targeted for the over-the-air (OTA) task.
     */
    public final List<String> target() {
        return target;
    }

    /**
     * <p>
     * The identifier for the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return The identifier for the over-the-air (OTA) task configuration.
     */
    public final String taskConfigurationId() {
        return taskConfigurationId;
    }

    /**
     * <p>
     * The deployment mechanism for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaMechanism} will
     * return {@link OtaMechanism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaMechanismAsString}.
     * </p>
     * 
     * @return The deployment mechanism for the over-the-air (OTA) task.
     * @see OtaMechanism
     */
    public final OtaMechanism otaMechanism() {
        return OtaMechanism.fromValue(otaMechanism);
    }

    /**
     * <p>
     * The deployment mechanism for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaMechanism} will
     * return {@link OtaMechanism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaMechanismAsString}.
     * </p>
     * 
     * @return The deployment mechanism for the over-the-air (OTA) task.
     * @see OtaMechanism
     */
    public final String otaMechanismAsString() {
        return otaMechanism;
    }

    /**
     * <p>
     * The frequency type for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaType} will
     * return {@link OtaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaTypeAsString}.
     * </p>
     * 
     * @return The frequency type for the over-the-air (OTA) task.
     * @see OtaType
     */
    public final OtaType otaType() {
        return OtaType.fromValue(otaType);
    }

    /**
     * <p>
     * The frequency type for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaType} will
     * return {@link OtaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaTypeAsString}.
     * </p>
     * 
     * @return The frequency type for the over-the-air (OTA) task.
     * @see OtaType
     */
    public final String otaTypeAsString() {
        return otaType;
    }

    /**
     * <p>
     * The query string to add things to the thing group.
     * </p>
     * 
     * @return The query string to add things to the thing group.
     */
    public final String otaTargetQueryString() {
        return otaTargetQueryString;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the OtaSchedulingConfig property for this object.
     * 
     * @return The value of the OtaSchedulingConfig property for this object.
     */
    public final OtaTaskSchedulingConfig otaSchedulingConfig() {
        return otaSchedulingConfig;
    }

    /**
     * Returns the value of the OtaTaskExecutionRetryConfig property for this object.
     * 
     * @return The value of the OtaTaskExecutionRetryConfig property for this object.
     */
    public final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig() {
        return otaTaskExecutionRetryConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the over-the-air (OTA) task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the over-the-air (OTA) task.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTarget() ? target() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(otaMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otaTargetQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(otaSchedulingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(otaTaskExecutionRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaTaskRequest)) {
            return false;
        }
        CreateOtaTaskRequest other = (CreateOtaTaskRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(s3Url(), other.s3Url())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && hasTarget() == other.hasTarget()
                && Objects.equals(target(), other.target()) && Objects.equals(taskConfigurationId(), other.taskConfigurationId())
                && Objects.equals(otaMechanismAsString(), other.otaMechanismAsString())
                && Objects.equals(otaTypeAsString(), other.otaTypeAsString())
                && Objects.equals(otaTargetQueryString(), other.otaTargetQueryString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(otaSchedulingConfig(), other.otaSchedulingConfig())
                && Objects.equals(otaTaskExecutionRetryConfig(), other.otaTaskExecutionRetryConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOtaTaskRequest").add("Description", description()).add("S3Url", s3Url())
                .add("Protocol", protocolAsString()).add("Target", hasTarget() ? target() : null)
                .add("TaskConfigurationId", taskConfigurationId()).add("OtaMechanism", otaMechanismAsString())
                .add("OtaType", otaTypeAsString()).add("OtaTargetQueryString", otaTargetQueryString())
                .add("ClientToken", clientToken()).add("OtaSchedulingConfig", otaSchedulingConfig())
                .add("OtaTaskExecutionRetryConfig", otaTaskExecutionRetryConfig())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "TaskConfigurationId":
            return Optional.ofNullable(clazz.cast(taskConfigurationId()));
        case "OtaMechanism":
            return Optional.ofNullable(clazz.cast(otaMechanismAsString()));
        case "OtaType":
            return Optional.ofNullable(clazz.cast(otaTypeAsString()));
        case "OtaTargetQueryString":
            return Optional.ofNullable(clazz.cast(otaTargetQueryString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OtaSchedulingConfig":
            return Optional.ofNullable(clazz.cast(otaSchedulingConfig()));
        case "OtaTaskExecutionRetryConfig":
            return Optional.ofNullable(clazz.cast(otaTaskExecutionRetryConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("OtaMechanism", OTA_MECHANISM_FIELD);
        map.put("OtaType", OTA_TYPE_FIELD);
        map.put("OtaTargetQueryString", OTA_TARGET_QUERY_STRING_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OtaSchedulingConfig", OTA_SCHEDULING_CONFIG_FIELD);
        map.put("OtaTaskExecutionRetryConfig", OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaTaskRequest, T> g) {
        return obj -> g.apply((CreateOtaTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateOtaTaskRequest> {
        /**
         * <p>
         * The description of the over-the-air (OTA) task.
         * </p>
         * 
         * @param description
         *        The description of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
         * </p>
         * 
         * @param s3Url
         *        The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * <p>
         * The connection protocol the over-the-air (OTA) task uses to update the device.
         * </p>
         * 
         * @param protocol
         *        The connection protocol the over-the-air (OTA) task uses to update the device.
         * @see OtaProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The connection protocol the over-the-air (OTA) task uses to update the device.
         * </p>
         * 
         * @param protocol
         *        The connection protocol the over-the-air (OTA) task uses to update the device.
         * @see OtaProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaProtocol
         */
        Builder protocol(OtaProtocol protocol);

        /**
         * <p>
         * The device targeted for the over-the-air (OTA) task.
         * </p>
         * 
         * @param target
         *        The device targeted for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Collection<String> target);

        /**
         * <p>
         * The device targeted for the over-the-air (OTA) task.
         * </p>
         * 
         * @param target
         *        The device targeted for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String... target);

        /**
         * <p>
         * The identifier for the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param taskConfigurationId
         *        The identifier for the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfigurationId(String taskConfigurationId);

        /**
         * <p>
         * The deployment mechanism for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaMechanism
         *        The deployment mechanism for the over-the-air (OTA) task.
         * @see OtaMechanism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaMechanism
         */
        Builder otaMechanism(String otaMechanism);

        /**
         * <p>
         * The deployment mechanism for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaMechanism
         *        The deployment mechanism for the over-the-air (OTA) task.
         * @see OtaMechanism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaMechanism
         */
        Builder otaMechanism(OtaMechanism otaMechanism);

        /**
         * <p>
         * The frequency type for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaType
         *        The frequency type for the over-the-air (OTA) task.
         * @see OtaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaType
         */
        Builder otaType(String otaType);

        /**
         * <p>
         * The frequency type for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaType
         *        The frequency type for the over-the-air (OTA) task.
         * @see OtaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaType
         */
        Builder otaType(OtaType otaType);

        /**
         * <p>
         * The query string to add things to the thing group.
         * </p>
         * 
         * @param otaTargetQueryString
         *        The query string to add things to the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaTargetQueryString(String otaTargetQueryString);

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the OtaSchedulingConfig property for this object.
         *
         * @param otaSchedulingConfig
         *        The new value for the OtaSchedulingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig);

        /**
         * Sets the value of the OtaSchedulingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OtaTaskSchedulingConfig.Builder} avoiding
         * the need to create one manually via {@link OtaTaskSchedulingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskSchedulingConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #otaSchedulingConfig(OtaTaskSchedulingConfig)}.
         * 
         * @param otaSchedulingConfig
         *        a consumer that will call methods on {@link OtaTaskSchedulingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaSchedulingConfig(OtaTaskSchedulingConfig)
         */
        default Builder otaSchedulingConfig(Consumer<OtaTaskSchedulingConfig.Builder> otaSchedulingConfig) {
            return otaSchedulingConfig(OtaTaskSchedulingConfig.builder().applyMutation(otaSchedulingConfig).build());
        }

        /**
         * Sets the value of the OtaTaskExecutionRetryConfig property for this object.
         *
         * @param otaTaskExecutionRetryConfig
         *        The new value for the OtaTaskExecutionRetryConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig);

        /**
         * Sets the value of the OtaTaskExecutionRetryConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OtaTaskExecutionRetryConfig.Builder}
         * avoiding the need to create one manually via {@link OtaTaskExecutionRetryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskExecutionRetryConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig)}.
         * 
         * @param otaTaskExecutionRetryConfig
         *        a consumer that will call methods on {@link OtaTaskExecutionRetryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig)
         */
        default Builder otaTaskExecutionRetryConfig(Consumer<OtaTaskExecutionRetryConfig.Builder> otaTaskExecutionRetryConfig) {
            return otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.builder().applyMutation(otaTaskExecutionRetryConfig)
                    .build());
        }

        /**
         * <p>
         * A set of key/value pairs that are used to manage the over-the-air (OTA) task.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String description;

        private String s3Url;

        private String protocol;

        private List<String> target = DefaultSdkAutoConstructList.getInstance();

        private String taskConfigurationId;

        private String otaMechanism;

        private String otaType;

        private String otaTargetQueryString;

        private String clientToken;

        private OtaTaskSchedulingConfig otaSchedulingConfig;

        private OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaTaskRequest model) {
            super(model);
            description(model.description);
            s3Url(model.s3Url);
            protocol(model.protocol);
            target(model.target);
            taskConfigurationId(model.taskConfigurationId);
            otaMechanism(model.otaMechanism);
            otaType(model.otaType);
            otaTargetQueryString(model.otaTargetQueryString);
            clientToken(model.clientToken);
            otaSchedulingConfig(model.otaSchedulingConfig);
            otaTaskExecutionRetryConfig(model.otaTaskExecutionRetryConfig);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OtaProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Collection<String> getTarget() {
            if (target instanceof SdkAutoConstructList) {
                return null;
            }
            return target;
        }

        public final void setTarget(Collection<String> target) {
            this.target = TargetCopier.copy(target);
        }

        @Override
        public final Builder target(Collection<String> target) {
            this.target = TargetCopier.copy(target);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder target(String... target) {
            target(Arrays.asList(target));
            return this;
        }

        public final String getTaskConfigurationId() {
            return taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final String getOtaMechanism() {
            return otaMechanism;
        }

        public final void setOtaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
        }

        @Override
        public final Builder otaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
            return this;
        }

        @Override
        public final Builder otaMechanism(OtaMechanism otaMechanism) {
            this.otaMechanism(otaMechanism == null ? null : otaMechanism.toString());
            return this;
        }

        public final String getOtaType() {
            return otaType;
        }

        public final void setOtaType(String otaType) {
            this.otaType = otaType;
        }

        @Override
        public final Builder otaType(String otaType) {
            this.otaType = otaType;
            return this;
        }

        @Override
        public final Builder otaType(OtaType otaType) {
            this.otaType(otaType == null ? null : otaType.toString());
            return this;
        }

        public final String getOtaTargetQueryString() {
            return otaTargetQueryString;
        }

        public final void setOtaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
        }

        @Override
        public final Builder otaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final OtaTaskSchedulingConfig.Builder getOtaSchedulingConfig() {
            return otaSchedulingConfig != null ? otaSchedulingConfig.toBuilder() : null;
        }

        public final void setOtaSchedulingConfig(OtaTaskSchedulingConfig.BuilderImpl otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig != null ? otaSchedulingConfig.build() : null;
        }

        @Override
        public final Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig;
            return this;
        }

        public final OtaTaskExecutionRetryConfig.Builder getOtaTaskExecutionRetryConfig() {
            return otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.toBuilder() : null;
        }

        public final void setOtaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.BuilderImpl otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.build() : null;
        }

        @Override
        public final Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaTaskRequest build() {
            return new CreateOtaTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
