/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe the device using the relevant metadata and supported clusters for device discovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceId").getter(getter(Device::connectorDeviceId)).setter(setter(Builder::connectorDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()).build();

    private static final SdkField<String> CONNECTOR_DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceName").getter(getter(Device::connectorDeviceName))
            .setter(setter(Builder::connectorDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceName").build())
            .build();

    private static final SdkField<MatterCapabilityReport> CAPABILITY_REPORT_FIELD = SdkField
            .<MatterCapabilityReport> builder(MarshallingType.SDK_POJO).memberName("CapabilityReport")
            .getter(getter(Device::capabilityReport)).setter(setter(Builder::capabilityReport))
            .constructor(MatterCapabilityReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()).build();

    private static final SdkField<List<CapabilitySchemaItem>> CAPABILITY_SCHEMAS_FIELD = SdkField
            .<List<CapabilitySchemaItem>> builder(MarshallingType.LIST)
            .memberName("CapabilitySchemas")
            .getter(getter(Device::capabilitySchemas))
            .setter(setter(Builder::capabilitySchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitySchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapabilitySchemaItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapabilitySchemaItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Document> DEVICE_METADATA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("DeviceMetadata").getter(getter(Device::deviceMetadata)).setter(setter(Builder::deviceMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DEVICE_ID_FIELD,
            CONNECTOR_DEVICE_NAME_FIELD, CAPABILITY_REPORT_FIELD, CAPABILITY_SCHEMAS_FIELD, DEVICE_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorDeviceId;

    private final String connectorDeviceName;

    private final MatterCapabilityReport capabilityReport;

    private final List<CapabilitySchemaItem> capabilitySchemas;

    private final Document deviceMetadata;

    private Device(BuilderImpl builder) {
        this.connectorDeviceId = builder.connectorDeviceId;
        this.connectorDeviceName = builder.connectorDeviceName;
        this.capabilityReport = builder.capabilityReport;
        this.capabilitySchemas = builder.capabilitySchemas;
        this.deviceMetadata = builder.deviceMetadata;
    }

    /**
     * <p>
     * The device id as defined by the connector.
     * </p>
     * <note>
     * <p>
     * This parameter is used for cloud-to-cloud devices only.
     * </p>
     * </note>
     * 
     * @return The device id as defined by the connector.</p> <note>
     *         <p>
     *         This parameter is used for cloud-to-cloud devices only.
     *         </p>
     */
    public final String connectorDeviceId() {
        return connectorDeviceId;
    }

    /**
     * <p>
     * The name of the device as defined by the connector.
     * </p>
     * 
     * @return The name of the device as defined by the connector.
     */
    public final String connectorDeviceName() {
        return connectorDeviceName;
    }

    /**
     * <p>
     * The capability report for the device.
     * </p>
     * 
     * @return The capability report for the device.
     */
    public final MatterCapabilityReport capabilityReport() {
        return capabilityReport;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapabilitySchemas property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilitySchemas() {
        return capabilitySchemas != null && !(capabilitySchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Report of all capabilities supported by the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilitySchemas} method.
     * </p>
     * 
     * @return Report of all capabilities supported by the device.
     */
    public final List<CapabilitySchemaItem> capabilitySchemas() {
        return capabilitySchemas;
    }

    /**
     * <p>
     * The metadata attributes for a device.
     * </p>
     * 
     * @return The metadata attributes for a device.
     */
    public final Document deviceMetadata() {
        return deviceMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityReport());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilitySchemas() ? capabilitySchemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(connectorDeviceId(), other.connectorDeviceId())
                && Objects.equals(connectorDeviceName(), other.connectorDeviceName())
                && Objects.equals(capabilityReport(), other.capabilityReport())
                && hasCapabilitySchemas() == other.hasCapabilitySchemas()
                && Objects.equals(capabilitySchemas(), other.capabilitySchemas())
                && Objects.equals(deviceMetadata(), other.deviceMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device")
                .add("ConnectorDeviceId", connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorDeviceName", connectorDeviceName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CapabilityReport", capabilityReport())
                .add("CapabilitySchemas", hasCapabilitySchemas() ? capabilitySchemas() : null)
                .add("DeviceMetadata", deviceMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorDeviceId":
            return Optional.ofNullable(clazz.cast(connectorDeviceId()));
        case "ConnectorDeviceName":
            return Optional.ofNullable(clazz.cast(connectorDeviceName()));
        case "CapabilityReport":
            return Optional.ofNullable(clazz.cast(capabilityReport()));
        case "CapabilitySchemas":
            return Optional.ofNullable(clazz.cast(capabilitySchemas()));
        case "DeviceMetadata":
            return Optional.ofNullable(clazz.cast(deviceMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("ConnectorDeviceName", CONNECTOR_DEVICE_NAME_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        map.put("CapabilitySchemas", CAPABILITY_SCHEMAS_FIELD);
        map.put("DeviceMetadata", DEVICE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device id as defined by the connector.
         * </p>
         * <note>
         * <p>
         * This parameter is used for cloud-to-cloud devices only.
         * </p>
         * </note>
         * 
         * @param connectorDeviceId
         *        The device id as defined by the connector.</p> <note>
         *        <p>
         *        This parameter is used for cloud-to-cloud devices only.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceId(String connectorDeviceId);

        /**
         * <p>
         * The name of the device as defined by the connector.
         * </p>
         * 
         * @param connectorDeviceName
         *        The name of the device as defined by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceName(String connectorDeviceName);

        /**
         * <p>
         * The capability report for the device.
         * </p>
         * 
         * @param capabilityReport
         *        The capability report for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityReport(MatterCapabilityReport capabilityReport);

        /**
         * <p>
         * The capability report for the device.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatterCapabilityReport.Builder} avoiding
         * the need to create one manually via {@link MatterCapabilityReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatterCapabilityReport.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilityReport(MatterCapabilityReport)}.
         * 
         * @param capabilityReport
         *        a consumer that will call methods on {@link MatterCapabilityReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityReport(MatterCapabilityReport)
         */
        default Builder capabilityReport(Consumer<MatterCapabilityReport.Builder> capabilityReport) {
            return capabilityReport(MatterCapabilityReport.builder().applyMutation(capabilityReport).build());
        }

        /**
         * <p>
         * Report of all capabilities supported by the device.
         * </p>
         * 
         * @param capabilitySchemas
         *        Report of all capabilities supported by the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitySchemas(Collection<CapabilitySchemaItem> capabilitySchemas);

        /**
         * <p>
         * Report of all capabilities supported by the device.
         * </p>
         * 
         * @param capabilitySchemas
         *        Report of all capabilities supported by the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitySchemas(CapabilitySchemaItem... capabilitySchemas);

        /**
         * <p>
         * Report of all capabilities supported by the device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder#build()} is
         * called immediately and its result is passed to {@link #capabilitySchemas(List<CapabilitySchemaItem>)}.
         * 
         * @param capabilitySchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilitySchemas(java.util.Collection<CapabilitySchemaItem>)
         */
        Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder>... capabilitySchemas);

        /**
         * <p>
         * The metadata attributes for a device.
         * </p>
         * 
         * @param deviceMetadata
         *        The metadata attributes for a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMetadata(Document deviceMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String connectorDeviceId;

        private String connectorDeviceName;

        private MatterCapabilityReport capabilityReport;

        private List<CapabilitySchemaItem> capabilitySchemas = DefaultSdkAutoConstructList.getInstance();

        private Document deviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            connectorDeviceId(model.connectorDeviceId);
            connectorDeviceName(model.connectorDeviceName);
            capabilityReport(model.capabilityReport);
            capabilitySchemas(model.capabilitySchemas);
            deviceMetadata(model.deviceMetadata);
        }

        public final String getConnectorDeviceId() {
            return connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getConnectorDeviceName() {
            return connectorDeviceName;
        }

        public final void setConnectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
        }

        @Override
        public final Builder connectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
            return this;
        }

        public final MatterCapabilityReport.Builder getCapabilityReport() {
            return capabilityReport != null ? capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(MatterCapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(MatterCapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        public final List<CapabilitySchemaItem.Builder> getCapabilitySchemas() {
            List<CapabilitySchemaItem.Builder> result = CapabilitySchemasCopier.copyToBuilder(this.capabilitySchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilitySchemas(Collection<CapabilitySchemaItem.BuilderImpl> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copyFromBuilder(capabilitySchemas);
        }

        @Override
        public final Builder capabilitySchemas(Collection<CapabilitySchemaItem> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copy(capabilitySchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(CapabilitySchemaItem... capabilitySchemas) {
            capabilitySchemas(Arrays.asList(capabilitySchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder>... capabilitySchemas) {
            capabilitySchemas(Stream.of(capabilitySchemas).map(c -> CapabilitySchemaItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Document getDeviceMetadata() {
            return deviceMetadata;
        }

        public final void setDeviceMetadata(Document deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
        }

        @Override
        public final Builder deviceMetadata(Document deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
