/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing summary information about a device discovery job, including its identifier, type, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceDiscoverySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceDiscoverySummary.Builder, DeviceDiscoverySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DeviceDiscoverySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryType").getter(getter(DeviceDiscoverySummary::discoveryTypeAsString))
            .setter(setter(Builder::discoveryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeviceDiscoverySummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DISCOVERY_TYPE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String discoveryType;

    private final String status;

    private DeviceDiscoverySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.discoveryType = builder.discoveryType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the device discovery job.
     * </p>
     * 
     * @return The unique identifier of the device discovery job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of discovery process used to find devices.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The type of discovery process used to find devices.
     * @see DiscoveryType
     */
    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(discoveryType);
    }

    /**
     * <p>
     * The type of discovery process used to find devices.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The type of discovery process used to find devices.
     * @see DiscoveryType
     */
    public final String discoveryTypeAsString() {
        return discoveryType;
    }

    /**
     * <p>
     * The current status of the device discovery job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the device discovery job.
     * @see DeviceDiscoveryStatus
     */
    public final DeviceDiscoveryStatus status() {
        return DeviceDiscoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the device discovery job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the device discovery job.
     * @see DeviceDiscoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDiscoverySummary)) {
            return false;
        }
        DeviceDiscoverySummary other = (DeviceDiscoverySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(discoveryTypeAsString(), other.discoveryTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceDiscoverySummary").add("Id", id()).add("DiscoveryType", discoveryTypeAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DiscoveryType":
            return Optional.ofNullable(clazz.cast(discoveryTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceDiscoverySummary, T> g) {
        return obj -> g.apply((DeviceDiscoverySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceDiscoverySummary> {
        /**
         * <p>
         * The unique identifier of the device discovery job.
         * </p>
         * 
         * @param id
         *        The unique identifier of the device discovery job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of discovery process used to find devices.
         * </p>
         * 
         * @param discoveryType
         *        The type of discovery process used to find devices.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(String discoveryType);

        /**
         * <p>
         * The type of discovery process used to find devices.
         * </p>
         * 
         * @param discoveryType
         *        The type of discovery process used to find devices.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(DiscoveryType discoveryType);

        /**
         * <p>
         * The current status of the device discovery job.
         * </p>
         * 
         * @param status
         *        The current status of the device discovery job.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the device discovery job.
         * </p>
         * 
         * @param status
         *        The current status of the device discovery job.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder status(DeviceDiscoveryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String discoveryType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDiscoverySummary model) {
            id(model.id);
            discoveryType(model.discoveryType);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDiscoveryType() {
            return discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeviceDiscoverySummary build() {
            return new DeviceDiscoverySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
