/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DisconnectReasonValue {
    AUTH_ERROR("AUTH_ERROR"),

    CLIENT_INITIATED_DISCONNECT("CLIENT_INITIATED_DISCONNECT"),

    CLIENT_ERROR("CLIENT_ERROR"),

    CONNECTION_LOST("CONNECTION_LOST"),

    DUPLICATE_CLIENTID("DUPLICATE_CLIENTID"),

    FORBIDDEN_ACCESS("FORBIDDEN_ACCESS"),

    MQTT_KEEP_ALIVE_TIMEOUT("MQTT_KEEP_ALIVE_TIMEOUT"),

    SERVER_ERROR("SERVER_ERROR"),

    SERVER_INITIATED_DISCONNECT("SERVER_INITIATED_DISCONNECT"),

    THROTTLED("THROTTLED"),

    WEBSOCKET_TTL_EXPIRATION("WEBSOCKET_TTL_EXPIRATION"),

    CUSTOMAUTH_TTL_EXPIRATION("CUSTOMAUTH_TTL_EXPIRATION"),

    UNKNOWN("UNKNOWN"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DisconnectReasonValue> VALUE_MAP = EnumUtils.uniqueIndex(DisconnectReasonValue.class,
            DisconnectReasonValue::toString);

    private final String value;

    private DisconnectReasonValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DisconnectReasonValue corresponding to the value
     */
    public static DisconnectReasonValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DisconnectReasonValue}s
     */
    public static Set<DisconnectReasonValue> knownValues() {
        Set<DisconnectReasonValue> knownValues = EnumSet.allOf(DisconnectReasonValue.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
