/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing exponential rate of rollout for an over-the-air (OTA) task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExponentialRolloutRate implements SdkPojo, Serializable,
        ToCopyableBuilder<ExponentialRolloutRate.Builder, ExponentialRolloutRate> {
    private static final SdkField<Integer> BASE_RATE_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BaseRatePerMinute").getter(getter(ExponentialRolloutRate::baseRatePerMinute))
            .setter(setter(Builder::baseRatePerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseRatePerMinute").build()).build();

    private static final SdkField<Double> INCREMENT_FACTOR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("IncrementFactor").getter(getter(ExponentialRolloutRate::incrementFactor))
            .setter(setter(Builder::incrementFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementFactor").build()).build();

    private static final SdkField<RolloutRateIncreaseCriteria> RATE_INCREASE_CRITERIA_FIELD = SdkField
            .<RolloutRateIncreaseCriteria> builder(MarshallingType.SDK_POJO).memberName("RateIncreaseCriteria")
            .getter(getter(ExponentialRolloutRate::rateIncreaseCriteria)).setter(setter(Builder::rateIncreaseCriteria))
            .constructor(RolloutRateIncreaseCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateIncreaseCriteria").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_RATE_PER_MINUTE_FIELD,
            INCREMENT_FACTOR_FIELD, RATE_INCREASE_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer baseRatePerMinute;

    private final Double incrementFactor;

    private final RolloutRateIncreaseCriteria rateIncreaseCriteria;

    private ExponentialRolloutRate(BuilderImpl builder) {
        this.baseRatePerMinute = builder.baseRatePerMinute;
        this.incrementFactor = builder.incrementFactor;
        this.rateIncreaseCriteria = builder.rateIncreaseCriteria;
    }

    /**
     * <p>
     * The base rate per minute for the rollout of an over-the-air (OTA) task.
     * </p>
     * 
     * @return The base rate per minute for the rollout of an over-the-air (OTA) task.
     */
    public final Integer baseRatePerMinute() {
        return baseRatePerMinute;
    }

    /**
     * <p>
     * The incremental factor for increasing the rollout rate of an over-the-air (OTA) task.
     * </p>
     * 
     * @return The incremental factor for increasing the rollout rate of an over-the-air (OTA) task.
     */
    public final Double incrementFactor() {
        return incrementFactor;
    }

    /**
     * <p>
     * The criteria for increasing the rollout rate of an over-the-air (OTA) task.
     * </p>
     * 
     * @return The criteria for increasing the rollout rate of an over-the-air (OTA) task.
     */
    public final RolloutRateIncreaseCriteria rateIncreaseCriteria() {
        return rateIncreaseCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseRatePerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(incrementFactor());
        hashCode = 31 * hashCode + Objects.hashCode(rateIncreaseCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExponentialRolloutRate)) {
            return false;
        }
        ExponentialRolloutRate other = (ExponentialRolloutRate) obj;
        return Objects.equals(baseRatePerMinute(), other.baseRatePerMinute())
                && Objects.equals(incrementFactor(), other.incrementFactor())
                && Objects.equals(rateIncreaseCriteria(), other.rateIncreaseCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExponentialRolloutRate").add("BaseRatePerMinute", baseRatePerMinute())
                .add("IncrementFactor", incrementFactor()).add("RateIncreaseCriteria", rateIncreaseCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseRatePerMinute":
            return Optional.ofNullable(clazz.cast(baseRatePerMinute()));
        case "IncrementFactor":
            return Optional.ofNullable(clazz.cast(incrementFactor()));
        case "RateIncreaseCriteria":
            return Optional.ofNullable(clazz.cast(rateIncreaseCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseRatePerMinute", BASE_RATE_PER_MINUTE_FIELD);
        map.put("IncrementFactor", INCREMENT_FACTOR_FIELD);
        map.put("RateIncreaseCriteria", RATE_INCREASE_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExponentialRolloutRate, T> g) {
        return obj -> g.apply((ExponentialRolloutRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExponentialRolloutRate> {
        /**
         * <p>
         * The base rate per minute for the rollout of an over-the-air (OTA) task.
         * </p>
         * 
         * @param baseRatePerMinute
         *        The base rate per minute for the rollout of an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseRatePerMinute(Integer baseRatePerMinute);

        /**
         * <p>
         * The incremental factor for increasing the rollout rate of an over-the-air (OTA) task.
         * </p>
         * 
         * @param incrementFactor
         *        The incremental factor for increasing the rollout rate of an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementFactor(Double incrementFactor);

        /**
         * <p>
         * The criteria for increasing the rollout rate of an over-the-air (OTA) task.
         * </p>
         * 
         * @param rateIncreaseCriteria
         *        The criteria for increasing the rollout rate of an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateIncreaseCriteria(RolloutRateIncreaseCriteria rateIncreaseCriteria);

        /**
         * <p>
         * The criteria for increasing the rollout rate of an over-the-air (OTA) task.
         * </p>
         * This is a convenience method that creates an instance of the {@link RolloutRateIncreaseCriteria.Builder}
         * avoiding the need to create one manually via {@link RolloutRateIncreaseCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RolloutRateIncreaseCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #rateIncreaseCriteria(RolloutRateIncreaseCriteria)}.
         * 
         * @param rateIncreaseCriteria
         *        a consumer that will call methods on {@link RolloutRateIncreaseCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateIncreaseCriteria(RolloutRateIncreaseCriteria)
         */
        default Builder rateIncreaseCriteria(Consumer<RolloutRateIncreaseCriteria.Builder> rateIncreaseCriteria) {
            return rateIncreaseCriteria(RolloutRateIncreaseCriteria.builder().applyMutation(rateIncreaseCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer baseRatePerMinute;

        private Double incrementFactor;

        private RolloutRateIncreaseCriteria rateIncreaseCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ExponentialRolloutRate model) {
            baseRatePerMinute(model.baseRatePerMinute);
            incrementFactor(model.incrementFactor);
            rateIncreaseCriteria(model.rateIncreaseCriteria);
        }

        public final Integer getBaseRatePerMinute() {
            return baseRatePerMinute;
        }

        public final void setBaseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
        }

        @Override
        public final Builder baseRatePerMinute(Integer baseRatePerMinute) {
            this.baseRatePerMinute = baseRatePerMinute;
            return this;
        }

        public final Double getIncrementFactor() {
            return incrementFactor;
        }

        public final void setIncrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
        }

        @Override
        public final Builder incrementFactor(Double incrementFactor) {
            this.incrementFactor = incrementFactor;
            return this;
        }

        public final RolloutRateIncreaseCriteria.Builder getRateIncreaseCriteria() {
            return rateIncreaseCriteria != null ? rateIncreaseCriteria.toBuilder() : null;
        }

        public final void setRateIncreaseCriteria(RolloutRateIncreaseCriteria.BuilderImpl rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria != null ? rateIncreaseCriteria.build() : null;
        }

        @Override
        public final Builder rateIncreaseCriteria(RolloutRateIncreaseCriteria rateIncreaseCriteria) {
            this.rateIncreaseCriteria = rateIncreaseCriteria;
            return this;
        }

        @Override
        public ExponentialRolloutRate build() {
            return new ExponentialRolloutRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
