/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectorDestinationResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetConnectorDestinationResponse.Builder, GetConnectorDestinationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConnectorDestinationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetConnectorDestinationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLOUD_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudConnectorId").getter(getter(GetConnectorDestinationResponse::cloudConnectorId))
            .setter(setter(Builder::cloudConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudConnectorId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetConnectorDestinationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(GetConnectorDestinationResponse::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<AuthConfig> AUTH_CONFIG_FIELD = SdkField.<AuthConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AuthConfig").getter(getter(GetConnectorDestinationResponse::authConfig))
            .setter(setter(Builder::authConfig)).constructor(AuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthConfig").build()).build();

    private static final SdkField<SecretsManager> SECRETS_MANAGER_FIELD = SdkField
            .<SecretsManager> builder(MarshallingType.SDK_POJO).memberName("SecretsManager")
            .getter(getter(GetConnectorDestinationResponse::secretsManager)).setter(setter(Builder::secretsManager))
            .constructor(SecretsManager::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManager").build()).build();

    private static final SdkField<String> O_AUTH_COMPLETE_REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuthCompleteRedirectUrl").getter(getter(GetConnectorDestinationResponse::oAuthCompleteRedirectUrl))
            .setter(setter(Builder::oAuthCompleteRedirectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthCompleteRedirectUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CLOUD_CONNECTOR_ID_FIELD, ID_FIELD, AUTH_TYPE_FIELD, AUTH_CONFIG_FIELD, SECRETS_MANAGER_FIELD,
            O_AUTH_COMPLETE_REDIRECT_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String cloudConnectorId;

    private final String id;

    private final String authType;

    private final AuthConfig authConfig;

    private final SecretsManager secretsManager;

    private final String oAuthCompleteRedirectUrl;

    private GetConnectorDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.cloudConnectorId = builder.cloudConnectorId;
        this.id = builder.id;
        this.authType = builder.authType;
        this.authConfig = builder.authConfig;
        this.secretsManager = builder.secretsManager;
        this.oAuthCompleteRedirectUrl = builder.oAuthCompleteRedirectUrl;
    }

    /**
     * <p>
     * The display name of the connector destination.
     * </p>
     * 
     * @return The display name of the connector destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the connector destination.
     * </p>
     * 
     * @return A description of the connector destination.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the C2C connector.
     * </p>
     * 
     * @return The identifier of the C2C connector.
     */
    public final String cloudConnectorId() {
        return cloudConnectorId;
    }

    /**
     * <p>
     * The unique identifier of the connector destination.
     * </p>
     * 
     * @return The unique identifier of the connector destination.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The authentication type used for the connector destination, which determines how credentials and access are
     * managed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used for the connector destination, which determines how credentials and access
     *         are managed.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type used for the connector destination, which determines how credentials and access are
     * managed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type used for the connector destination, which determines how credentials and access
     *         are managed.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The authentication configuration details for the connector destination, including OAuth settings and other
     * authentication parameters.
     * </p>
     * 
     * @return The authentication configuration details for the connector destination, including OAuth settings and
     *         other authentication parameters.
     */
    public final AuthConfig authConfig() {
        return authConfig;
    }

    /**
     * <p>
     * The AWS Secrets Manager configuration used to securely store and manage sensitive information for the connector
     * destination.
     * </p>
     * 
     * @return The AWS Secrets Manager configuration used to securely store and manage sensitive information for the
     *         connector destination.
     */
    public final SecretsManager secretsManager() {
        return secretsManager;
    }

    /**
     * <p>
     * The URL where users are redirected after completing the OAuth authorization process for the connector
     * destination.
     * </p>
     * 
     * @return The URL where users are redirected after completing the OAuth authorization process for the connector
     *         destination.
     */
    public final String oAuthCompleteRedirectUrl() {
        return oAuthCompleteRedirectUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cloudConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authConfig());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManager());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthCompleteRedirectUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorDestinationResponse)) {
            return false;
        }
        GetConnectorDestinationResponse other = (GetConnectorDestinationResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(cloudConnectorId(), other.cloudConnectorId()) && Objects.equals(id(), other.id())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(authConfig(), other.authConfig()) && Objects.equals(secretsManager(), other.secretsManager())
                && Objects.equals(oAuthCompleteRedirectUrl(), other.oAuthCompleteRedirectUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectorDestinationResponse").add("Name", name()).add("Description", description())
                .add("CloudConnectorId", cloudConnectorId()).add("Id", id()).add("AuthType", authTypeAsString())
                .add("AuthConfig", authConfig()).add("SecretsManager", secretsManager())
                .add("OAuthCompleteRedirectUrl", oAuthCompleteRedirectUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CloudConnectorId":
            return Optional.ofNullable(clazz.cast(cloudConnectorId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "AuthConfig":
            return Optional.ofNullable(clazz.cast(authConfig()));
        case "SecretsManager":
            return Optional.ofNullable(clazz.cast(secretsManager()));
        case "OAuthCompleteRedirectUrl":
            return Optional.ofNullable(clazz.cast(oAuthCompleteRedirectUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CloudConnectorId", CLOUD_CONNECTOR_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthConfig", AUTH_CONFIG_FIELD);
        map.put("SecretsManager", SECRETS_MANAGER_FIELD);
        map.put("OAuthCompleteRedirectUrl", O_AUTH_COMPLETE_REDIRECT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorDestinationResponse, T> g) {
        return obj -> g.apply((GetConnectorDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectorDestinationResponse> {
        /**
         * <p>
         * The display name of the connector destination.
         * </p>
         * 
         * @param name
         *        The display name of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the connector destination.
         * </p>
         * 
         * @param description
         *        A description of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the C2C connector.
         * </p>
         * 
         * @param cloudConnectorId
         *        The identifier of the C2C connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudConnectorId(String cloudConnectorId);

        /**
         * <p>
         * The unique identifier of the connector destination.
         * </p>
         * 
         * @param id
         *        The unique identifier of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The authentication type used for the connector destination, which determines how credentials and access are
         * managed.
         * </p>
         * 
         * @param authType
         *        The authentication type used for the connector destination, which determines how credentials and
         *        access are managed.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type used for the connector destination, which determines how credentials and access are
         * managed.
         * </p>
         * 
         * @param authType
         *        The authentication type used for the connector destination, which determines how credentials and
         *        access are managed.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * The authentication configuration details for the connector destination, including OAuth settings and other
         * authentication parameters.
         * </p>
         * 
         * @param authConfig
         *        The authentication configuration details for the connector destination, including OAuth settings and
         *        other authentication parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfig(AuthConfig authConfig);

        /**
         * <p>
         * The authentication configuration details for the connector destination, including OAuth settings and other
         * authentication parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthConfig.Builder} avoiding the need to
         * create one manually via {@link AuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #authConfig(AuthConfig)}.
         * 
         * @param authConfig
         *        a consumer that will call methods on {@link AuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfig(AuthConfig)
         */
        default Builder authConfig(Consumer<AuthConfig.Builder> authConfig) {
            return authConfig(AuthConfig.builder().applyMutation(authConfig).build());
        }

        /**
         * <p>
         * The AWS Secrets Manager configuration used to securely store and manage sensitive information for the
         * connector destination.
         * </p>
         * 
         * @param secretsManager
         *        The AWS Secrets Manager configuration used to securely store and manage sensitive information for the
         *        connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManager(SecretsManager secretsManager);

        /**
         * <p>
         * The AWS Secrets Manager configuration used to securely store and manage sensitive information for the
         * connector destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecretsManager.Builder} avoiding the need
         * to create one manually via {@link SecretsManager#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManager.Builder#build()} is called immediately and its
         * result is passed to {@link #secretsManager(SecretsManager)}.
         * 
         * @param secretsManager
         *        a consumer that will call methods on {@link SecretsManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManager(SecretsManager)
         */
        default Builder secretsManager(Consumer<SecretsManager.Builder> secretsManager) {
            return secretsManager(SecretsManager.builder().applyMutation(secretsManager).build());
        }

        /**
         * <p>
         * The URL where users are redirected after completing the OAuth authorization process for the connector
         * destination.
         * </p>
         * 
         * @param oAuthCompleteRedirectUrl
         *        The URL where users are redirected after completing the OAuth authorization process for the connector
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String cloudConnectorId;

        private String id;

        private String authType;

        private AuthConfig authConfig;

        private SecretsManager secretsManager;

        private String oAuthCompleteRedirectUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorDestinationResponse model) {
            super(model);
            name(model.name);
            description(model.description);
            cloudConnectorId(model.cloudConnectorId);
            id(model.id);
            authType(model.authType);
            authConfig(model.authConfig);
            secretsManager(model.secretsManager);
            oAuthCompleteRedirectUrl(model.oAuthCompleteRedirectUrl);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCloudConnectorId() {
            return cloudConnectorId;
        }

        public final void setCloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
        }

        @Override
        public final Builder cloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final AuthConfig.Builder getAuthConfig() {
            return authConfig != null ? authConfig.toBuilder() : null;
        }

        public final void setAuthConfig(AuthConfig.BuilderImpl authConfig) {
            this.authConfig = authConfig != null ? authConfig.build() : null;
        }

        @Override
        public final Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public final SecretsManager.Builder getSecretsManager() {
            return secretsManager != null ? secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManager.BuilderImpl secretsManager) {
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
        }

        @Override
        public final Builder secretsManager(SecretsManager secretsManager) {
            this.secretsManager = secretsManager;
            return this;
        }

        public final String getOAuthCompleteRedirectUrl() {
            return oAuthCompleteRedirectUrl;
        }

        public final void setOAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
        }

        @Override
        public final Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
            return this;
        }

        @Override
        public GetConnectorDestinationResponse build() {
            return new GetConnectorDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
