/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceDiscoveryResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetDeviceDiscoveryResponse.Builder, GetDeviceDiscoveryResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetDeviceDiscoveryResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetDeviceDiscoveryResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryType").getter(getter(GetDeviceDiscoveryResponse::discoveryTypeAsString))
            .setter(setter(Builder::discoveryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDeviceDiscoveryResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(GetDeviceDiscoveryResponse::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<String> CONTROLLER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControllerId").getter(getter(GetDeviceDiscoveryResponse::controllerId))
            .setter(setter(Builder::controllerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControllerId").build()).build();

    private static final SdkField<String> CONNECTOR_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorAssociationId").getter(getter(GetDeviceDiscoveryResponse::connectorAssociationId))
            .setter(setter(Builder::connectorAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorAssociationId").build())
            .build();

    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(GetDeviceDiscoveryResponse::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FinishedAt").getter(getter(GetDeviceDiscoveryResponse::finishedAt)).setter(setter(Builder::finishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetDeviceDiscoveryResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DISCOVERY_TYPE_FIELD, STATUS_FIELD, STARTED_AT_FIELD, CONTROLLER_ID_FIELD, CONNECTOR_ASSOCIATION_ID_FIELD,
            ACCOUNT_ASSOCIATION_ID_FIELD, FINISHED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String discoveryType;

    private final String status;

    private final Instant startedAt;

    private final String controllerId;

    private final String connectorAssociationId;

    private final String accountAssociationId;

    private final Instant finishedAt;

    private final Map<String, String> tags;

    private GetDeviceDiscoveryResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.discoveryType = builder.discoveryType;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.controllerId = builder.controllerId;
        this.connectorAssociationId = builder.connectorAssociationId;
        this.accountAssociationId = builder.accountAssociationId;
        this.finishedAt = builder.finishedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The id of the device discovery job request.
     * </p>
     * 
     * @return The id of the device discovery job request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device discovery job request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device discovery job request.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The discovery type supporting the type of device to be discovered in the device discovery job request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The discovery type supporting the type of device to be discovered in the device discovery job request.
     * @see DiscoveryType
     */
    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(discoveryType);
    }

    /**
     * <p>
     * The discovery type supporting the type of device to be discovered in the device discovery job request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The discovery type supporting the type of device to be discovered in the device discovery job request.
     * @see DiscoveryType
     */
    public final String discoveryTypeAsString() {
        return discoveryType;
    }

    /**
     * <p>
     * The status of the device discovery job request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device discovery job request.
     * @see DeviceDiscoveryStatus
     */
    public final DeviceDiscoveryStatus status() {
        return DeviceDiscoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the device discovery job request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device discovery job request.
     * @see DeviceDiscoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp value for the start time of the device discovery.
     * </p>
     * 
     * @return The timestamp value for the start time of the device discovery.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The id of the end-user's IoT hub.
     * </p>
     * 
     * @return The id of the end-user's IoT hub.
     */
    public final String controllerId() {
        return controllerId;
    }

    /**
     * <p>
     * The ID tracking the current discovery process for one connector association.
     * </p>
     * 
     * @return The ID tracking the current discovery process for one connector association.
     * @deprecated ConnectorAssociationId has been deprecated
     */
    @Deprecated
    public final String connectorAssociationId() {
        return connectorAssociationId;
    }

    /**
     * <p>
     * The identifier of the account association used for the device discovery.
     * </p>
     * 
     * @return The identifier of the account association used for the device discovery.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The timestamp value for the completion time of the device discovery.
     * </p>
     * 
     * @return The timestamp value for the completion time of the device discovery.
     */
    public final Instant finishedAt() {
        return finishedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the device discovery request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the device discovery request.
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(controllerId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDiscoveryResponse)) {
            return false;
        }
        GetDeviceDiscoveryResponse other = (GetDeviceDiscoveryResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(discoveryTypeAsString(), other.discoveryTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(controllerId(), other.controllerId())
                && Objects.equals(connectorAssociationId(), other.connectorAssociationId())
                && Objects.equals(accountAssociationId(), other.accountAssociationId())
                && Objects.equals(finishedAt(), other.finishedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceDiscoveryResponse").add("Id", id()).add("Arn", arn())
                .add("DiscoveryType", discoveryTypeAsString()).add("Status", statusAsString()).add("StartedAt", startedAt())
                .add("ControllerId", controllerId()).add("ConnectorAssociationId", connectorAssociationId())
                .add("AccountAssociationId", accountAssociationId()).add("FinishedAt", finishedAt())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DiscoveryType":
            return Optional.ofNullable(clazz.cast(discoveryTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "ControllerId":
            return Optional.ofNullable(clazz.cast(controllerId()));
        case "ConnectorAssociationId":
            return Optional.ofNullable(clazz.cast(connectorAssociationId()));
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "FinishedAt":
            return Optional.ofNullable(clazz.cast(finishedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("ControllerId", CONTROLLER_ID_FIELD);
        map.put("ConnectorAssociationId", CONNECTOR_ASSOCIATION_ID_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("FinishedAt", FINISHED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDiscoveryResponse, T> g) {
        return obj -> g.apply((GetDeviceDiscoveryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceDiscoveryResponse> {
        /**
         * <p>
         * The id of the device discovery job request.
         * </p>
         * 
         * @param id
         *        The id of the device discovery job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device discovery job request.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the device discovery job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The discovery type supporting the type of device to be discovered in the device discovery job request.
         * </p>
         * 
         * @param discoveryType
         *        The discovery type supporting the type of device to be discovered in the device discovery job request.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(String discoveryType);

        /**
         * <p>
         * The discovery type supporting the type of device to be discovered in the device discovery job request.
         * </p>
         * 
         * @param discoveryType
         *        The discovery type supporting the type of device to be discovered in the device discovery job request.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(DiscoveryType discoveryType);

        /**
         * <p>
         * The status of the device discovery job request.
         * </p>
         * 
         * @param status
         *        The status of the device discovery job request.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the device discovery job request.
         * </p>
         * 
         * @param status
         *        The status of the device discovery job request.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder status(DeviceDiscoveryStatus status);

        /**
         * <p>
         * The timestamp value for the start time of the device discovery.
         * </p>
         * 
         * @param startedAt
         *        The timestamp value for the start time of the device discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The id of the end-user's IoT hub.
         * </p>
         * 
         * @param controllerId
         *        The id of the end-user's IoT hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controllerId(String controllerId);

        /**
         * <p>
         * The ID tracking the current discovery process for one connector association.
         * </p>
         * 
         * @param connectorAssociationId
         *        The ID tracking the current discovery process for one connector association.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated ConnectorAssociationId has been deprecated
         */
        @Deprecated
        Builder connectorAssociationId(String connectorAssociationId);

        /**
         * <p>
         * The identifier of the account association used for the device discovery.
         * </p>
         * 
         * @param accountAssociationId
         *        The identifier of the account association used for the device discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The timestamp value for the completion time of the device discovery.
         * </p>
         * 
         * @param finishedAt
         *        The timestamp value for the completion time of the device discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedAt(Instant finishedAt);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the device discovery request.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the device discovery request.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Tags have been deprecated from this api
         */
        @Deprecated
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String discoveryType;

        private String status;

        private Instant startedAt;

        private String controllerId;

        private String connectorAssociationId;

        private String accountAssociationId;

        private Instant finishedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDiscoveryResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            discoveryType(model.discoveryType);
            status(model.status);
            startedAt(model.startedAt);
            controllerId(model.controllerId);
            connectorAssociationId(model.connectorAssociationId);
            accountAssociationId(model.accountAssociationId);
            finishedAt(model.finishedAt);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDiscoveryType() {
            return discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getControllerId() {
            return controllerId;
        }

        public final void setControllerId(String controllerId) {
            this.controllerId = controllerId;
        }

        @Override
        public final Builder controllerId(String controllerId) {
            this.controllerId = controllerId;
            return this;
        }

        @Deprecated
        public final String getConnectorAssociationId() {
            return connectorAssociationId;
        }

        @Deprecated
        public final void setConnectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
        }

        @Override
        @Deprecated
        public final Builder connectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
            return this;
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final Instant getFinishedAt() {
            return finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDeviceDiscoveryResponse build() {
            return new GetDeviceDiscoveryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
