/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedThingConnectivityDataResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetManagedThingConnectivityDataResponse.Builder, GetManagedThingConnectivityDataResponse> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(GetManagedThingConnectivityDataResponse::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final SdkField<Boolean> CONNECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Connected").getter(getter(GetManagedThingConnectivityDataResponse::connected))
            .setter(setter(Builder::connected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connected").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(GetManagedThingConnectivityDataResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> DISCONNECT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisconnectReason").getter(getter(GetManagedThingConnectivityDataResponse::disconnectReasonAsString))
            .setter(setter(Builder::disconnectReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            CONNECTED_FIELD, TIMESTAMP_FIELD, DISCONNECT_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final Boolean connected;

    private final Instant timestamp;

    private final String disconnectReason;

    private GetManagedThingConnectivityDataResponse(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.connected = builder.connected;
        this.timestamp = builder.timestamp;
        this.disconnectReason = builder.disconnectReason;
    }

    /**
     * <p>
     * The id of a managed thing.
     * </p>
     * 
     * @return The id of a managed thing.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The connectivity status for a managed thing.
     * </p>
     * 
     * @return The connectivity status for a managed thing.
     */
    public final Boolean connected() {
        return connected;
    }

    /**
     * <p>
     * The timestamp value of when the connectivity status for a managed thing was last taken.
     * </p>
     * 
     * @return The timestamp value of when the connectivity status for a managed thing was last taken.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The reason for the connectivity disconnect with the managed thing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disconnectReason}
     * will return {@link DisconnectReasonValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #disconnectReasonAsString}.
     * </p>
     * 
     * @return The reason for the connectivity disconnect with the managed thing.
     * @see DisconnectReasonValue
     */
    public final DisconnectReasonValue disconnectReason() {
        return DisconnectReasonValue.fromValue(disconnectReason);
    }

    /**
     * <p>
     * The reason for the connectivity disconnect with the managed thing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #disconnectReason}
     * will return {@link DisconnectReasonValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #disconnectReasonAsString}.
     * </p>
     * 
     * @return The reason for the connectivity disconnect with the managed thing.
     * @see DisconnectReasonValue
     */
    public final String disconnectReasonAsString() {
        return disconnectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(connected());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingConnectivityDataResponse)) {
            return false;
        }
        GetManagedThingConnectivityDataResponse other = (GetManagedThingConnectivityDataResponse) obj;
        return Objects.equals(managedThingId(), other.managedThingId()) && Objects.equals(connected(), other.connected())
                && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(disconnectReasonAsString(), other.disconnectReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedThingConnectivityDataResponse").add("ManagedThingId", managedThingId())
                .add("Connected", connected()).add("Timestamp", timestamp()).add("DisconnectReason", disconnectReasonAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "Connected":
            return Optional.ofNullable(clazz.cast(connected()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "DisconnectReason":
            return Optional.ofNullable(clazz.cast(disconnectReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Connected", CONNECTED_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("DisconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingConnectivityDataResponse, T> g) {
        return obj -> g.apply((GetManagedThingConnectivityDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedThingConnectivityDataResponse> {
        /**
         * <p>
         * The id of a managed thing.
         * </p>
         * 
         * @param managedThingId
         *        The id of a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The connectivity status for a managed thing.
         * </p>
         * 
         * @param connected
         *        The connectivity status for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connected(Boolean connected);

        /**
         * <p>
         * The timestamp value of when the connectivity status for a managed thing was last taken.
         * </p>
         * 
         * @param timestamp
         *        The timestamp value of when the connectivity status for a managed thing was last taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The reason for the connectivity disconnect with the managed thing.
         * </p>
         * 
         * @param disconnectReason
         *        The reason for the connectivity disconnect with the managed thing.
         * @see DisconnectReasonValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisconnectReasonValue
         */
        Builder disconnectReason(String disconnectReason);

        /**
         * <p>
         * The reason for the connectivity disconnect with the managed thing.
         * </p>
         * 
         * @param disconnectReason
         *        The reason for the connectivity disconnect with the managed thing.
         * @see DisconnectReasonValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisconnectReasonValue
         */
        Builder disconnectReason(DisconnectReasonValue disconnectReason);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String managedThingId;

        private Boolean connected;

        private Instant timestamp;

        private String disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingConnectivityDataResponse model) {
            super(model);
            managedThingId(model.managedThingId);
            connected(model.connected);
            timestamp(model.timestamp);
            disconnectReason(model.disconnectReason);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final Boolean getConnected() {
            return connected;
        }

        public final void setConnected(Boolean connected) {
            this.connected = connected;
        }

        @Override
        public final Builder connected(Boolean connected) {
            this.connected = connected;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getDisconnectReason() {
            return disconnectReason;
        }

        public final void setDisconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
        }

        @Override
        public final Builder disconnectReason(String disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public final Builder disconnectReason(DisconnectReasonValue disconnectReason) {
            this.disconnectReason(disconnectReason == null ? null : disconnectReason.toString());
            return this;
        }

        @Override
        public GetManagedThingConnectivityDataResponse build() {
            return new GetManagedThingConnectivityDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
