/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOtaTaskResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetOtaTaskResponse.Builder, GetOtaTaskResponse> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(GetOtaTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(GetOtaTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetOtaTaskResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(GetOtaTaskResponse::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(GetOtaTaskResponse::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> OTA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaType").getter(getter(GetOtaTaskResponse::otaTypeAsString)).setter(setter(Builder::otaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaType").build()).build();

    private static final SdkField<String> OTA_TARGET_QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaTargetQueryString").getter(getter(GetOtaTaskResponse::otaTargetQueryString))
            .setter(setter(Builder::otaTargetQueryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTargetQueryString").build())
            .build();

    private static final SdkField<String> OTA_MECHANISM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtaMechanism").getter(getter(GetOtaTaskResponse::otaMechanismAsString))
            .setter(setter(Builder::otaMechanism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaMechanism").build()).build();

    private static final SdkField<List<String>> TARGET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Target")
            .getter(getter(GetOtaTaskResponse::target))
            .setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetOtaTaskResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetOtaTaskResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskConfigurationId").getter(getter(GetOtaTaskResponse::taskConfigurationId))
            .setter(setter(Builder::taskConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build())
            .build();

    private static final SdkField<TaskProcessingDetails> TASK_PROCESSING_DETAILS_FIELD = SdkField
            .<TaskProcessingDetails> builder(MarshallingType.SDK_POJO).memberName("TaskProcessingDetails")
            .getter(getter(GetOtaTaskResponse::taskProcessingDetails)).setter(setter(Builder::taskProcessingDetails))
            .constructor(TaskProcessingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskProcessingDetails").build())
            .build();

    private static final SdkField<OtaTaskSchedulingConfig> OTA_SCHEDULING_CONFIG_FIELD = SdkField
            .<OtaTaskSchedulingConfig> builder(MarshallingType.SDK_POJO).memberName("OtaSchedulingConfig")
            .getter(getter(GetOtaTaskResponse::otaSchedulingConfig)).setter(setter(Builder::otaSchedulingConfig))
            .constructor(OtaTaskSchedulingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaSchedulingConfig").build())
            .build();

    private static final SdkField<OtaTaskExecutionRetryConfig> OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD = SdkField
            .<OtaTaskExecutionRetryConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OtaTaskExecutionRetryConfig")
            .getter(getter(GetOtaTaskResponse::otaTaskExecutionRetryConfig))
            .setter(setter(Builder::otaTaskExecutionRetryConfig))
            .constructor(OtaTaskExecutionRetryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaTaskExecutionRetryConfig")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetOtaTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetOtaTaskResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD,
            DESCRIPTION_FIELD, S3_URL_FIELD, PROTOCOL_FIELD, OTA_TYPE_FIELD, OTA_TARGET_QUERY_STRING_FIELD, OTA_MECHANISM_FIELD,
            TARGET_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TASK_CONFIGURATION_ID_FIELD, TASK_PROCESSING_DETAILS_FIELD,
            OTA_SCHEDULING_CONFIG_FIELD, OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskId;

    private final String taskArn;

    private final String description;

    private final String s3Url;

    private final String protocol;

    private final String otaType;

    private final String otaTargetQueryString;

    private final String otaMechanism;

    private final List<String> target;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String taskConfigurationId;

    private final TaskProcessingDetails taskProcessingDetails;

    private final OtaTaskSchedulingConfig otaSchedulingConfig;

    private final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;

    private final String status;

    private final Map<String, String> tags;

    private GetOtaTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.description = builder.description;
        this.s3Url = builder.s3Url;
        this.protocol = builder.protocol;
        this.otaType = builder.otaType;
        this.otaTargetQueryString = builder.otaTargetQueryString;
        this.otaMechanism = builder.otaMechanism;
        this.target = builder.target;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.taskProcessingDetails = builder.taskProcessingDetails;
        this.otaSchedulingConfig = builder.otaSchedulingConfig;
        this.otaTaskExecutionRetryConfig = builder.otaTaskExecutionRetryConfig;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The id of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The id of the over-the-air (OTA) task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the over-the-air (OTA) task
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the over-the-air (OTA) task
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The description of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The description of the over-the-air (OTA) task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
     * </p>
     * 
     * @return The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
     */
    public final String s3Url() {
        return s3Url;
    }

    /**
     * <p>
     * The connection protocol the over-the-air (OTA) task uses to update the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OtaProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The connection protocol the over-the-air (OTA) task uses to update the device.
     * @see OtaProtocol
     */
    public final OtaProtocol protocol() {
        return OtaProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The connection protocol the over-the-air (OTA) task uses to update the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link OtaProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The connection protocol the over-the-air (OTA) task uses to update the device.
     * @see OtaProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The frequency type for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaType} will
     * return {@link OtaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaTypeAsString}.
     * </p>
     * 
     * @return The frequency type for the over-the-air (OTA) task.
     * @see OtaType
     */
    public final OtaType otaType() {
        return OtaType.fromValue(otaType);
    }

    /**
     * <p>
     * The frequency type for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaType} will
     * return {@link OtaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaTypeAsString}.
     * </p>
     * 
     * @return The frequency type for the over-the-air (OTA) task.
     * @see OtaType
     */
    public final String otaTypeAsString() {
        return otaType;
    }

    /**
     * <p>
     * The query string to add things to the thing group.
     * </p>
     * 
     * @return The query string to add things to the thing group.
     */
    public final String otaTargetQueryString() {
        return otaTargetQueryString;
    }

    /**
     * <p>
     * The deployment mechanism for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaMechanism} will
     * return {@link OtaMechanism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaMechanismAsString}.
     * </p>
     * 
     * @return The deployment mechanism for the over-the-air (OTA) task.
     * @see OtaMechanism
     */
    public final OtaMechanism otaMechanism() {
        return OtaMechanism.fromValue(otaMechanism);
    }

    /**
     * <p>
     * The deployment mechanism for the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaMechanism} will
     * return {@link OtaMechanism#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #otaMechanismAsString}.
     * </p>
     * 
     * @return The deployment mechanism for the over-the-air (OTA) task.
     * @see OtaMechanism
     */
    public final String otaMechanismAsString() {
        return otaMechanism;
    }

    /**
     * For responses, this returns true if the service returned a value for the Target property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTarget() {
        return target != null && !(target instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device targeted for the over-the-air (OTA) task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTarget} method.
     * </p>
     * 
     * @return The device targeted for the over-the-air (OTA) task.
     */
    public final List<String> target() {
        return target;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task was created.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task was last updated at.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task was last updated at.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The identifier for the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return The identifier for the over-the-air (OTA) task configuration.
     */
    public final String taskConfigurationId() {
        return taskConfigurationId;
    }

    /**
     * <p>
     * The processing details of all over-the-air (OTA) tasks.
     * </p>
     * 
     * @return The processing details of all over-the-air (OTA) tasks.
     */
    public final TaskProcessingDetails taskProcessingDetails() {
        return taskProcessingDetails;
    }

    /**
     * Returns the value of the OtaSchedulingConfig property for this object.
     * 
     * @return The value of the OtaSchedulingConfig property for this object.
     */
    public final OtaTaskSchedulingConfig otaSchedulingConfig() {
        return otaSchedulingConfig;
    }

    /**
     * Returns the value of the OtaTaskExecutionRetryConfig property for this object.
     * 
     * @return The value of the OtaTaskExecutionRetryConfig property for this object.
     */
    public final OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig() {
        return otaTaskExecutionRetryConfig;
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task.
     * @see OtaStatus
     */
    public final OtaStatus status() {
        return OtaStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task.
     * @see OtaStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the over-the-air (OTA) task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the over-the-air (OTA) task.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otaTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otaTargetQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(otaMechanismAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTarget() ? target() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(taskProcessingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(otaSchedulingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(otaTaskExecutionRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOtaTaskResponse)) {
            return false;
        }
        GetOtaTaskResponse other = (GetOtaTaskResponse) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(description(), other.description()) && Objects.equals(s3Url(), other.s3Url())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(otaTypeAsString(), other.otaTypeAsString())
                && Objects.equals(otaTargetQueryString(), other.otaTargetQueryString())
                && Objects.equals(otaMechanismAsString(), other.otaMechanismAsString()) && hasTarget() == other.hasTarget()
                && Objects.equals(target(), other.target()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(taskConfigurationId(), other.taskConfigurationId())
                && Objects.equals(taskProcessingDetails(), other.taskProcessingDetails())
                && Objects.equals(otaSchedulingConfig(), other.otaSchedulingConfig())
                && Objects.equals(otaTaskExecutionRetryConfig(), other.otaTaskExecutionRetryConfig())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOtaTaskResponse").add("TaskId", taskId()).add("TaskArn", taskArn())
                .add("Description", description()).add("S3Url", s3Url()).add("Protocol", protocolAsString())
                .add("OtaType", otaTypeAsString()).add("OtaTargetQueryString", otaTargetQueryString())
                .add("OtaMechanism", otaMechanismAsString()).add("Target", hasTarget() ? target() : null)
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("TaskConfigurationId", taskConfigurationId()).add("TaskProcessingDetails", taskProcessingDetails())
                .add("OtaSchedulingConfig", otaSchedulingConfig())
                .add("OtaTaskExecutionRetryConfig", otaTaskExecutionRetryConfig()).add("Status", statusAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "OtaType":
            return Optional.ofNullable(clazz.cast(otaTypeAsString()));
        case "OtaTargetQueryString":
            return Optional.ofNullable(clazz.cast(otaTargetQueryString()));
        case "OtaMechanism":
            return Optional.ofNullable(clazz.cast(otaMechanismAsString()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "TaskConfigurationId":
            return Optional.ofNullable(clazz.cast(taskConfigurationId()));
        case "TaskProcessingDetails":
            return Optional.ofNullable(clazz.cast(taskProcessingDetails()));
        case "OtaSchedulingConfig":
            return Optional.ofNullable(clazz.cast(otaSchedulingConfig()));
        case "OtaTaskExecutionRetryConfig":
            return Optional.ofNullable(clazz.cast(otaTaskExecutionRetryConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("OtaType", OTA_TYPE_FIELD);
        map.put("OtaTargetQueryString", OTA_TARGET_QUERY_STRING_FIELD);
        map.put("OtaMechanism", OTA_MECHANISM_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("TaskProcessingDetails", TASK_PROCESSING_DETAILS_FIELD);
        map.put("OtaSchedulingConfig", OTA_SCHEDULING_CONFIG_FIELD);
        map.put("OtaTaskExecutionRetryConfig", OTA_TASK_EXECUTION_RETRY_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOtaTaskResponse, T> g) {
        return obj -> g.apply((GetOtaTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOtaTaskResponse> {
        /**
         * <p>
         * The id of the over-the-air (OTA) task.
         * </p>
         * 
         * @param taskId
         *        The id of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the over-the-air (OTA) task
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the over-the-air (OTA) task
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The description of the over-the-air (OTA) task.
         * </p>
         * 
         * @param description
         *        The description of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
         * </p>
         * 
         * @param s3Url
         *        The URL to the Amazon S3 bucket where the over-the-air (OTA) task is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * <p>
         * The connection protocol the over-the-air (OTA) task uses to update the device.
         * </p>
         * 
         * @param protocol
         *        The connection protocol the over-the-air (OTA) task uses to update the device.
         * @see OtaProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The connection protocol the over-the-air (OTA) task uses to update the device.
         * </p>
         * 
         * @param protocol
         *        The connection protocol the over-the-air (OTA) task uses to update the device.
         * @see OtaProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaProtocol
         */
        Builder protocol(OtaProtocol protocol);

        /**
         * <p>
         * The frequency type for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaType
         *        The frequency type for the over-the-air (OTA) task.
         * @see OtaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaType
         */
        Builder otaType(String otaType);

        /**
         * <p>
         * The frequency type for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaType
         *        The frequency type for the over-the-air (OTA) task.
         * @see OtaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaType
         */
        Builder otaType(OtaType otaType);

        /**
         * <p>
         * The query string to add things to the thing group.
         * </p>
         * 
         * @param otaTargetQueryString
         *        The query string to add things to the thing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaTargetQueryString(String otaTargetQueryString);

        /**
         * <p>
         * The deployment mechanism for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaMechanism
         *        The deployment mechanism for the over-the-air (OTA) task.
         * @see OtaMechanism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaMechanism
         */
        Builder otaMechanism(String otaMechanism);

        /**
         * <p>
         * The deployment mechanism for the over-the-air (OTA) task.
         * </p>
         * 
         * @param otaMechanism
         *        The deployment mechanism for the over-the-air (OTA) task.
         * @see OtaMechanism
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaMechanism
         */
        Builder otaMechanism(OtaMechanism otaMechanism);

        /**
         * <p>
         * The device targeted for the over-the-air (OTA) task.
         * </p>
         * 
         * @param target
         *        The device targeted for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Collection<String> target);

        /**
         * <p>
         * The device targeted for the over-the-air (OTA) task.
         * </p>
         * 
         * @param target
         *        The device targeted for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String... target);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp value of when the over-the-air (OTA) task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task was last updated at.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp value of when the over-the-air (OTA) task was last updated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The identifier for the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param taskConfigurationId
         *        The identifier for the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfigurationId(String taskConfigurationId);

        /**
         * <p>
         * The processing details of all over-the-air (OTA) tasks.
         * </p>
         * 
         * @param taskProcessingDetails
         *        The processing details of all over-the-air (OTA) tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProcessingDetails(TaskProcessingDetails taskProcessingDetails);

        /**
         * <p>
         * The processing details of all over-the-air (OTA) tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskProcessingDetails.Builder} avoiding
         * the need to create one manually via {@link TaskProcessingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskProcessingDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #taskProcessingDetails(TaskProcessingDetails)}.
         * 
         * @param taskProcessingDetails
         *        a consumer that will call methods on {@link TaskProcessingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskProcessingDetails(TaskProcessingDetails)
         */
        default Builder taskProcessingDetails(Consumer<TaskProcessingDetails.Builder> taskProcessingDetails) {
            return taskProcessingDetails(TaskProcessingDetails.builder().applyMutation(taskProcessingDetails).build());
        }

        /**
         * Sets the value of the OtaSchedulingConfig property for this object.
         *
         * @param otaSchedulingConfig
         *        The new value for the OtaSchedulingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig);

        /**
         * Sets the value of the OtaSchedulingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OtaTaskSchedulingConfig.Builder} avoiding
         * the need to create one manually via {@link OtaTaskSchedulingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskSchedulingConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #otaSchedulingConfig(OtaTaskSchedulingConfig)}.
         * 
         * @param otaSchedulingConfig
         *        a consumer that will call methods on {@link OtaTaskSchedulingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaSchedulingConfig(OtaTaskSchedulingConfig)
         */
        default Builder otaSchedulingConfig(Consumer<OtaTaskSchedulingConfig.Builder> otaSchedulingConfig) {
            return otaSchedulingConfig(OtaTaskSchedulingConfig.builder().applyMutation(otaSchedulingConfig).build());
        }

        /**
         * Sets the value of the OtaTaskExecutionRetryConfig property for this object.
         *
         * @param otaTaskExecutionRetryConfig
         *        The new value for the OtaTaskExecutionRetryConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig);

        /**
         * Sets the value of the OtaTaskExecutionRetryConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OtaTaskExecutionRetryConfig.Builder}
         * avoiding the need to create one manually via {@link OtaTaskExecutionRetryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskExecutionRetryConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig)}.
         * 
         * @param otaTaskExecutionRetryConfig
         *        a consumer that will call methods on {@link OtaTaskExecutionRetryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig)
         */
        default Builder otaTaskExecutionRetryConfig(Consumer<OtaTaskExecutionRetryConfig.Builder> otaTaskExecutionRetryConfig) {
            return otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.builder().applyMutation(otaTaskExecutionRetryConfig)
                    .build());
        }

        /**
         * <p>
         * The status of the over-the-air (OTA) task.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task.
         * @see OtaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the over-the-air (OTA) task.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task.
         * @see OtaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaStatus
         */
        Builder status(OtaStatus status);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the over-the-air (OTA) task.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String taskId;

        private String taskArn;

        private String description;

        private String s3Url;

        private String protocol;

        private String otaType;

        private String otaTargetQueryString;

        private String otaMechanism;

        private List<String> target = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String taskConfigurationId;

        private TaskProcessingDetails taskProcessingDetails;

        private OtaTaskSchedulingConfig otaSchedulingConfig;

        private OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetOtaTaskResponse model) {
            super(model);
            taskId(model.taskId);
            taskArn(model.taskArn);
            description(model.description);
            s3Url(model.s3Url);
            protocol(model.protocol);
            otaType(model.otaType);
            otaTargetQueryString(model.otaTargetQueryString);
            otaMechanism(model.otaMechanism);
            target(model.target);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            taskConfigurationId(model.taskConfigurationId);
            taskProcessingDetails(model.taskProcessingDetails);
            otaSchedulingConfig(model.otaSchedulingConfig);
            otaTaskExecutionRetryConfig(model.otaTaskExecutionRetryConfig);
            status(model.status);
            tags(model.tags);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OtaProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getOtaType() {
            return otaType;
        }

        public final void setOtaType(String otaType) {
            this.otaType = otaType;
        }

        @Override
        public final Builder otaType(String otaType) {
            this.otaType = otaType;
            return this;
        }

        @Override
        public final Builder otaType(OtaType otaType) {
            this.otaType(otaType == null ? null : otaType.toString());
            return this;
        }

        public final String getOtaTargetQueryString() {
            return otaTargetQueryString;
        }

        public final void setOtaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
        }

        @Override
        public final Builder otaTargetQueryString(String otaTargetQueryString) {
            this.otaTargetQueryString = otaTargetQueryString;
            return this;
        }

        public final String getOtaMechanism() {
            return otaMechanism;
        }

        public final void setOtaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
        }

        @Override
        public final Builder otaMechanism(String otaMechanism) {
            this.otaMechanism = otaMechanism;
            return this;
        }

        @Override
        public final Builder otaMechanism(OtaMechanism otaMechanism) {
            this.otaMechanism(otaMechanism == null ? null : otaMechanism.toString());
            return this;
        }

        public final Collection<String> getTarget() {
            if (target instanceof SdkAutoConstructList) {
                return null;
            }
            return target;
        }

        public final void setTarget(Collection<String> target) {
            this.target = TargetCopier.copy(target);
        }

        @Override
        public final Builder target(Collection<String> target) {
            this.target = TargetCopier.copy(target);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder target(String... target) {
            target(Arrays.asList(target));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getTaskConfigurationId() {
            return taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final TaskProcessingDetails.Builder getTaskProcessingDetails() {
            return taskProcessingDetails != null ? taskProcessingDetails.toBuilder() : null;
        }

        public final void setTaskProcessingDetails(TaskProcessingDetails.BuilderImpl taskProcessingDetails) {
            this.taskProcessingDetails = taskProcessingDetails != null ? taskProcessingDetails.build() : null;
        }

        @Override
        public final Builder taskProcessingDetails(TaskProcessingDetails taskProcessingDetails) {
            this.taskProcessingDetails = taskProcessingDetails;
            return this;
        }

        public final OtaTaskSchedulingConfig.Builder getOtaSchedulingConfig() {
            return otaSchedulingConfig != null ? otaSchedulingConfig.toBuilder() : null;
        }

        public final void setOtaSchedulingConfig(OtaTaskSchedulingConfig.BuilderImpl otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig != null ? otaSchedulingConfig.build() : null;
        }

        @Override
        public final Builder otaSchedulingConfig(OtaTaskSchedulingConfig otaSchedulingConfig) {
            this.otaSchedulingConfig = otaSchedulingConfig;
            return this;
        }

        public final OtaTaskExecutionRetryConfig.Builder getOtaTaskExecutionRetryConfig() {
            return otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.toBuilder() : null;
        }

        public final void setOtaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig.BuilderImpl otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig != null ? otaTaskExecutionRetryConfig.build() : null;
        }

        @Override
        public final Builder otaTaskExecutionRetryConfig(OtaTaskExecutionRetryConfig otaTaskExecutionRetryConfig) {
            this.otaTaskExecutionRetryConfig = otaTaskExecutionRetryConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetOtaTaskResponse build() {
            return new GetOtaTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
