/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedThingsRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<ListManagedThingsRequest.Builder, ListManagedThingsRequest> {
    private static final SdkField<String> OWNER_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerFilter").getter(getter(ListManagedThingsRequest::ownerFilter)).setter(setter(Builder::ownerFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OwnerFilter").build()).build();

    private static final SdkField<String> CREDENTIAL_LOCKER_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CredentialLockerFilter")
            .getter(getter(ListManagedThingsRequest::credentialLockerFilter))
            .setter(setter(Builder::credentialLockerFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CredentialLockerFilter").build())
            .build();

    private static final SdkField<String> ROLE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleFilter").getter(getter(ListManagedThingsRequest::roleFilterAsString))
            .setter(setter(Builder::roleFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RoleFilter").build()).build();

    private static final SdkField<String> PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ParentControllerIdentifierFilter")
            .getter(getter(ListManagedThingsRequest::parentControllerIdentifierFilter))
            .setter(setter(Builder::parentControllerIdentifierFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("ParentControllerIdentifierFilter").build()).build();

    private static final SdkField<String> CONNECTOR_POLICY_ID_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectorPolicyIdFilter")
            .getter(getter(ListManagedThingsRequest::connectorPolicyIdFilter))
            .setter(setter(Builder::connectorPolicyIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectorPolicyIdFilter")
                    .build()).build();

    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDestinationIdFilter")
            .getter(getter(ListManagedThingsRequest::connectorDestinationIdFilter))
            .setter(setter(Builder::connectorDestinationIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectorDestinationIdFilter")
                    .build()).build();

    private static final SdkField<String> CONNECTOR_DEVICE_ID_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceIdFilter")
            .getter(getter(ListManagedThingsRequest::connectorDeviceIdFilter))
            .setter(setter(Builder::connectorDeviceIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectorDeviceIdFilter")
                    .build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumberFilter").getter(getter(ListManagedThingsRequest::serialNumberFilter))
            .setter(setter(Builder::serialNumberFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SerialNumberFilter").build())
            .build();

    private static final SdkField<String> PROVISIONING_STATUS_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatusFilter")
            .getter(getter(ListManagedThingsRequest::provisioningStatusFilterAsString))
            .setter(setter(Builder::provisioningStatusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProvisioningStatusFilter")
                    .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListManagedThingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListManagedThingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FILTER_FIELD,
            CREDENTIAL_LOCKER_FILTER_FIELD, ROLE_FILTER_FIELD, PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD,
            CONNECTOR_POLICY_ID_FILTER_FIELD, CONNECTOR_DESTINATION_ID_FILTER_FIELD, CONNECTOR_DEVICE_ID_FILTER_FIELD,
            SERIAL_NUMBER_FILTER_FIELD, PROVISIONING_STATUS_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ownerFilter;

    private final String credentialLockerFilter;

    private final String roleFilter;

    private final String parentControllerIdentifierFilter;

    private final String connectorPolicyIdFilter;

    private final String connectorDestinationIdFilter;

    private final String connectorDeviceIdFilter;

    private final String serialNumberFilter;

    private final String provisioningStatusFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListManagedThingsRequest(BuilderImpl builder) {
        super(builder);
        this.ownerFilter = builder.ownerFilter;
        this.credentialLockerFilter = builder.credentialLockerFilter;
        this.roleFilter = builder.roleFilter;
        this.parentControllerIdentifierFilter = builder.parentControllerIdentifierFilter;
        this.connectorPolicyIdFilter = builder.connectorPolicyIdFilter;
        this.connectorDestinationIdFilter = builder.connectorDestinationIdFilter;
        this.connectorDeviceIdFilter = builder.connectorDeviceIdFilter;
        this.serialNumberFilter = builder.serialNumberFilter;
        this.provisioningStatusFilter = builder.provisioningStatusFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filter on device owners when listing managed things.
     * </p>
     * 
     * @return Filter on device owners when listing managed things.
     */
    public final String ownerFilter() {
        return ownerFilter;
    }

    /**
     * <p>
     * Filter on a credential locker for a managed thing.
     * </p>
     * 
     * @return Filter on a credential locker for a managed thing.
     */
    public final String credentialLockerFilter() {
        return credentialLockerFilter;
    }

    /**
     * <p>
     * Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
     * device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleFilter} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleFilterAsString}.
     * </p>
     * 
     * @return Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or
     *         IoT device.
     * @see Role
     */
    public final Role roleFilter() {
        return Role.fromValue(roleFilter);
    }

    /**
     * <p>
     * Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
     * device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleFilter} will
     * return {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleFilterAsString}.
     * </p>
     * 
     * @return Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or
     *         IoT device.
     * @see Role
     */
    public final String roleFilterAsString() {
        return roleFilter;
    }

    /**
     * <p>
     * Filter on a parent controller id for a managed thing.
     * </p>
     * 
     * @return Filter on a parent controller id for a managed thing.
     */
    public final String parentControllerIdentifierFilter() {
        return parentControllerIdentifierFilter;
    }

    /**
     * <p>
     * Filter on a connector policy id for a managed thing.
     * </p>
     * 
     * @return Filter on a connector policy id for a managed thing.
     * @deprecated ConnectorPolicyIdFilter is deprecated
     */
    @Deprecated
    public final String connectorPolicyIdFilter() {
        return connectorPolicyIdFilter;
    }

    /**
     * <p>
     * Filter managed things by the connector destination ID they are associated with.
     * </p>
     * 
     * @return Filter managed things by the connector destination ID they are associated with.
     */
    public final String connectorDestinationIdFilter() {
        return connectorDestinationIdFilter;
    }

    /**
     * <p>
     * Filter managed things by the connector device ID they are associated with. When specified, only managed things
     * with this connector device ID will be returned.
     * </p>
     * 
     * @return Filter managed things by the connector device ID they are associated with. When specified, only managed
     *         things with this connector device ID will be returned.
     */
    public final String connectorDeviceIdFilter() {
        return connectorDeviceIdFilter;
    }

    /**
     * <p>
     * Filter on the serial number of the device.
     * </p>
     * 
     * @return Filter on the serial number of the device.
     */
    public final String serialNumberFilter() {
        return serialNumberFilter;
    }

    /**
     * <p>
     * Filter on the status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatusFilter} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningStatusFilterAsString}.
     * </p>
     * 
     * @return Filter on the status of the device.
     * @see ProvisioningStatus
     */
    public final ProvisioningStatus provisioningStatusFilter() {
        return ProvisioningStatus.fromValue(provisioningStatusFilter);
    }

    /**
     * <p>
     * Filter on the status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatusFilter} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningStatusFilterAsString}.
     * </p>
     * 
     * @return Filter on the status of the device.
     * @see ProvisioningStatus
     */
    public final String provisioningStatusFilterAsString() {
        return provisioningStatusFilter;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(credentialLockerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(roleFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentControllerIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(connectorPolicyIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDestinationIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumberFilter());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedThingsRequest)) {
            return false;
        }
        ListManagedThingsRequest other = (ListManagedThingsRequest) obj;
        return Objects.equals(ownerFilter(), other.ownerFilter())
                && Objects.equals(credentialLockerFilter(), other.credentialLockerFilter())
                && Objects.equals(roleFilterAsString(), other.roleFilterAsString())
                && Objects.equals(parentControllerIdentifierFilter(), other.parentControllerIdentifierFilter())
                && Objects.equals(connectorPolicyIdFilter(), other.connectorPolicyIdFilter())
                && Objects.equals(connectorDestinationIdFilter(), other.connectorDestinationIdFilter())
                && Objects.equals(connectorDeviceIdFilter(), other.connectorDeviceIdFilter())
                && Objects.equals(serialNumberFilter(), other.serialNumberFilter())
                && Objects.equals(provisioningStatusFilterAsString(), other.provisioningStatusFilterAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedThingsRequest")
                .add("OwnerFilter", ownerFilter() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CredentialLockerFilter", credentialLockerFilter()).add("RoleFilter", roleFilterAsString())
                .add("ParentControllerIdentifierFilter", parentControllerIdentifierFilter())
                .add("ConnectorPolicyIdFilter", connectorPolicyIdFilter())
                .add("ConnectorDestinationIdFilter", connectorDestinationIdFilter())
                .add("ConnectorDeviceIdFilter", connectorDeviceIdFilter() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SerialNumberFilter", serialNumberFilter() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProvisioningStatusFilter", provisioningStatusFilterAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerFilter":
            return Optional.ofNullable(clazz.cast(ownerFilter()));
        case "CredentialLockerFilter":
            return Optional.ofNullable(clazz.cast(credentialLockerFilter()));
        case "RoleFilter":
            return Optional.ofNullable(clazz.cast(roleFilterAsString()));
        case "ParentControllerIdentifierFilter":
            return Optional.ofNullable(clazz.cast(parentControllerIdentifierFilter()));
        case "ConnectorPolicyIdFilter":
            return Optional.ofNullable(clazz.cast(connectorPolicyIdFilter()));
        case "ConnectorDestinationIdFilter":
            return Optional.ofNullable(clazz.cast(connectorDestinationIdFilter()));
        case "ConnectorDeviceIdFilter":
            return Optional.ofNullable(clazz.cast(connectorDeviceIdFilter()));
        case "SerialNumberFilter":
            return Optional.ofNullable(clazz.cast(serialNumberFilter()));
        case "ProvisioningStatusFilter":
            return Optional.ofNullable(clazz.cast(provisioningStatusFilterAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerFilter", OWNER_FILTER_FIELD);
        map.put("CredentialLockerFilter", CREDENTIAL_LOCKER_FILTER_FIELD);
        map.put("RoleFilter", ROLE_FILTER_FIELD);
        map.put("ParentControllerIdentifierFilter", PARENT_CONTROLLER_IDENTIFIER_FILTER_FIELD);
        map.put("ConnectorPolicyIdFilter", CONNECTOR_POLICY_ID_FILTER_FIELD);
        map.put("ConnectorDestinationIdFilter", CONNECTOR_DESTINATION_ID_FILTER_FIELD);
        map.put("ConnectorDeviceIdFilter", CONNECTOR_DEVICE_ID_FILTER_FIELD);
        map.put("SerialNumberFilter", SERIAL_NUMBER_FILTER_FIELD);
        map.put("ProvisioningStatusFilter", PROVISIONING_STATUS_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedThingsRequest, T> g) {
        return obj -> g.apply((ListManagedThingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedThingsRequest> {
        /**
         * <p>
         * Filter on device owners when listing managed things.
         * </p>
         * 
         * @param ownerFilter
         *        Filter on device owners when listing managed things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerFilter(String ownerFilter);

        /**
         * <p>
         * Filter on a credential locker for a managed thing.
         * </p>
         * 
         * @param credentialLockerFilter
         *        Filter on a credential locker for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialLockerFilter(String credentialLockerFilter);

        /**
         * <p>
         * Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
         * device.
         * </p>
         * 
         * @param roleFilter
         *        Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device,
         *        or IoT device.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder roleFilter(String roleFilter);

        /**
         * <p>
         * Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
         * device.
         * </p>
         * 
         * @param roleFilter
         *        Filter on the type of device used. This will be the Amazon Web Services hub controller, cloud device,
         *        or IoT device.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder roleFilter(Role roleFilter);

        /**
         * <p>
         * Filter on a parent controller id for a managed thing.
         * </p>
         * 
         * @param parentControllerIdentifierFilter
         *        Filter on a parent controller id for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentControllerIdentifierFilter(String parentControllerIdentifierFilter);

        /**
         * <p>
         * Filter on a connector policy id for a managed thing.
         * </p>
         * 
         * @param connectorPolicyIdFilter
         *        Filter on a connector policy id for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated ConnectorPolicyIdFilter is deprecated
         */
        @Deprecated
        Builder connectorPolicyIdFilter(String connectorPolicyIdFilter);

        /**
         * <p>
         * Filter managed things by the connector destination ID they are associated with.
         * </p>
         * 
         * @param connectorDestinationIdFilter
         *        Filter managed things by the connector destination ID they are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDestinationIdFilter(String connectorDestinationIdFilter);

        /**
         * <p>
         * Filter managed things by the connector device ID they are associated with. When specified, only managed
         * things with this connector device ID will be returned.
         * </p>
         * 
         * @param connectorDeviceIdFilter
         *        Filter managed things by the connector device ID they are associated with. When specified, only
         *        managed things with this connector device ID will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceIdFilter(String connectorDeviceIdFilter);

        /**
         * <p>
         * Filter on the serial number of the device.
         * </p>
         * 
         * @param serialNumberFilter
         *        Filter on the serial number of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumberFilter(String serialNumberFilter);

        /**
         * <p>
         * Filter on the status of the device.
         * </p>
         * 
         * @param provisioningStatusFilter
         *        Filter on the status of the device.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatusFilter(String provisioningStatusFilter);

        /**
         * <p>
         * Filter on the status of the device.
         * </p>
         * 
         * @param provisioningStatusFilter
         *        Filter on the status of the device.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatusFilter(ProvisioningStatus provisioningStatusFilter);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String ownerFilter;

        private String credentialLockerFilter;

        private String roleFilter;

        private String parentControllerIdentifierFilter;

        private String connectorPolicyIdFilter;

        private String connectorDestinationIdFilter;

        private String connectorDeviceIdFilter;

        private String serialNumberFilter;

        private String provisioningStatusFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedThingsRequest model) {
            super(model);
            ownerFilter(model.ownerFilter);
            credentialLockerFilter(model.credentialLockerFilter);
            roleFilter(model.roleFilter);
            parentControllerIdentifierFilter(model.parentControllerIdentifierFilter);
            connectorPolicyIdFilter(model.connectorPolicyIdFilter);
            connectorDestinationIdFilter(model.connectorDestinationIdFilter);
            connectorDeviceIdFilter(model.connectorDeviceIdFilter);
            serialNumberFilter(model.serialNumberFilter);
            provisioningStatusFilter(model.provisioningStatusFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getOwnerFilter() {
            return ownerFilter;
        }

        public final void setOwnerFilter(String ownerFilter) {
            this.ownerFilter = ownerFilter;
        }

        @Override
        public final Builder ownerFilter(String ownerFilter) {
            this.ownerFilter = ownerFilter;
            return this;
        }

        public final String getCredentialLockerFilter() {
            return credentialLockerFilter;
        }

        public final void setCredentialLockerFilter(String credentialLockerFilter) {
            this.credentialLockerFilter = credentialLockerFilter;
        }

        @Override
        public final Builder credentialLockerFilter(String credentialLockerFilter) {
            this.credentialLockerFilter = credentialLockerFilter;
            return this;
        }

        public final String getRoleFilter() {
            return roleFilter;
        }

        public final void setRoleFilter(String roleFilter) {
            this.roleFilter = roleFilter;
        }

        @Override
        public final Builder roleFilter(String roleFilter) {
            this.roleFilter = roleFilter;
            return this;
        }

        @Override
        public final Builder roleFilter(Role roleFilter) {
            this.roleFilter(roleFilter == null ? null : roleFilter.toString());
            return this;
        }

        public final String getParentControllerIdentifierFilter() {
            return parentControllerIdentifierFilter;
        }

        public final void setParentControllerIdentifierFilter(String parentControllerIdentifierFilter) {
            this.parentControllerIdentifierFilter = parentControllerIdentifierFilter;
        }

        @Override
        public final Builder parentControllerIdentifierFilter(String parentControllerIdentifierFilter) {
            this.parentControllerIdentifierFilter = parentControllerIdentifierFilter;
            return this;
        }

        @Deprecated
        public final String getConnectorPolicyIdFilter() {
            return connectorPolicyIdFilter;
        }

        @Deprecated
        public final void setConnectorPolicyIdFilter(String connectorPolicyIdFilter) {
            this.connectorPolicyIdFilter = connectorPolicyIdFilter;
        }

        @Override
        @Deprecated
        public final Builder connectorPolicyIdFilter(String connectorPolicyIdFilter) {
            this.connectorPolicyIdFilter = connectorPolicyIdFilter;
            return this;
        }

        public final String getConnectorDestinationIdFilter() {
            return connectorDestinationIdFilter;
        }

        public final void setConnectorDestinationIdFilter(String connectorDestinationIdFilter) {
            this.connectorDestinationIdFilter = connectorDestinationIdFilter;
        }

        @Override
        public final Builder connectorDestinationIdFilter(String connectorDestinationIdFilter) {
            this.connectorDestinationIdFilter = connectorDestinationIdFilter;
            return this;
        }

        public final String getConnectorDeviceIdFilter() {
            return connectorDeviceIdFilter;
        }

        public final void setConnectorDeviceIdFilter(String connectorDeviceIdFilter) {
            this.connectorDeviceIdFilter = connectorDeviceIdFilter;
        }

        @Override
        public final Builder connectorDeviceIdFilter(String connectorDeviceIdFilter) {
            this.connectorDeviceIdFilter = connectorDeviceIdFilter;
            return this;
        }

        public final String getSerialNumberFilter() {
            return serialNumberFilter;
        }

        public final void setSerialNumberFilter(String serialNumberFilter) {
            this.serialNumberFilter = serialNumberFilter;
        }

        @Override
        public final Builder serialNumberFilter(String serialNumberFilter) {
            this.serialNumberFilter = serialNumberFilter;
            return this;
        }

        public final String getProvisioningStatusFilter() {
            return provisioningStatusFilter;
        }

        public final void setProvisioningStatusFilter(String provisioningStatusFilter) {
            this.provisioningStatusFilter = provisioningStatusFilter;
        }

        @Override
        public final Builder provisioningStatusFilter(String provisioningStatusFilter) {
            this.provisioningStatusFilter = provisioningStatusFilter;
            return this;
        }

        @Override
        public final Builder provisioningStatusFilter(ProvisioningStatus provisioningStatusFilter) {
            this.provisioningStatusFilter(provisioningStatusFilter == null ? null : provisioningStatusFilter.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedThingsRequest build() {
            return new ListManagedThingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
