/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaVersionsRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<ListSchemaVersionsRequest.Builder, ListSchemaVersionsRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListSchemaVersionsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSchemaVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemaVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaId").getter(getter(ListSchemaVersionsRequest::schemaId)).setter(setter(Builder::schemaId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SchemaIdFilter").build())
            .build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(ListSchemaVersionsRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NamespaceFilter").build())
            .build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(ListSchemaVersionsRequest::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("VisibilityFilter").build())
            .build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(ListSchemaVersionsRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SemanticVersionFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SCHEMA_ID_FIELD, NAMESPACE_FIELD, VISIBILITY_FIELD, SEMANTIC_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final Integer maxResults;

    private final String nextToken;

    private final String schemaId;

    private final String namespace;

    private final String visibility;

    private final String semanticVersion;

    private ListSchemaVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.schemaId = builder.schemaId;
        this.namespace = builder.namespace;
        this.visibility = builder.visibility;
        this.semanticVersion = builder.semanticVersion;
    }

    /**
     * <p>
     * Filter on the type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Filter on the type of schema version.
     * @see SchemaVersionType
     */
    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(type);
    }

    /**
     * <p>
     * Filter on the type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Filter on the type of schema version.
     * @see SchemaVersionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filter on the id of the schema version.
     * </p>
     * 
     * @return Filter on the id of the schema version.
     */
    public final String schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * Filter on the name of the schema version.
     * </p>
     * 
     * @return Filter on the name of the schema version.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The visibility of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link SchemaVersionVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the schema version.
     * @see SchemaVersionVisibility
     */
    public final SchemaVersionVisibility visibility() {
        return SchemaVersionVisibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link SchemaVersionVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the schema version.
     * @see SchemaVersionVisibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The schema version. If this is left blank, it defaults to the latest version.
     * </p>
     * 
     * @return The schema version. If this is left blank, it defaults to the latest version.
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaVersionsRequest)) {
            return false;
        }
        ListSchemaVersionsRequest other = (ListSchemaVersionsRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(schemaId(), other.schemaId())
                && Objects.equals(namespace(), other.namespace())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(semanticVersion(), other.semanticVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemaVersionsRequest").add("Type", typeAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SchemaId", schemaId()).add("Namespace", namespace())
                .add("Visibility", visibilityAsString()).add("SemanticVersion", semanticVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SchemaIdFilter", SCHEMA_ID_FIELD);
        map.put("NamespaceFilter", NAMESPACE_FIELD);
        map.put("VisibilityFilter", VISIBILITY_FIELD);
        map.put("SemanticVersionFilter", SEMANTIC_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaVersionsRequest, T> g) {
        return obj -> g.apply((ListSchemaVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSchemaVersionsRequest> {
        /**
         * <p>
         * Filter on the type of schema version.
         * </p>
         * 
         * @param type
         *        Filter on the type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(String type);

        /**
         * <p>
         * Filter on the type of schema version.
         * </p>
         * 
         * @param type
         *        Filter on the type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(SchemaVersionType type);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filter on the id of the schema version.
         * </p>
         * 
         * @param schemaId
         *        Filter on the id of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(String schemaId);

        /**
         * <p>
         * Filter on the name of the schema version.
         * </p>
         * 
         * @param namespace
         *        Filter on the name of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The visibility of the schema version.
         * </p>
         * 
         * @param visibility
         *        The visibility of the schema version.
         * @see SchemaVersionVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionVisibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the schema version.
         * </p>
         * 
         * @param visibility
         *        The visibility of the schema version.
         * @see SchemaVersionVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionVisibility
         */
        Builder visibility(SchemaVersionVisibility visibility);

        /**
         * <p>
         * The schema version. If this is left blank, it defaults to the latest version.
         * </p>
         * 
         * @param semanticVersion
         *        The schema version. If this is left blank, it defaults to the latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String type;

        private Integer maxResults;

        private String nextToken;

        private String schemaId;

        private String namespace;

        private String visibility;

        private String semanticVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaVersionsRequest model) {
            super(model);
            type(model.type);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            schemaId(model.schemaId);
            namespace(model.namespace);
            visibility(model.visibility);
            semanticVersion(model.semanticVersion);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSchemaId() {
            return schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(SchemaVersionVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchemaVersionsRequest build() {
            return new ListSchemaVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
