/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one schema item associated with a managed thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedThingSchemaListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedThingSchemaListItem.Builder, ManagedThingSchemaListItem> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(ManagedThingSchemaListItem::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapabilityId").getter(getter(ManagedThingSchemaListItem::capabilityId))
            .setter(setter(Builder::capabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityId").build()).build();

    private static final SdkField<Document> SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Schema").getter(getter(ManagedThingSchemaListItem::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            CAPABILITY_ID_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final String capabilityId;

    private final Document schema;

    private ManagedThingSchemaListItem(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.capabilityId = builder.capabilityId;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The id of the endpoint for a managed thing.
     * </p>
     * 
     * @return The id of the endpoint for a managed thing.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * <p>
     * The id of the capability for a managed thing.
     * </p>
     * 
     * @return The id of the capability for a managed thing.
     */
    public final String capabilityId() {
        return capabilityId;
    }

    /**
     * <p>
     * The validation schema for one schema item associated with a managed thing.
     * </p>
     * 
     * @return The validation schema for one schema item associated with a managed thing.
     */
    public final Document schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedThingSchemaListItem)) {
            return false;
        }
        ManagedThingSchemaListItem other = (ManagedThingSchemaListItem) obj;
        return Objects.equals(endpointId(), other.endpointId()) && Objects.equals(capabilityId(), other.capabilityId())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedThingSchemaListItem").add("EndpointId", endpointId()).add("CapabilityId", capabilityId())
                .add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "CapabilityId":
            return Optional.ofNullable(clazz.cast(capabilityId()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("CapabilityId", CAPABILITY_ID_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedThingSchemaListItem, T> g) {
        return obj -> g.apply((ManagedThingSchemaListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedThingSchemaListItem> {
        /**
         * <p>
         * The id of the endpoint for a managed thing.
         * </p>
         * 
         * @param endpointId
         *        The id of the endpoint for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * The id of the capability for a managed thing.
         * </p>
         * 
         * @param capabilityId
         *        The id of the capability for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityId(String capabilityId);

        /**
         * <p>
         * The validation schema for one schema item associated with a managed thing.
         * </p>
         * 
         * @param schema
         *        The validation schema for one schema item associated with a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Document schema);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private String capabilityId;

        private Document schema;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedThingSchemaListItem model) {
            endpointId(model.endpointId);
            capabilityId(model.capabilityId);
            schema(model.schema);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getCapabilityId() {
            return capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final Document getSchema() {
            return schema;
        }

        public final void setSchema(Document schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(Document schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public ManagedThingSchemaListItem build() {
            return new ManagedThingSchemaListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
