/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one managed thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedThingSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedThingSummary.Builder, ManagedThingSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ManagedThingSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ManagedThingSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ADVERTISED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdvertisedProductId").getter(getter(ManagedThingSummary::advertisedProductId))
            .setter(setter(Builder::advertisedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvertisedProductId").build())
            .build();

    private static final SdkField<String> BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Brand")
            .getter(getter(ManagedThingSummary::brand)).setter(setter(Builder::brand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()).build();

    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(ManagedThingSummary::classification))
            .setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceId").getter(getter(ManagedThingSummary::connectorDeviceId))
            .setter(setter(Builder::connectorDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()).build();

    private static final SdkField<String> CONNECTOR_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorPolicyId").getter(getter(ManagedThingSummary::connectorPolicyId))
            .setter(setter(Builder::connectorPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorPolicyId").build()).build();

    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDestinationId").getter(getter(ManagedThingSummary::connectorDestinationId))
            .setter(setter(Builder::connectorDestinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationId").build())
            .build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(ManagedThingSummary::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ManagedThingSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ManagedThingSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> CREDENTIAL_LOCKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialLockerId").getter(getter(ManagedThingSummary::credentialLockerId))
            .setter(setter(Builder::credentialLockerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialLockerId").build())
            .build();

    private static final SdkField<String> PARENT_CONTROLLER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentControllerId").getter(getter(ManagedThingSummary::parentControllerId))
            .setter(setter(Builder::parentControllerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentControllerId").build())
            .build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(ManagedThingSummary::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ManagedThingSummary::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(ManagedThingSummary::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ManagedThingSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ManagedThingSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<Instant> ACTIVATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActivatedAt").getter(getter(ManagedThingSummary::activatedAt)).setter(setter(Builder::activatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            ADVERTISED_PRODUCT_ID_FIELD, BRAND_FIELD, CLASSIFICATION_FIELD, CONNECTOR_DEVICE_ID_FIELD, CONNECTOR_POLICY_ID_FIELD,
            CONNECTOR_DESTINATION_ID_FIELD, MODEL_FIELD, NAME_FIELD, OWNER_FIELD, CREDENTIAL_LOCKER_ID_FIELD,
            PARENT_CONTROLLER_ID_FIELD, PROVISIONING_STATUS_FIELD, ROLE_FIELD, SERIAL_NUMBER_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, ACTIVATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String advertisedProductId;

    private final String brand;

    private final String classification;

    private final String connectorDeviceId;

    private final String connectorPolicyId;

    private final String connectorDestinationId;

    private final String model;

    private final String name;

    private final String owner;

    private final String credentialLockerId;

    private final String parentControllerId;

    private final String provisioningStatus;

    private final String role;

    private final String serialNumber;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Instant activatedAt;

    private ManagedThingSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.advertisedProductId = builder.advertisedProductId;
        this.brand = builder.brand;
        this.classification = builder.classification;
        this.connectorDeviceId = builder.connectorDeviceId;
        this.connectorPolicyId = builder.connectorPolicyId;
        this.connectorDestinationId = builder.connectorDestinationId;
        this.model = builder.model;
        this.name = builder.name;
        this.owner = builder.owner;
        this.credentialLockerId = builder.credentialLockerId;
        this.parentControllerId = builder.parentControllerId;
        this.provisioningStatus = builder.provisioningStatus;
        this.role = builder.role;
        this.serialNumber = builder.serialNumber;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.activatedAt = builder.activatedAt;
    }

    /**
     * <p>
     * The id of the device.
     * </p>
     * 
     * @return The id of the device.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the managed thing.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the managed thing.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The id of the advertised product.
     * </p>
     * 
     * @return The id of the advertised product.
     */
    public final String advertisedProductId() {
        return advertisedProductId;
    }

    /**
     * <p>
     * The brand of the device.
     * </p>
     * 
     * @return The brand of the device.
     */
    public final String brand() {
        return brand;
    }

    /**
     * <p>
     * The classification of the managed thing such as light bulb or thermostat.
     * </p>
     * 
     * @return The classification of the managed thing such as light bulb or thermostat.
     */
    public final String classification() {
        return classification;
    }

    /**
     * <p>
     * The third-party device id as defined by the connector. This device id must not contain personal identifiable
     * information (PII).
     * </p>
     * <note>
     * <p>
     * This parameter is used for cloud-to-cloud devices only.
     * </p>
     * </note>
     * 
     * @return The third-party device id as defined by the connector. This device id must not contain personal
     *         identifiable information (PII).</p> <note>
     *         <p>
     *         This parameter is used for cloud-to-cloud devices only.
     *         </p>
     */
    public final String connectorDeviceId() {
        return connectorDeviceId;
    }

    /**
     * <p>
     * The id of the connector policy.
     * </p>
     * <note>
     * <p>
     * This parameter is used for cloud-to-cloud devices only.
     * </p>
     * </note>
     * 
     * @return The id of the connector policy.</p> <note>
     *         <p>
     *         This parameter is used for cloud-to-cloud devices only.
     *         </p>
     * @deprecated ConnectorPolicyId has been deprecated
     */
    @Deprecated
    public final String connectorPolicyId() {
        return connectorPolicyId;
    }

    /**
     * <p>
     * The identifier of the connector destination associated with this managed thing, if applicable.
     * </p>
     * 
     * @return The identifier of the connector destination associated with this managed thing, if applicable.
     */
    public final String connectorDestinationId() {
        return connectorDestinationId;
    }

    /**
     * <p>
     * The model of the device.
     * </p>
     * 
     * @return The model of the device.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The name of the managed thing representing the physical device.
     * </p>
     * 
     * @return The name of the managed thing representing the physical device.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Owner of the device, usually an indication of whom the device belongs to. This value should not contain personal
     * identifiable information.
     * </p>
     * 
     * @return Owner of the device, usually an indication of whom the device belongs to. This value should not contain
     *         personal identifiable information.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The identifier of the credential locker for the managed thing.
     * </p>
     * 
     * @return The identifier of the credential locker for the managed thing.
     */
    public final String credentialLockerId() {
        return credentialLockerId;
    }

    /**
     * <p>
     * Id of the controller device used for the discovery job.
     * </p>
     * 
     * @return Id of the controller device used for the discovery job.
     */
    public final String parentControllerId() {
        return parentControllerId;
    }

    /**
     * <p>
     * The provisioning status of the device in the provisioning workflow for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
     *         integrations.
     * @see ProvisioningStatus
     */
    public final ProvisioningStatus provisioningStatus() {
        return ProvisioningStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The provisioning status of the device in the provisioning workflow for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link ProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
     *         integrations.
     * @see ProvisioningStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
     *         device.
     * @see Role
     */
    public final Role role() {
        return Role.fromValue(role);
    }

    /**
     * <p>
     * The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
     *         device.
     * @see Role
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The serial number of the device.
     * </p>
     * 
     * @return The serial number of the device.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The timestamp value of when the device creation request occurred.
     * </p>
     * 
     * @return The timestamp value of when the device creation request occurred.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp value of when the managed thing was last updated at.
     * </p>
     * 
     * @return The timestamp value of when the managed thing was last updated at.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The timestampe value of when the managed thing was activated at.
     * </p>
     * 
     * @return The timestampe value of when the managed thing was activated at.
     */
    public final Instant activatedAt() {
        return activatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(advertisedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(brand());
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDestinationId());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(credentialLockerId());
        hashCode = 31 * hashCode + Objects.hashCode(parentControllerId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(activatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedThingSummary)) {
            return false;
        }
        ManagedThingSummary other = (ManagedThingSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(advertisedProductId(), other.advertisedProductId()) && Objects.equals(brand(), other.brand())
                && Objects.equals(classification(), other.classification())
                && Objects.equals(connectorDeviceId(), other.connectorDeviceId())
                && Objects.equals(connectorPolicyId(), other.connectorPolicyId())
                && Objects.equals(connectorDestinationId(), other.connectorDestinationId())
                && Objects.equals(model(), other.model()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner()) && Objects.equals(credentialLockerId(), other.credentialLockerId())
                && Objects.equals(parentControllerId(), other.parentControllerId())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(activatedAt(), other.activatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedThingSummary").add("Id", id()).add("Arn", arn())
                .add("AdvertisedProductId", advertisedProductId())
                .add("Brand", brand() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Classification", classification() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorDeviceId", connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorPolicyId", connectorPolicyId()).add("ConnectorDestinationId", connectorDestinationId())
                .add("Model", model() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("Owner", owner() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CredentialLockerId", credentialLockerId()).add("ParentControllerId", parentControllerId())
                .add("ProvisioningStatus", provisioningStatusAsString()).add("Role", roleAsString())
                .add("SerialNumber", serialNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("ActivatedAt", activatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AdvertisedProductId":
            return Optional.ofNullable(clazz.cast(advertisedProductId()));
        case "Brand":
            return Optional.ofNullable(clazz.cast(brand()));
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "ConnectorDeviceId":
            return Optional.ofNullable(clazz.cast(connectorDeviceId()));
        case "ConnectorPolicyId":
            return Optional.ofNullable(clazz.cast(connectorPolicyId()));
        case "ConnectorDestinationId":
            return Optional.ofNullable(clazz.cast(connectorDestinationId()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "CredentialLockerId":
            return Optional.ofNullable(clazz.cast(credentialLockerId()));
        case "ParentControllerId":
            return Optional.ofNullable(clazz.cast(parentControllerId()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "ActivatedAt":
            return Optional.ofNullable(clazz.cast(activatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("AdvertisedProductId", ADVERTISED_PRODUCT_ID_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("ConnectorPolicyId", CONNECTOR_POLICY_ID_FIELD);
        map.put("ConnectorDestinationId", CONNECTOR_DESTINATION_ID_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CredentialLockerId", CREDENTIAL_LOCKER_ID_FIELD);
        map.put("ParentControllerId", PARENT_CONTROLLER_ID_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("ActivatedAt", ACTIVATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedThingSummary, T> g) {
        return obj -> g.apply((ManagedThingSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedThingSummary> {
        /**
         * <p>
         * The id of the device.
         * </p>
         * 
         * @param id
         *        The id of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the managed thing.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The id of the advertised product.
         * </p>
         * 
         * @param advertisedProductId
         *        The id of the advertised product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advertisedProductId(String advertisedProductId);

        /**
         * <p>
         * The brand of the device.
         * </p>
         * 
         * @param brand
         *        The brand of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brand(String brand);

        /**
         * <p>
         * The classification of the managed thing such as light bulb or thermostat.
         * </p>
         * 
         * @param classification
         *        The classification of the managed thing such as light bulb or thermostat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The third-party device id as defined by the connector. This device id must not contain personal identifiable
         * information (PII).
         * </p>
         * <note>
         * <p>
         * This parameter is used for cloud-to-cloud devices only.
         * </p>
         * </note>
         * 
         * @param connectorDeviceId
         *        The third-party device id as defined by the connector. This device id must not contain personal
         *        identifiable information (PII).</p> <note>
         *        <p>
         *        This parameter is used for cloud-to-cloud devices only.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceId(String connectorDeviceId);

        /**
         * <p>
         * The id of the connector policy.
         * </p>
         * <note>
         * <p>
         * This parameter is used for cloud-to-cloud devices only.
         * </p>
         * </note>
         * 
         * @param connectorPolicyId
         *        The id of the connector policy.</p> <note>
         *        <p>
         *        This parameter is used for cloud-to-cloud devices only.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated ConnectorPolicyId has been deprecated
         */
        @Deprecated
        Builder connectorPolicyId(String connectorPolicyId);

        /**
         * <p>
         * The identifier of the connector destination associated with this managed thing, if applicable.
         * </p>
         * 
         * @param connectorDestinationId
         *        The identifier of the connector destination associated with this managed thing, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDestinationId(String connectorDestinationId);

        /**
         * <p>
         * The model of the device.
         * </p>
         * 
         * @param model
         *        The model of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The name of the managed thing representing the physical device.
         * </p>
         * 
         * @param name
         *        The name of the managed thing representing the physical device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Owner of the device, usually an indication of whom the device belongs to. This value should not contain
         * personal identifiable information.
         * </p>
         * 
         * @param owner
         *        Owner of the device, usually an indication of whom the device belongs to. This value should not
         *        contain personal identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The identifier of the credential locker for the managed thing.
         * </p>
         * 
         * @param credentialLockerId
         *        The identifier of the credential locker for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialLockerId(String credentialLockerId);

        /**
         * <p>
         * Id of the controller device used for the discovery job.
         * </p>
         * 
         * @param parentControllerId
         *        Id of the controller device used for the discovery job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentControllerId(String parentControllerId);

        /**
         * <p>
         * The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
         * integrations.
         * </p>
         * 
         * @param provisioningStatus
         *        The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
         *        integrations.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
         * integrations.
         * </p>
         * 
         * @param provisioningStatus
         *        The provisioning status of the device in the provisioning workflow for onboarding to IoT managed
         *        integrations.
         * @see ProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningStatus
         */
        Builder provisioningStatus(ProvisioningStatus provisioningStatus);

        /**
         * <p>
         * The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT device.
         * </p>
         * 
         * @param role
         *        The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
         *        device.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(String role);

        /**
         * <p>
         * The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT device.
         * </p>
         * 
         * @param role
         *        The type of device used. This will be the Amazon Web Services hub controller, cloud device, or IoT
         *        device.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(Role role);

        /**
         * <p>
         * The serial number of the device.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The timestamp value of when the device creation request occurred.
         * </p>
         * 
         * @param createdAt
         *        The timestamp value of when the device creation request occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp value of when the managed thing was last updated at.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp value of when the managed thing was last updated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The timestampe value of when the managed thing was activated at.
         * </p>
         * 
         * @param activatedAt
         *        The timestampe value of when the managed thing was activated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activatedAt(Instant activatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String advertisedProductId;

        private String brand;

        private String classification;

        private String connectorDeviceId;

        private String connectorPolicyId;

        private String connectorDestinationId;

        private String model;

        private String name;

        private String owner;

        private String credentialLockerId;

        private String parentControllerId;

        private String provisioningStatus;

        private String role;

        private String serialNumber;

        private Instant createdAt;

        private Instant updatedAt;

        private Instant activatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedThingSummary model) {
            id(model.id);
            arn(model.arn);
            advertisedProductId(model.advertisedProductId);
            brand(model.brand);
            classification(model.classification);
            connectorDeviceId(model.connectorDeviceId);
            connectorPolicyId(model.connectorPolicyId);
            connectorDestinationId(model.connectorDestinationId);
            model(model.model);
            name(model.name);
            owner(model.owner);
            credentialLockerId(model.credentialLockerId);
            parentControllerId(model.parentControllerId);
            provisioningStatus(model.provisioningStatus);
            role(model.role);
            serialNumber(model.serialNumber);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            activatedAt(model.activatedAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAdvertisedProductId() {
            return advertisedProductId;
        }

        public final void setAdvertisedProductId(String advertisedProductId) {
            this.advertisedProductId = advertisedProductId;
        }

        @Override
        public final Builder advertisedProductId(String advertisedProductId) {
            this.advertisedProductId = advertisedProductId;
            return this;
        }

        public final String getBrand() {
            return brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getClassification() {
            return classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getConnectorDeviceId() {
            return connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        @Deprecated
        public final String getConnectorPolicyId() {
            return connectorPolicyId;
        }

        @Deprecated
        public final void setConnectorPolicyId(String connectorPolicyId) {
            this.connectorPolicyId = connectorPolicyId;
        }

        @Override
        @Deprecated
        public final Builder connectorPolicyId(String connectorPolicyId) {
            this.connectorPolicyId = connectorPolicyId;
            return this;
        }

        public final String getConnectorDestinationId() {
            return connectorDestinationId;
        }

        public final void setConnectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
        }

        @Override
        public final Builder connectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getCredentialLockerId() {
            return credentialLockerId;
        }

        public final void setCredentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
        }

        @Override
        public final Builder credentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
            return this;
        }

        public final String getParentControllerId() {
            return parentControllerId;
        }

        public final void setParentControllerId(String parentControllerId) {
            this.parentControllerId = parentControllerId;
        }

        @Override
        public final Builder parentControllerId(String parentControllerId) {
            this.parentControllerId = parentControllerId;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(ProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getActivatedAt() {
            return activatedAt;
        }

        public final void setActivatedAt(Instant activatedAt) {
            this.activatedAt = activatedAt;
        }

        @Override
        public final Builder activatedAt(Instant activatedAt) {
            this.activatedAt = activatedAt;
            return this;
        }

        @Override
        public ManagedThingSummary build() {
            return new ManagedThingSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
