/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Capability used in Matter capability report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatterCapabilityReportCluster implements SdkPojo, Serializable,
        ToCopyableBuilder<MatterCapabilityReportCluster.Builder, MatterCapabilityReportCluster> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MatterCapabilityReportCluster::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("revision").getter(getter(MatterCapabilityReportCluster::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> PUBLIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicId").getter(getter(MatterCapabilityReportCluster::publicId)).setter(setter(Builder::publicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MatterCapabilityReportCluster::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SPEC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("specVersion").getter(getter(MatterCapabilityReportCluster::specVersion))
            .setter(setter(Builder::specVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specVersion").build()).build();

    private static final SdkField<List<MatterCapabilityReportAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<MatterCapabilityReportAttribute>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(MatterCapabilityReportCluster::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatterCapabilityReportAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatterCapabilityReportAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMMANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("commands")
            .getter(getter(MatterCapabilityReportCluster::commands))
            .setter(setter(Builder::commands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(MatterCapabilityReportCluster::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> FEATURE_MAP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("featureMap").getter(getter(MatterCapabilityReportCluster::featureMap))
            .setter(setter(Builder::featureMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureMap").build()).build();

    private static final SdkField<List<String>> GENERATED_COMMANDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("generatedCommands")
            .getter(getter(MatterCapabilityReportCluster::generatedCommands))
            .setter(setter(Builder::generatedCommands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedCommands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> FABRIC_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("fabricIndex").getter(getter(MatterCapabilityReportCluster::fabricIndex))
            .setter(setter(Builder::fabricIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fabricIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REVISION_FIELD,
            PUBLIC_ID_FIELD, NAME_FIELD, SPEC_VERSION_FIELD, ATTRIBUTES_FIELD, COMMANDS_FIELD, EVENTS_FIELD, FEATURE_MAP_FIELD,
            GENERATED_COMMANDS_FIELD, FABRIC_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Integer revision;

    private final String publicId;

    private final String name;

    private final String specVersion;

    private final List<MatterCapabilityReportAttribute> attributes;

    private final List<String> commands;

    private final List<String> events;

    private final Long featureMap;

    private final List<String> generatedCommands;

    private final Integer fabricIndex;

    private MatterCapabilityReportCluster(BuilderImpl builder) {
        this.id = builder.id;
        this.revision = builder.revision;
        this.publicId = builder.publicId;
        this.name = builder.name;
        this.specVersion = builder.specVersion;
        this.attributes = builder.attributes;
        this.commands = builder.commands;
        this.events = builder.events;
        this.featureMap = builder.featureMap;
        this.generatedCommands = builder.generatedCommands;
        this.fabricIndex = builder.fabricIndex;
    }

    /**
     * <p>
     * The id of the Amazon Web Services Matter capability report cluster.
     * </p>
     * 
     * @return The id of the Amazon Web Services Matter capability report cluster.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The id of the revision for the Amazon Web Services Matter capability report.
     * </p>
     * 
     * @return The id of the revision for the Amazon Web Services Matter capability report.
     */
    public final Integer revision() {
        return revision;
    }

    /**
     * <p>
     * The id of the schema version.
     * </p>
     * 
     * @return The id of the schema version.
     */
    public final String publicId() {
        return publicId;
    }

    /**
     * <p>
     * The capability name used in the Amazon Web Services Matter capability report.
     * </p>
     * 
     * @return The capability name used in the Amazon Web Services Matter capability report.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The spec version used in the Amazon Web Services Matter capability report.
     * </p>
     * 
     * @return The spec version used in the Amazon Web Services Matter capability report.
     */
    public final String specVersion() {
        return specVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the Amazon Web Services Matter capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes of the Amazon Web Services Matter capability report.
     */
    public final List<MatterCapabilityReportAttribute> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Commands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommands() {
        return commands != null && !(commands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The commands used with the Amazon Web Services Matter capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommands} method.
     * </p>
     * 
     * @return The commands used with the Amazon Web Services Matter capability report.
     */
    public final List<String> commands() {
        return commands;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events used with the Amazon Web Services Matter capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The events used with the Amazon Web Services Matter capability report.
     */
    public final List<String> events() {
        return events;
    }

    /**
     * <p>
     * 32 bit-map used to indicate which features a cluster supports.
     * </p>
     * 
     * @return 32 bit-map used to indicate which features a cluster supports.
     */
    public final Long featureMap() {
        return featureMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedCommands property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratedCommands() {
        return generatedCommands != null && !(generatedCommands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Matter clusters used in capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedCommands} method.
     * </p>
     * 
     * @return Matter clusters used in capability report.
     */
    public final List<String> generatedCommands() {
        return generatedCommands;
    }

    /**
     * <p>
     * The fabric index for the Amazon Web Services Matter capability report.
     * </p>
     * 
     * @return The fabric index for the Amazon Web Services Matter capability report.
     */
    public final Integer fabricIndex() {
        return fabricIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(publicId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(specVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCommands() ? commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(featureMap());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedCommands() ? generatedCommands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fabricIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCapabilityReportCluster)) {
            return false;
        }
        MatterCapabilityReportCluster other = (MatterCapabilityReportCluster) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(revision(), other.revision())
                && Objects.equals(publicId(), other.publicId()) && Objects.equals(name(), other.name())
                && Objects.equals(specVersion(), other.specVersion()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && hasCommands() == other.hasCommands()
                && Objects.equals(commands(), other.commands()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events()) && Objects.equals(featureMap(), other.featureMap())
                && hasGeneratedCommands() == other.hasGeneratedCommands()
                && Objects.equals(generatedCommands(), other.generatedCommands())
                && Objects.equals(fabricIndex(), other.fabricIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatterCapabilityReportCluster").add("Id", id()).add("Revision", revision())
                .add("PublicId", publicId()).add("Name", name()).add("SpecVersion", specVersion())
                .add("Attributes", hasAttributes() ? attributes() : null).add("Commands", hasCommands() ? commands() : null)
                .add("Events", hasEvents() ? events() : null).add("FeatureMap", featureMap())
                .add("GeneratedCommands", hasGeneratedCommands() ? generatedCommands() : null).add("FabricIndex", fabricIndex())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "publicId":
            return Optional.ofNullable(clazz.cast(publicId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "specVersion":
            return Optional.ofNullable(clazz.cast(specVersion()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "commands":
            return Optional.ofNullable(clazz.cast(commands()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "featureMap":
            return Optional.ofNullable(clazz.cast(featureMap()));
        case "generatedCommands":
            return Optional.ofNullable(clazz.cast(generatedCommands()));
        case "fabricIndex":
            return Optional.ofNullable(clazz.cast(fabricIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("revision", REVISION_FIELD);
        map.put("publicId", PUBLIC_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("specVersion", SPEC_VERSION_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("commands", COMMANDS_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("featureMap", FEATURE_MAP_FIELD);
        map.put("generatedCommands", GENERATED_COMMANDS_FIELD);
        map.put("fabricIndex", FABRIC_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCapabilityReportCluster, T> g) {
        return obj -> g.apply((MatterCapabilityReportCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatterCapabilityReportCluster> {
        /**
         * <p>
         * The id of the Amazon Web Services Matter capability report cluster.
         * </p>
         * 
         * @param id
         *        The id of the Amazon Web Services Matter capability report cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The id of the revision for the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param revision
         *        The id of the revision for the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        /**
         * <p>
         * The id of the schema version.
         * </p>
         * 
         * @param publicId
         *        The id of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicId(String publicId);

        /**
         * <p>
         * The capability name used in the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param name
         *        The capability name used in the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The spec version used in the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param specVersion
         *        The spec version used in the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specVersion(String specVersion);

        /**
         * <p>
         * The attributes of the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param attributes
         *        The attributes of the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<MatterCapabilityReportAttribute> attributes);

        /**
         * <p>
         * The attributes of the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param attributes
         *        The attributes of the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(MatterCapabilityReportAttribute... attributes);

        /**
         * <p>
         * The attributes of the Amazon Web Services Matter capability report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttribute.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttribute#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttribute.Builder#build()}
         * is called immediately and its result is passed to {@link #attributes(List<MatterCapabilityReportAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<MatterCapabilityReportAttribute>)
         */
        Builder attributes(Consumer<MatterCapabilityReportAttribute.Builder>... attributes);

        /**
         * <p>
         * The commands used with the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param commands
         *        The commands used with the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<String> commands);

        /**
         * <p>
         * The commands used with the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param commands
         *        The commands used with the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(String... commands);

        /**
         * <p>
         * The events used with the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param events
         *        The events used with the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<String> events);

        /**
         * <p>
         * The events used with the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param events
         *        The events used with the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String... events);

        /**
         * <p>
         * 32 bit-map used to indicate which features a cluster supports.
         * </p>
         * 
         * @param featureMap
         *        32 bit-map used to indicate which features a cluster supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureMap(Long featureMap);

        /**
         * <p>
         * Matter clusters used in capability report.
         * </p>
         * 
         * @param generatedCommands
         *        Matter clusters used in capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCommands(Collection<String> generatedCommands);

        /**
         * <p>
         * Matter clusters used in capability report.
         * </p>
         * 
         * @param generatedCommands
         *        Matter clusters used in capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCommands(String... generatedCommands);

        /**
         * <p>
         * The fabric index for the Amazon Web Services Matter capability report.
         * </p>
         * 
         * @param fabricIndex
         *        The fabric index for the Amazon Web Services Matter capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabricIndex(Integer fabricIndex);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer revision;

        private String publicId;

        private String name;

        private String specVersion;

        private List<MatterCapabilityReportAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<String> commands = DefaultSdkAutoConstructList.getInstance();

        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private Long featureMap;

        private List<String> generatedCommands = DefaultSdkAutoConstructList.getInstance();

        private Integer fabricIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCapabilityReportCluster model) {
            id(model.id);
            revision(model.revision);
            publicId(model.publicId);
            name(model.name);
            specVersion(model.specVersion);
            attributes(model.attributes);
            commands(model.commands);
            events(model.events);
            featureMap(model.featureMap);
            generatedCommands(model.generatedCommands);
            fabricIndex(model.fabricIndex);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getRevision() {
            return revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final String getPublicId() {
            return publicId;
        }

        public final void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public final Builder publicId(String publicId) {
            this.publicId = publicId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSpecVersion() {
            return specVersion;
        }

        public final void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        @Override
        public final Builder specVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public final List<MatterCapabilityReportAttribute.Builder> getAttributes() {
            List<MatterCapabilityReportAttribute.Builder> result = MatterCapabilityReportAttributesCopier
                    .copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<MatterCapabilityReportAttribute.BuilderImpl> attributes) {
            this.attributes = MatterCapabilityReportAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<MatterCapabilityReportAttribute> attributes) {
            this.attributes = MatterCapabilityReportAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(MatterCapabilityReportAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<MatterCapabilityReportAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> MatterCapabilityReportAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCommands() {
            if (commands instanceof SdkAutoConstructList) {
                return null;
            }
            return commands;
        }

        public final void setCommands(Collection<String> commands) {
            this.commands = MatterCapabilityReportCommandsCopier.copy(commands);
        }

        @Override
        public final Builder commands(Collection<String> commands) {
            this.commands = MatterCapabilityReportCommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(String... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = MatterCapabilityReportEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = MatterCapabilityReportEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final Long getFeatureMap() {
            return featureMap;
        }

        public final void setFeatureMap(Long featureMap) {
            this.featureMap = featureMap;
        }

        @Override
        public final Builder featureMap(Long featureMap) {
            this.featureMap = featureMap;
            return this;
        }

        public final Collection<String> getGeneratedCommands() {
            if (generatedCommands instanceof SdkAutoConstructList) {
                return null;
            }
            return generatedCommands;
        }

        public final void setGeneratedCommands(Collection<String> generatedCommands) {
            this.generatedCommands = MatterCapabilityReportGeneratedCommandsCopier.copy(generatedCommands);
        }

        @Override
        public final Builder generatedCommands(Collection<String> generatedCommands) {
            this.generatedCommands = MatterCapabilityReportGeneratedCommandsCopier.copy(generatedCommands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCommands(String... generatedCommands) {
            generatedCommands(Arrays.asList(generatedCommands));
            return this;
        }

        public final Integer getFabricIndex() {
            return fabricIndex;
        }

        public final void setFabricIndex(Integer fabricIndex) {
            this.fabricIndex = fabricIndex;
        }

        @Override
        public final Builder fabricIndex(Integer fabricIndex) {
            this.fabricIndex = fabricIndex;
            return this;
        }

        @Override
        public MatterCapabilityReportCluster build() {
            return new MatterCapabilityReportCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
