/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Matter endpoint used in capability report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatterCapabilityReportEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<MatterCapabilityReportEndpoint.Builder, MatterCapabilityReportEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MatterCapabilityReportEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deviceTypes")
            .getter(getter(MatterCapabilityReportEndpoint::deviceTypes))
            .setter(setter(Builder::deviceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MatterCapabilityReportCluster>> CLUSTERS_FIELD = SdkField
            .<List<MatterCapabilityReportCluster>> builder(MarshallingType.LIST)
            .memberName("clusters")
            .getter(getter(MatterCapabilityReportEndpoint::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatterCapabilityReportCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatterCapabilityReportCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PARTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("parts")
            .getter(getter(MatterCapabilityReportEndpoint::parts))
            .setter(setter(Builder::parts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SEMANTIC_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("semanticTags")
            .getter(getter(MatterCapabilityReportEndpoint::semanticTags))
            .setter(setter(Builder::semanticTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CLIENT_CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clientClusters")
            .getter(getter(MatterCapabilityReportEndpoint::clientClusters))
            .setter(setter(Builder::clientClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DEVICE_TYPES_FIELD,
            CLUSTERS_FIELD, PARTS_FIELD, SEMANTIC_TAGS_FIELD, CLIENT_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<String> deviceTypes;

    private final List<MatterCapabilityReportCluster> clusters;

    private final List<String> parts;

    private final List<String> semanticTags;

    private final List<String> clientClusters;

    private MatterCapabilityReportEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.deviceTypes = builder.deviceTypes;
        this.clusters = builder.clusters;
        this.parts = builder.parts;
        this.semanticTags = builder.semanticTags;
        this.clientClusters = builder.clientClusters;
    }

    /**
     * <p>
     * The id of the Amazon Web Services Matter capability report endpoint.
     * </p>
     * 
     * @return The id of the Amazon Web Services Matter capability report endpoint.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceTypes() {
        return deviceTypes != null && !(deviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceTypes} method.
     * </p>
     * 
     * @return The type of device.
     */
    public final List<String> deviceTypes() {
        return deviceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Matter clusters used in capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return Matter clusters used in capability report.
     */
    public final List<MatterCapabilityReportCluster> clusters() {
        return clusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parts property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasParts() {
        return parts != null && !(parts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Heirachy of child endpoints contained in the given endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParts} method.
     * </p>
     * 
     * @return Heirachy of child endpoints contained in the given endpoint.
     */
    public final List<String> parts() {
        return parts;
    }

    /**
     * For responses, this returns true if the service returned a value for the SemanticTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSemanticTags() {
        return semanticTags != null && !(semanticTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Semantic information related to endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSemanticTags} method.
     * </p>
     * 
     * @return Semantic information related to endpoint.
     */
    public final List<String> semanticTags() {
        return semanticTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientClusters() {
        return clientClusters != null && !(clientClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Semantic information related to endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientClusters} method.
     * </p>
     * 
     * @return Semantic information related to endpoint.
     */
    public final List<String> clientClusters() {
        return clientClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceTypes() ? deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParts() ? parts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSemanticTags() ? semanticTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClientClusters() ? clientClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCapabilityReportEndpoint)) {
            return false;
        }
        MatterCapabilityReportEndpoint other = (MatterCapabilityReportEndpoint) obj;
        return Objects.equals(id(), other.id()) && hasDeviceTypes() == other.hasDeviceTypes()
                && Objects.equals(deviceTypes(), other.deviceTypes()) && hasClusters() == other.hasClusters()
                && Objects.equals(clusters(), other.clusters()) && hasParts() == other.hasParts()
                && Objects.equals(parts(), other.parts()) && hasSemanticTags() == other.hasSemanticTags()
                && Objects.equals(semanticTags(), other.semanticTags()) && hasClientClusters() == other.hasClientClusters()
                && Objects.equals(clientClusters(), other.clientClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatterCapabilityReportEndpoint").add("Id", id())
                .add("DeviceTypes", hasDeviceTypes() ? deviceTypes() : null).add("Clusters", hasClusters() ? clusters() : null)
                .add("Parts", hasParts() ? parts() : null).add("SemanticTags", hasSemanticTags() ? semanticTags() : null)
                .add("ClientClusters", hasClientClusters() ? clientClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "deviceTypes":
            return Optional.ofNullable(clazz.cast(deviceTypes()));
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "parts":
            return Optional.ofNullable(clazz.cast(parts()));
        case "semanticTags":
            return Optional.ofNullable(clazz.cast(semanticTags()));
        case "clientClusters":
            return Optional.ofNullable(clazz.cast(clientClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("deviceTypes", DEVICE_TYPES_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        map.put("parts", PARTS_FIELD);
        map.put("semanticTags", SEMANTIC_TAGS_FIELD);
        map.put("clientClusters", CLIENT_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCapabilityReportEndpoint, T> g) {
        return obj -> g.apply((MatterCapabilityReportEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatterCapabilityReportEndpoint> {
        /**
         * <p>
         * The id of the Amazon Web Services Matter capability report endpoint.
         * </p>
         * 
         * @param id
         *        The id of the Amazon Web Services Matter capability report endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of device.
         * </p>
         * 
         * @param deviceTypes
         *        The type of device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(Collection<String> deviceTypes);

        /**
         * <p>
         * The type of device.
         * </p>
         * 
         * @param deviceTypes
         *        The type of device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(String... deviceTypes);

        /**
         * <p>
         * Matter clusters used in capability report.
         * </p>
         * 
         * @param clusters
         *        Matter clusters used in capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<MatterCapabilityReportCluster> clusters);

        /**
         * <p>
         * Matter clusters used in capability report.
         * </p>
         * 
         * @param clusters
         *        Matter clusters used in capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(MatterCapabilityReportCluster... clusters);

        /**
         * <p>
         * Matter clusters used in capability report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCluster.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCluster.Builder#build()}
         * is called immediately and its result is passed to {@link #clusters(List<MatterCapabilityReportCluster>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(java.util.Collection<MatterCapabilityReportCluster>)
         */
        Builder clusters(Consumer<MatterCapabilityReportCluster.Builder>... clusters);

        /**
         * <p>
         * Heirachy of child endpoints contained in the given endpoint.
         * </p>
         * 
         * @param parts
         *        Heirachy of child endpoints contained in the given endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<String> parts);

        /**
         * <p>
         * Heirachy of child endpoints contained in the given endpoint.
         * </p>
         * 
         * @param parts
         *        Heirachy of child endpoints contained in the given endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(String... parts);

        /**
         * <p>
         * Semantic information related to endpoint.
         * </p>
         * 
         * @param semanticTags
         *        Semantic information related to endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticTags(Collection<String> semanticTags);

        /**
         * <p>
         * Semantic information related to endpoint.
         * </p>
         * 
         * @param semanticTags
         *        Semantic information related to endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticTags(String... semanticTags);

        /**
         * <p>
         * Semantic information related to endpoint.
         * </p>
         * 
         * @param clientClusters
         *        Semantic information related to endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientClusters(Collection<String> clientClusters);

        /**
         * <p>
         * Semantic information related to endpoint.
         * </p>
         * 
         * @param clientClusters
         *        Semantic information related to endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientClusters(String... clientClusters);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<MatterCapabilityReportCluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private List<String> parts = DefaultSdkAutoConstructList.getInstance();

        private List<String> semanticTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> clientClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCapabilityReportEndpoint model) {
            id(model.id);
            deviceTypes(model.deviceTypes);
            clusters(model.clusters);
            parts(model.parts);
            semanticTags(model.semanticTags);
            clientClusters(model.clientClusters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String... deviceTypes) {
            deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final List<MatterCapabilityReportCluster.Builder> getClusters() {
            List<MatterCapabilityReportCluster.Builder> result = MatterCapabilityReportClustersCopier
                    .copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<MatterCapabilityReportCluster.BuilderImpl> clusters) {
            this.clusters = MatterCapabilityReportClustersCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<MatterCapabilityReportCluster> clusters) {
            this.clusters = MatterCapabilityReportClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(MatterCapabilityReportCluster... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<MatterCapabilityReportCluster.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> MatterCapabilityReportCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getParts() {
            if (parts instanceof SdkAutoConstructList) {
                return null;
            }
            return parts;
        }

        public final void setParts(Collection<String> parts) {
            this.parts = MatterCapabilityReportEndpointPartsCopier.copy(parts);
        }

        @Override
        public final Builder parts(Collection<String> parts) {
            this.parts = MatterCapabilityReportEndpointPartsCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(String... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        public final Collection<String> getSemanticTags() {
            if (semanticTags instanceof SdkAutoConstructList) {
                return null;
            }
            return semanticTags;
        }

        public final void setSemanticTags(Collection<String> semanticTags) {
            this.semanticTags = MatterCapabilityReportEndpointSemanticTagsCopier.copy(semanticTags);
        }

        @Override
        public final Builder semanticTags(Collection<String> semanticTags) {
            this.semanticTags = MatterCapabilityReportEndpointSemanticTagsCopier.copy(semanticTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder semanticTags(String... semanticTags) {
            semanticTags(Arrays.asList(semanticTags));
            return this;
        }

        public final Collection<String> getClientClusters() {
            if (clientClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clientClusters;
        }

        public final void setClientClusters(Collection<String> clientClusters) {
            this.clientClusters = MatterCapabilityReportEndpointClientClustersCopier.copy(clientClusters);
        }

        @Override
        public final Builder clientClusters(Collection<String> clientClusters) {
            this.clientClusters = MatterCapabilityReportEndpointClientClustersCopier.copy(clientClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientClusters(String... clientClusters) {
            clientClusters(Arrays.asList(clientClusters));
            return this;
        }

        @Override
        public MatterCapabilityReportEndpoint build() {
            return new MatterCapabilityReportEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
