/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure describing a managed thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatterEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<MatterEndpoint.Builder, MatterEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MatterEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<MatterCluster>> CLUSTERS_FIELD = SdkField
            .<List<MatterCluster>> builder(MarshallingType.LIST)
            .memberName("clusters")
            .getter(getter(MatterEndpoint::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatterCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatterCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<MatterCluster> clusters;

    private MatterEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.clusters = builder.clusters;
    }

    /**
     * <p>
     * The Matter endpoint id.
     * </p>
     * 
     * @return The Matter endpoint id.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Matter clusters for a managed thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return A list of Matter clusters for a managed thing.
     */
    public final List<MatterCluster> clusters() {
        return clusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterEndpoint)) {
            return false;
        }
        MatterEndpoint other = (MatterEndpoint) obj;
        return Objects.equals(id(), other.id()) && hasClusters() == other.hasClusters()
                && Objects.equals(clusters(), other.clusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatterEndpoint").add("Id", id()).add("Clusters", hasClusters() ? clusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterEndpoint, T> g) {
        return obj -> g.apply((MatterEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatterEndpoint> {
        /**
         * <p>
         * The Matter endpoint id.
         * </p>
         * 
         * @param id
         *        The Matter endpoint id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A list of Matter clusters for a managed thing.
         * </p>
         * 
         * @param clusters
         *        A list of Matter clusters for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<MatterCluster> clusters);

        /**
         * <p>
         * A list of Matter clusters for a managed thing.
         * </p>
         * 
         * @param clusters
         *        A list of Matter clusters for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(MatterCluster... clusters);

        /**
         * <p>
         * A list of Matter clusters for a managed thing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCluster.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #clusters(List<MatterCluster>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(java.util.Collection<MatterCluster>)
         */
        Builder clusters(Consumer<MatterCluster.Builder>... clusters);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<MatterCluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatterEndpoint model) {
            id(model.id);
            clusters(model.clusters);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<MatterCluster.Builder> getClusters() {
            List<MatterCluster.Builder> result = MatterClustersCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<MatterCluster.BuilderImpl> clusters) {
            this.clusters = MatterClustersCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<MatterCluster> clusters) {
            this.clusters = MatterClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(MatterCluster... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<MatterCluster.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> MatterCluster.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MatterEndpoint build() {
            return new MatterEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
