/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing updated OAuth configuration settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuthUpdate implements SdkPojo, Serializable, ToCopyableBuilder<OAuthUpdate.Builder, OAuthUpdate> {
    private static final SdkField<String> O_AUTH_COMPLETE_REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oAuthCompleteRedirectUrl").getter(getter(OAuthUpdate::oAuthCompleteRedirectUrl))
            .setter(setter(Builder::oAuthCompleteRedirectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthCompleteRedirectUrl").build())
            .build();

    private static final SdkField<ProactiveRefreshTokenRenewal> PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD = SdkField
            .<ProactiveRefreshTokenRenewal> builder(MarshallingType.SDK_POJO)
            .memberName("proactiveRefreshTokenRenewal")
            .getter(getter(OAuthUpdate::proactiveRefreshTokenRenewal))
            .setter(setter(Builder::proactiveRefreshTokenRenewal))
            .constructor(ProactiveRefreshTokenRenewal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proactiveRefreshTokenRenewal")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            O_AUTH_COMPLETE_REDIRECT_URL_FIELD, PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String oAuthCompleteRedirectUrl;

    private final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

    private OAuthUpdate(BuilderImpl builder) {
        this.oAuthCompleteRedirectUrl = builder.oAuthCompleteRedirectUrl;
        this.proactiveRefreshTokenRenewal = builder.proactiveRefreshTokenRenewal;
    }

    /**
     * <p>
     * The updated URL where users are redirected after completing the OAuth authorization process.
     * </p>
     * 
     * @return The updated URL where users are redirected after completing the OAuth authorization process.
     */
    public final String oAuthCompleteRedirectUrl() {
        return oAuthCompleteRedirectUrl;
    }

    /**
     * <p>
     * Updated configuration for proactively refreshing OAuth tokens before they expire.
     * </p>
     * 
     * @return Updated configuration for proactively refreshing OAuth tokens before they expire.
     */
    public final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal() {
        return proactiveRefreshTokenRenewal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oAuthCompleteRedirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(proactiveRefreshTokenRenewal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthUpdate)) {
            return false;
        }
        OAuthUpdate other = (OAuthUpdate) obj;
        return Objects.equals(oAuthCompleteRedirectUrl(), other.oAuthCompleteRedirectUrl())
                && Objects.equals(proactiveRefreshTokenRenewal(), other.proactiveRefreshTokenRenewal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuthUpdate").add("OAuthCompleteRedirectUrl", oAuthCompleteRedirectUrl())
                .add("ProactiveRefreshTokenRenewal", proactiveRefreshTokenRenewal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oAuthCompleteRedirectUrl":
            return Optional.ofNullable(clazz.cast(oAuthCompleteRedirectUrl()));
        case "proactiveRefreshTokenRenewal":
            return Optional.ofNullable(clazz.cast(proactiveRefreshTokenRenewal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("oAuthCompleteRedirectUrl", O_AUTH_COMPLETE_REDIRECT_URL_FIELD);
        map.put("proactiveRefreshTokenRenewal", PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthUpdate, T> g) {
        return obj -> g.apply((OAuthUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuthUpdate> {
        /**
         * <p>
         * The updated URL where users are redirected after completing the OAuth authorization process.
         * </p>
         * 
         * @param oAuthCompleteRedirectUrl
         *        The updated URL where users are redirected after completing the OAuth authorization process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl);

        /**
         * <p>
         * Updated configuration for proactively refreshing OAuth tokens before they expire.
         * </p>
         * 
         * @param proactiveRefreshTokenRenewal
         *        Updated configuration for proactively refreshing OAuth tokens before they expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal);

        /**
         * <p>
         * Updated configuration for proactively refreshing OAuth tokens before they expire.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProactiveRefreshTokenRenewal.Builder}
         * avoiding the need to create one manually via {@link ProactiveRefreshTokenRenewal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProactiveRefreshTokenRenewal.Builder#build()} is called
         * immediately and its result is passed to {@link #proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal)}.
         * 
         * @param proactiveRefreshTokenRenewal
         *        a consumer that will call methods on {@link ProactiveRefreshTokenRenewal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal)
         */
        default Builder proactiveRefreshTokenRenewal(Consumer<ProactiveRefreshTokenRenewal.Builder> proactiveRefreshTokenRenewal) {
            return proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal.builder()
                    .applyMutation(proactiveRefreshTokenRenewal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String oAuthCompleteRedirectUrl;

        private ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthUpdate model) {
            oAuthCompleteRedirectUrl(model.oAuthCompleteRedirectUrl);
            proactiveRefreshTokenRenewal(model.proactiveRefreshTokenRenewal);
        }

        public final String getOAuthCompleteRedirectUrl() {
            return oAuthCompleteRedirectUrl;
        }

        public final void setOAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
        }

        @Override
        public final Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
            return this;
        }

        public final ProactiveRefreshTokenRenewal.Builder getProactiveRefreshTokenRenewal() {
            return proactiveRefreshTokenRenewal != null ? proactiveRefreshTokenRenewal.toBuilder() : null;
        }

        public final void setProactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal.BuilderImpl proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal != null ? proactiveRefreshTokenRenewal.build()
                    : null;
        }

        @Override
        public final Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal;
            return this;
        }

        @Override
        public OAuthUpdate build() {
            return new OAuthUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
