/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Over-the-air (OTA) task rollout config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskExecutionRolloutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OtaTaskExecutionRolloutConfig.Builder, OtaTaskExecutionRolloutConfig> {
    private static final SdkField<ExponentialRolloutRate> EXPONENTIAL_ROLLOUT_RATE_FIELD = SdkField
            .<ExponentialRolloutRate> builder(MarshallingType.SDK_POJO).memberName("ExponentialRolloutRate")
            .getter(getter(OtaTaskExecutionRolloutConfig::exponentialRolloutRate))
            .setter(setter(Builder::exponentialRolloutRate)).constructor(ExponentialRolloutRate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExponentialRolloutRate").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumPerMinute").getter(getter(OtaTaskExecutionRolloutConfig::maximumPerMinute))
            .setter(setter(Builder::maximumPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPerMinute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPONENTIAL_ROLLOUT_RATE_FIELD, MAXIMUM_PER_MINUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExponentialRolloutRate exponentialRolloutRate;

    private final Integer maximumPerMinute;

    private OtaTaskExecutionRolloutConfig(BuilderImpl builder) {
        this.exponentialRolloutRate = builder.exponentialRolloutRate;
        this.maximumPerMinute = builder.maximumPerMinute;
    }

    /**
     * <p>
     * Structure representing exponential rate of rollout for an over-the-air (OTA) task.
     * </p>
     * 
     * @return Structure representing exponential rate of rollout for an over-the-air (OTA) task.
     */
    public final ExponentialRolloutRate exponentialRolloutRate() {
        return exponentialRolloutRate;
    }

    /**
     * <p>
     * The maximum number of things that will be notified of a pending task, per minute.
     * </p>
     * 
     * @return The maximum number of things that will be notified of a pending task, per minute.
     */
    public final Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exponentialRolloutRate());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskExecutionRolloutConfig)) {
            return false;
        }
        OtaTaskExecutionRolloutConfig other = (OtaTaskExecutionRolloutConfig) obj;
        return Objects.equals(exponentialRolloutRate(), other.exponentialRolloutRate())
                && Objects.equals(maximumPerMinute(), other.maximumPerMinute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskExecutionRolloutConfig").add("ExponentialRolloutRate", exponentialRolloutRate())
                .add("MaximumPerMinute", maximumPerMinute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExponentialRolloutRate":
            return Optional.ofNullable(clazz.cast(exponentialRolloutRate()));
        case "MaximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExponentialRolloutRate", EXPONENTIAL_ROLLOUT_RATE_FIELD);
        map.put("MaximumPerMinute", MAXIMUM_PER_MINUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskExecutionRolloutConfig, T> g) {
        return obj -> g.apply((OtaTaskExecutionRolloutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskExecutionRolloutConfig> {
        /**
         * <p>
         * Structure representing exponential rate of rollout for an over-the-air (OTA) task.
         * </p>
         * 
         * @param exponentialRolloutRate
         *        Structure representing exponential rate of rollout for an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exponentialRolloutRate(ExponentialRolloutRate exponentialRolloutRate);

        /**
         * <p>
         * Structure representing exponential rate of rollout for an over-the-air (OTA) task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExponentialRolloutRate.Builder} avoiding
         * the need to create one manually via {@link ExponentialRolloutRate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExponentialRolloutRate.Builder#build()} is called immediately and
         * its result is passed to {@link #exponentialRolloutRate(ExponentialRolloutRate)}.
         * 
         * @param exponentialRolloutRate
         *        a consumer that will call methods on {@link ExponentialRolloutRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exponentialRolloutRate(ExponentialRolloutRate)
         */
        default Builder exponentialRolloutRate(Consumer<ExponentialRolloutRate.Builder> exponentialRolloutRate) {
            return exponentialRolloutRate(ExponentialRolloutRate.builder().applyMutation(exponentialRolloutRate).build());
        }

        /**
         * <p>
         * The maximum number of things that will be notified of a pending task, per minute.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of things that will be notified of a pending task, per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);
    }

    static final class BuilderImpl implements Builder {
        private ExponentialRolloutRate exponentialRolloutRate;

        private Integer maximumPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskExecutionRolloutConfig model) {
            exponentialRolloutRate(model.exponentialRolloutRate);
            maximumPerMinute(model.maximumPerMinute);
        }

        public final ExponentialRolloutRate.Builder getExponentialRolloutRate() {
            return exponentialRolloutRate != null ? exponentialRolloutRate.toBuilder() : null;
        }

        public final void setExponentialRolloutRate(ExponentialRolloutRate.BuilderImpl exponentialRolloutRate) {
            this.exponentialRolloutRate = exponentialRolloutRate != null ? exponentialRolloutRate.build() : null;
        }

        @Override
        public final Builder exponentialRolloutRate(ExponentialRolloutRate exponentialRolloutRate) {
            this.exponentialRolloutRate = exponentialRolloutRate;
            return this;
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        @Override
        public OtaTaskExecutionRolloutConfig build() {
            return new OtaTaskExecutionRolloutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
