/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one execution summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskExecutionSummaries implements SdkPojo, Serializable,
        ToCopyableBuilder<OtaTaskExecutionSummaries.Builder, OtaTaskExecutionSummaries> {
    private static final SdkField<OtaTaskExecutionSummary> TASK_EXECUTION_SUMMARY_FIELD = SdkField
            .<OtaTaskExecutionSummary> builder(MarshallingType.SDK_POJO).memberName("TaskExecutionSummary")
            .getter(getter(OtaTaskExecutionSummaries::taskExecutionSummary)).setter(setter(Builder::taskExecutionSummary))
            .constructor(OtaTaskExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionSummary").build())
            .build();

    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(OtaTaskExecutionSummaries::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_SUMMARY_FIELD,
            MANAGED_THING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OtaTaskExecutionSummary taskExecutionSummary;

    private final String managedThingId;

    private OtaTaskExecutionSummaries(BuilderImpl builder) {
        this.taskExecutionSummary = builder.taskExecutionSummary;
        this.managedThingId = builder.managedThingId;
    }

    /**
     * <p>
     * Structure representing one over-the-air (OTA) task execution summary
     * </p>
     * 
     * @return Structure representing one over-the-air (OTA) task execution summary
     */
    public final OtaTaskExecutionSummary taskExecutionSummary() {
        return taskExecutionSummary;
    }

    /**
     * <p>
     * The id of a managed thing.
     * </p>
     * 
     * @return The id of a managed thing.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskExecutionSummaries)) {
            return false;
        }
        OtaTaskExecutionSummaries other = (OtaTaskExecutionSummaries) obj;
        return Objects.equals(taskExecutionSummary(), other.taskExecutionSummary())
                && Objects.equals(managedThingId(), other.managedThingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskExecutionSummaries").add("TaskExecutionSummary", taskExecutionSummary())
                .add("ManagedThingId", managedThingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskExecutionSummary":
            return Optional.ofNullable(clazz.cast(taskExecutionSummary()));
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskExecutionSummary", TASK_EXECUTION_SUMMARY_FIELD);
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskExecutionSummaries, T> g) {
        return obj -> g.apply((OtaTaskExecutionSummaries) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskExecutionSummaries> {
        /**
         * <p>
         * Structure representing one over-the-air (OTA) task execution summary
         * </p>
         * 
         * @param taskExecutionSummary
         *        Structure representing one over-the-air (OTA) task execution summary
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionSummary(OtaTaskExecutionSummary taskExecutionSummary);

        /**
         * <p>
         * Structure representing one over-the-air (OTA) task execution summary
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaTaskExecutionSummary.Builder} avoiding
         * the need to create one manually via {@link OtaTaskExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #taskExecutionSummary(OtaTaskExecutionSummary)}.
         * 
         * @param taskExecutionSummary
         *        a consumer that will call methods on {@link OtaTaskExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskExecutionSummary(OtaTaskExecutionSummary)
         */
        default Builder taskExecutionSummary(Consumer<OtaTaskExecutionSummary.Builder> taskExecutionSummary) {
            return taskExecutionSummary(OtaTaskExecutionSummary.builder().applyMutation(taskExecutionSummary).build());
        }

        /**
         * <p>
         * The id of a managed thing.
         * </p>
         * 
         * @param managedThingId
         *        The id of a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);
    }

    static final class BuilderImpl implements Builder {
        private OtaTaskExecutionSummary taskExecutionSummary;

        private String managedThingId;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskExecutionSummaries model) {
            taskExecutionSummary(model.taskExecutionSummary);
            managedThingId(model.managedThingId);
        }

        public final OtaTaskExecutionSummary.Builder getTaskExecutionSummary() {
            return taskExecutionSummary != null ? taskExecutionSummary.toBuilder() : null;
        }

        public final void setTaskExecutionSummary(OtaTaskExecutionSummary.BuilderImpl taskExecutionSummary) {
            this.taskExecutionSummary = taskExecutionSummary != null ? taskExecutionSummary.build() : null;
        }

        @Override
        public final Builder taskExecutionSummary(OtaTaskExecutionSummary taskExecutionSummary) {
            this.taskExecutionSummary = taskExecutionSummary;
            return this;
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        @Override
        public OtaTaskExecutionSummaries build() {
            return new OtaTaskExecutionSummaries(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
