/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one over-the-air (OTA) task execution summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OtaTaskExecutionSummary.Builder, OtaTaskExecutionSummary> {
    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ExecutionNumber").getter(getter(OtaTaskExecutionSummary::executionNumber))
            .setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionNumber").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(OtaTaskExecutionSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> QUEUED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("QueuedAt").getter(getter(OtaTaskExecutionSummary::queuedAt)).setter(setter(Builder::queuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuedAt").build()).build();

    private static final SdkField<Integer> RETRY_ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryAttempt").getter(getter(OtaTaskExecutionSummary::retryAttempt))
            .setter(setter(Builder::retryAttempt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(OtaTaskExecutionSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OtaTaskExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_NUMBER_FIELD,
            LAST_UPDATED_AT_FIELD, QUEUED_AT_FIELD, RETRY_ATTEMPT_FIELD, STARTED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long executionNumber;

    private final Instant lastUpdatedAt;

    private final Instant queuedAt;

    private final Integer retryAttempt;

    private final Instant startedAt;

    private final String status;

    private OtaTaskExecutionSummary(BuilderImpl builder) {
        this.executionNumber = builder.executionNumber;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.queuedAt = builder.queuedAt;
        this.retryAttempt = builder.retryAttempt;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The execution number of the over-the-air (OTA) task execution summary.
     * </p>
     * 
     * @return The execution number of the over-the-air (OTA) task execution summary.
     */
    public final Long executionNumber() {
        return executionNumber;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task execution summary was last updated.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task execution summary was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task execution summary is targeted to start.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task execution summary is targeted to start.
     */
    public final Instant queuedAt() {
        return queuedAt;
    }

    /**
     * <p>
     * The number of retry attempts for starting the over-the-air (OTA) task execution summary after a failed attempt.
     * </p>
     * 
     * @return The number of retry attempts for starting the over-the-air (OTA) task execution summary after a failed
     *         attempt.
     */
    public final Integer retryAttempt() {
        return retryAttempt;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task execution summary started.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task execution summary started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task execution summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaTaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task execution summary.
     * @see OtaTaskExecutionStatus
     */
    public final OtaTaskExecutionStatus status() {
        return OtaTaskExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task execution summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaTaskExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task execution summary.
     * @see OtaTaskExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(queuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(retryAttempt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskExecutionSummary)) {
            return false;
        }
        OtaTaskExecutionSummary other = (OtaTaskExecutionSummary) obj;
        return Objects.equals(executionNumber(), other.executionNumber())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(queuedAt(), other.queuedAt())
                && Objects.equals(retryAttempt(), other.retryAttempt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskExecutionSummary").add("ExecutionNumber", executionNumber())
                .add("LastUpdatedAt", lastUpdatedAt()).add("QueuedAt", queuedAt()).add("RetryAttempt", retryAttempt())
                .add("StartedAt", startedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "QueuedAt":
            return Optional.ofNullable(clazz.cast(queuedAt()));
        case "RetryAttempt":
            return Optional.ofNullable(clazz.cast(retryAttempt()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionNumber", EXECUTION_NUMBER_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("QueuedAt", QUEUED_AT_FIELD);
        map.put("RetryAttempt", RETRY_ATTEMPT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskExecutionSummary, T> g) {
        return obj -> g.apply((OtaTaskExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskExecutionSummary> {
        /**
         * <p>
         * The execution number of the over-the-air (OTA) task execution summary.
         * </p>
         * 
         * @param executionNumber
         *        The execution number of the over-the-air (OTA) task execution summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task execution summary was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp value of when the over-the-air (OTA) task execution summary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task execution summary is targeted to start.
         * </p>
         * 
         * @param queuedAt
         *        The timestamp value of when the over-the-air (OTA) task execution summary is targeted to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedAt(Instant queuedAt);

        /**
         * <p>
         * The number of retry attempts for starting the over-the-air (OTA) task execution summary after a failed
         * attempt.
         * </p>
         * 
         * @param retryAttempt
         *        The number of retry attempts for starting the over-the-air (OTA) task execution summary after a failed
         *        attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAttempt(Integer retryAttempt);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task execution summary started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp value of when the over-the-air (OTA) task execution summary started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The status of the over-the-air (OTA) task execution summary.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task execution summary.
         * @see OtaTaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaTaskExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the over-the-air (OTA) task execution summary.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task execution summary.
         * @see OtaTaskExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaTaskExecutionStatus
         */
        Builder status(OtaTaskExecutionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long executionNumber;

        private Instant lastUpdatedAt;

        private Instant queuedAt;

        private Integer retryAttempt;

        private Instant startedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskExecutionSummary model) {
            executionNumber(model.executionNumber);
            lastUpdatedAt(model.lastUpdatedAt);
            queuedAt(model.queuedAt);
            retryAttempt(model.retryAttempt);
            startedAt(model.startedAt);
            status(model.status);
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getQueuedAt() {
            return queuedAt;
        }

        public final void setQueuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
        }

        @Override
        public final Builder queuedAt(Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }

        public final Integer getRetryAttempt() {
            return retryAttempt;
        }

        public final void setRetryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
        }

        @Override
        public final Builder retryAttempt(Integer retryAttempt) {
            this.retryAttempt = retryAttempt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaTaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public OtaTaskExecutionSummary build() {
            return new OtaTaskExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
