/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Over-the-air (OTA) task scheduling config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskSchedulingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OtaTaskSchedulingConfig.Builder, OtaTaskSchedulingConfig> {
    private static final SdkField<String> END_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndBehavior").getter(getter(OtaTaskSchedulingConfig::endBehaviorAsString))
            .setter(setter(Builder::endBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndBehavior").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(OtaTaskSchedulingConfig::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<ScheduleMaintenanceWindow>> MAINTENANCE_WINDOWS_FIELD = SdkField
            .<List<ScheduleMaintenanceWindow>> builder(MarshallingType.LIST)
            .memberName("MaintenanceWindows")
            .getter(getter(OtaTaskSchedulingConfig::maintenanceWindows))
            .setter(setter(Builder::maintenanceWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleMaintenanceWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleMaintenanceWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(OtaTaskSchedulingConfig::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_BEHAVIOR_FIELD,
            END_TIME_FIELD, MAINTENANCE_WINDOWS_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endBehavior;

    private final String endTime;

    private final List<ScheduleMaintenanceWindow> maintenanceWindows;

    private final String startTime;

    private OtaTaskSchedulingConfig(BuilderImpl builder) {
        this.endBehavior = builder.endBehavior;
        this.endTime = builder.endTime;
        this.maintenanceWindows = builder.maintenanceWindows;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>. If
     * <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endBehavior} will
     * return {@link SchedulingConfigEndBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>
     *         . If <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not
     *         apply.
     * @see SchedulingConfigEndBehavior
     */
    public final SchedulingConfigEndBehavior endBehavior() {
        return SchedulingConfigEndBehavior.fromValue(endBehavior);
    }

    /**
     * <p>
     * Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>. If
     * <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endBehavior} will
     * return {@link SchedulingConfigEndBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endBehaviorAsString}.
     * </p>
     * 
     * @return Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>
     *         . If <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not
     *         apply.
     * @see SchedulingConfigEndBehavior
     */
    public final String endBehaviorAsString() {
        return endBehavior;
    }

    /**
     * <p>
     * The time an over-the-air (OTA) task will stop.
     * </p>
     * 
     * @return The time an over-the-air (OTA) task will stop.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the MaintenanceWindows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMaintenanceWindows() {
        return maintenanceWindows != null && !(maintenanceWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Maintenance window list for over-the-air (OTA) task scheduling config.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaintenanceWindows} method.
     * </p>
     * 
     * @return Maintenance window list for over-the-air (OTA) task scheduling config.
     */
    public final List<ScheduleMaintenanceWindow> maintenanceWindows() {
        return maintenanceWindows;
    }

    /**
     * <p>
     * The time an over-the-air (OTA) task will start.
     * </p>
     * 
     * @return The time an over-the-air (OTA) task will start.
     */
    public final String startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMaintenanceWindows() ? maintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskSchedulingConfig)) {
            return false;
        }
        OtaTaskSchedulingConfig other = (OtaTaskSchedulingConfig) obj;
        return Objects.equals(endBehaviorAsString(), other.endBehaviorAsString()) && Objects.equals(endTime(), other.endTime())
                && hasMaintenanceWindows() == other.hasMaintenanceWindows()
                && Objects.equals(maintenanceWindows(), other.maintenanceWindows())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskSchedulingConfig").add("EndBehavior", endBehaviorAsString()).add("EndTime", endTime())
                .add("MaintenanceWindows", hasMaintenanceWindows() ? maintenanceWindows() : null).add("StartTime", startTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndBehavior":
            return Optional.ofNullable(clazz.cast(endBehaviorAsString()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaintenanceWindows":
            return Optional.ofNullable(clazz.cast(maintenanceWindows()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndBehavior", END_BEHAVIOR_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MaintenanceWindows", MAINTENANCE_WINDOWS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskSchedulingConfig, T> g) {
        return obj -> g.apply((OtaTaskSchedulingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskSchedulingConfig> {
        /**
         * <p>
         * Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>. If
         * <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not apply.
         * </p>
         * 
         * @param endBehavior
         *        Specifies the end behavior for all task executions after a task reaches the selected
         *        <code>endTime</code>. If <code>endTime</code> is not selected when creating the task, then
         *        <code>endBehavior</code> does not apply.
         * @see SchedulingConfigEndBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingConfigEndBehavior
         */
        Builder endBehavior(String endBehavior);

        /**
         * <p>
         * Specifies the end behavior for all task executions after a task reaches the selected <code>endTime</code>. If
         * <code>endTime</code> is not selected when creating the task, then <code>endBehavior</code> does not apply.
         * </p>
         * 
         * @param endBehavior
         *        Specifies the end behavior for all task executions after a task reaches the selected
         *        <code>endTime</code>. If <code>endTime</code> is not selected when creating the task, then
         *        <code>endBehavior</code> does not apply.
         * @see SchedulingConfigEndBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingConfigEndBehavior
         */
        Builder endBehavior(SchedulingConfigEndBehavior endBehavior);

        /**
         * <p>
         * The time an over-the-air (OTA) task will stop.
         * </p>
         * 
         * @param endTime
         *        The time an over-the-air (OTA) task will stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * Maintenance window list for over-the-air (OTA) task scheduling config.
         * </p>
         * 
         * @param maintenanceWindows
         *        Maintenance window list for over-the-air (OTA) task scheduling config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindows(Collection<ScheduleMaintenanceWindow> maintenanceWindows);

        /**
         * <p>
         * Maintenance window list for over-the-air (OTA) task scheduling config.
         * </p>
         * 
         * @param maintenanceWindows
         *        Maintenance window list for over-the-air (OTA) task scheduling config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindows(ScheduleMaintenanceWindow... maintenanceWindows);

        /**
         * <p>
         * Maintenance window list for over-the-air (OTA) task scheduling config.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindow.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindow.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #maintenanceWindows(List<ScheduleMaintenanceWindow>)}.
         * 
         * @param maintenanceWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ScheduleMaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindows(java.util.Collection<ScheduleMaintenanceWindow>)
         */
        Builder maintenanceWindows(Consumer<ScheduleMaintenanceWindow.Builder>... maintenanceWindows);

        /**
         * <p>
         * The time an over-the-air (OTA) task will start.
         * </p>
         * 
         * @param startTime
         *        The time an over-the-air (OTA) task will start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);
    }

    static final class BuilderImpl implements Builder {
        private String endBehavior;

        private String endTime;

        private List<ScheduleMaintenanceWindow> maintenanceWindows = DefaultSdkAutoConstructList.getInstance();

        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskSchedulingConfig model) {
            endBehavior(model.endBehavior);
            endTime(model.endTime);
            maintenanceWindows(model.maintenanceWindows);
            startTime(model.startTime);
        }

        public final String getEndBehavior() {
            return endBehavior;
        }

        public final void setEndBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
        }

        @Override
        public final Builder endBehavior(String endBehavior) {
            this.endBehavior = endBehavior;
            return this;
        }

        @Override
        public final Builder endBehavior(SchedulingConfigEndBehavior endBehavior) {
            this.endBehavior(endBehavior == null ? null : endBehavior.toString());
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ScheduleMaintenanceWindow.Builder> getMaintenanceWindows() {
            List<ScheduleMaintenanceWindow.Builder> result = ScheduleMaintenanceWindowListCopier
                    .copyToBuilder(this.maintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceWindows(Collection<ScheduleMaintenanceWindow.BuilderImpl> maintenanceWindows) {
            this.maintenanceWindows = ScheduleMaintenanceWindowListCopier.copyFromBuilder(maintenanceWindows);
        }

        @Override
        public final Builder maintenanceWindows(Collection<ScheduleMaintenanceWindow> maintenanceWindows) {
            this.maintenanceWindows = ScheduleMaintenanceWindowListCopier.copy(maintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(ScheduleMaintenanceWindow... maintenanceWindows) {
            maintenanceWindows(Arrays.asList(maintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(Consumer<ScheduleMaintenanceWindow.Builder>... maintenanceWindows) {
            maintenanceWindows(Stream.of(maintenanceWindows)
                    .map(c -> ScheduleMaintenanceWindow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public OtaTaskSchedulingConfig build() {
            return new OtaTaskSchedulingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
