/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one over-the-air (OTA) task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskSummary implements SdkPojo, Serializable, ToCopyableBuilder<OtaTaskSummary.Builder, OtaTaskSummary> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(OtaTaskSummary::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(OtaTaskSummary::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(OtaTaskSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(OtaTaskSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskConfigurationId").getter(getter(OtaTaskSummary::taskConfigurationId))
            .setter(setter(Builder::taskConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OtaTaskSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_ARN_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TASK_CONFIGURATION_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String taskArn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String taskConfigurationId;

    private final String status;

    private OtaTaskSummary(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskArn = builder.taskArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.taskConfigurationId = builder.taskConfigurationId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The id of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The id of the over-the-air (OTA) task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the over-the-air (OTA) task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the over-the-air (OTA) task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task was created at.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task was created at.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task was last updated at.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task was last updated at.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The identifier for the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return The identifier for the over-the-air (OTA) task configuration.
     */
    public final String taskConfigurationId() {
        return taskConfigurationId;
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task summary.
     * @see OtaStatus
     */
    public final OtaStatus status() {
        return OtaStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the over-the-air (OTA) task summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OtaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the over-the-air (OTA) task summary.
     * @see OtaStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskSummary)) {
            return false;
        }
        OtaTaskSummary other = (OtaTaskSummary) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(taskConfigurationId(), other.taskConfigurationId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskSummary").add("TaskId", taskId()).add("TaskArn", taskArn()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("TaskConfigurationId", taskConfigurationId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "TaskConfigurationId":
            return Optional.ofNullable(clazz.cast(taskConfigurationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskId", TASK_ID_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskSummary, T> g) {
        return obj -> g.apply((OtaTaskSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskSummary> {
        /**
         * <p>
         * The id of the over-the-air (OTA) task.
         * </p>
         * 
         * @param taskId
         *        The id of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the over-the-air (OTA) task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task was created at.
         * </p>
         * 
         * @param createdAt
         *        The timestamp value of when the over-the-air (OTA) task was created at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task was last updated at.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp value of when the over-the-air (OTA) task was last updated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The identifier for the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param taskConfigurationId
         *        The identifier for the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfigurationId(String taskConfigurationId);

        /**
         * <p>
         * The status of the over-the-air (OTA) task summary.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task summary.
         * @see OtaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the over-the-air (OTA) task summary.
         * </p>
         * 
         * @param status
         *        The status of the over-the-air (OTA) task summary.
         * @see OtaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OtaStatus
         */
        Builder status(OtaStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String taskArn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String taskConfigurationId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskSummary model) {
            taskId(model.taskId);
            taskArn(model.taskArn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            taskConfigurationId(model.taskConfigurationId);
            status(model.status);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getTaskConfigurationId() {
            return taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OtaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public OtaTaskSummary build() {
            return new OtaTaskSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
