/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for proactively refreshing OAuth tokens before they expire.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProactiveRefreshTokenRenewal implements SdkPojo, Serializable,
        ToCopyableBuilder<ProactiveRefreshTokenRenewal.Builder, ProactiveRefreshTokenRenewal> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(ProactiveRefreshTokenRenewal::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> DAYS_BEFORE_RENEWAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DaysBeforeRenewal").getter(getter(ProactiveRefreshTokenRenewal::daysBeforeRenewal))
            .setter(setter(Builder::daysBeforeRenewal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysBeforeRenewal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DAYS_BEFORE_RENEWAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer daysBeforeRenewal;

    private ProactiveRefreshTokenRenewal(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.daysBeforeRenewal = builder.daysBeforeRenewal;
    }

    /**
     * <p>
     * Indicates whether proactive refresh token renewal is enabled.
     * </p>
     * 
     * @return Indicates whether proactive refresh token renewal is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The days before token expiration when the system should attempt to renew the token, specified in days.
     * </p>
     * 
     * @return The days before token expiration when the system should attempt to renew the token, specified in days.
     */
    public final Integer daysBeforeRenewal() {
        return daysBeforeRenewal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(daysBeforeRenewal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveRefreshTokenRenewal)) {
            return false;
        }
        ProactiveRefreshTokenRenewal other = (ProactiveRefreshTokenRenewal) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(daysBeforeRenewal(), other.daysBeforeRenewal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProactiveRefreshTokenRenewal").add("Enabled", enabled())
                .add("DaysBeforeRenewal", daysBeforeRenewal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "DaysBeforeRenewal":
            return Optional.ofNullable(clazz.cast(daysBeforeRenewal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("DaysBeforeRenewal", DAYS_BEFORE_RENEWAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProactiveRefreshTokenRenewal, T> g) {
        return obj -> g.apply((ProactiveRefreshTokenRenewal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProactiveRefreshTokenRenewal> {
        /**
         * <p>
         * Indicates whether proactive refresh token renewal is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether proactive refresh token renewal is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The days before token expiration when the system should attempt to renew the token, specified in days.
         * </p>
         * 
         * @param daysBeforeRenewal
         *        The days before token expiration when the system should attempt to renew the token, specified in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysBeforeRenewal(Integer daysBeforeRenewal);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer daysBeforeRenewal;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveRefreshTokenRenewal model) {
            enabled(model.enabled);
            daysBeforeRenewal(model.daysBeforeRenewal);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDaysBeforeRenewal() {
            return daysBeforeRenewal;
        }

        public final void setDaysBeforeRenewal(Integer daysBeforeRenewal) {
            this.daysBeforeRenewal = daysBeforeRenewal;
        }

        @Override
        public final Builder daysBeforeRenewal(Integer daysBeforeRenewal) {
            this.daysBeforeRenewal = daysBeforeRenewal;
            return this;
        }

        @Override
        public ProactiveRefreshTokenRenewal build() {
            return new ProactiveRefreshTokenRenewal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
