/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure describing a provisioning profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningProfileSummary.Builder, ProvisioningProfileSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProvisioningProfileSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProvisioningProfileSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ProvisioningProfileSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningType").getter(getter(ProvisioningProfileSummary::provisioningTypeAsString))
            .setter(setter(Builder::provisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, PROVISIONING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final String provisioningType;

    private ProvisioningProfileSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.provisioningType = builder.provisioningType;
    }

    /**
     * <p>
     * The name of the provisioning template.
     * </p>
     * 
     * @return The name of the provisioning template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the provisioning profile.
     * </p>
     * 
     * @return The identifier of the provisioning profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * @see ProvisioningType
     */
    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(provisioningType);
    }

    /**
     * <p>
     * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * @see ProvisioningType
     */
    public final String provisioningTypeAsString() {
        return provisioningType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningProfileSummary)) {
            return false;
        }
        ProvisioningProfileSummary other = (ProvisioningProfileSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(provisioningTypeAsString(), other.provisioningTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningProfileSummary").add("Name", name()).add("Id", id()).add("Arn", arn())
                .add("ProvisioningType", provisioningTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ProvisioningType":
            return Optional.ofNullable(clazz.cast(provisioningTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ProvisioningType", PROVISIONING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningProfileSummary, T> g) {
        return obj -> g.apply((ProvisioningProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningProfileSummary> {
        /**
         * <p>
         * The name of the provisioning template.
         * </p>
         * 
         * @param name
         *        The name of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the provisioning profile.
         * </p>
         * 
         * @param id
         *        The identifier of the provisioning profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * </p>
         * 
         * @param provisioningType
         *        The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(String provisioningType);

        /**
         * <p>
         * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * </p>
         * 
         * @param provisioningType
         *        The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(ProvisioningType provisioningType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String provisioningType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningProfileSummary model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            provisioningType(model.provisioningType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProvisioningType() {
            return provisioningType;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        @Override
        public ProvisioningProfileSummary build() {
            return new ProvisioningProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
