/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRuntimeLogConfigurationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<PutRuntimeLogConfigurationRequest.Builder, PutRuntimeLogConfigurationRequest> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(PutRuntimeLogConfigurationRequest::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagedThingId").build()).build();

    private static final SdkField<RuntimeLogConfigurations> RUNTIME_LOG_CONFIGURATIONS_FIELD = SdkField
            .<RuntimeLogConfigurations> builder(MarshallingType.SDK_POJO).memberName("RuntimeLogConfigurations")
            .getter(getter(PutRuntimeLogConfigurationRequest::runtimeLogConfigurations))
            .setter(setter(Builder::runtimeLogConfigurations)).constructor(RuntimeLogConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeLogConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            RUNTIME_LOG_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final RuntimeLogConfigurations runtimeLogConfigurations;

    private PutRuntimeLogConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.runtimeLogConfigurations = builder.runtimeLogConfigurations;
    }

    /**
     * <p>
     * The id for a managed thing.
     * </p>
     * 
     * @return The id for a managed thing.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The runtime log configuration for a managed thing.
     * </p>
     * 
     * @return The runtime log configuration for a managed thing.
     */
    public final RuntimeLogConfigurations runtimeLogConfigurations() {
        return runtimeLogConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeLogConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuntimeLogConfigurationRequest)) {
            return false;
        }
        PutRuntimeLogConfigurationRequest other = (PutRuntimeLogConfigurationRequest) obj;
        return Objects.equals(managedThingId(), other.managedThingId())
                && Objects.equals(runtimeLogConfigurations(), other.runtimeLogConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRuntimeLogConfigurationRequest").add("ManagedThingId", managedThingId())
                .add("RuntimeLogConfigurations", runtimeLogConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "RuntimeLogConfigurations":
            return Optional.ofNullable(clazz.cast(runtimeLogConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("RuntimeLogConfigurations", RUNTIME_LOG_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRuntimeLogConfigurationRequest, T> g) {
        return obj -> g.apply((PutRuntimeLogConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRuntimeLogConfigurationRequest> {
        /**
         * <p>
         * The id for a managed thing.
         * </p>
         * 
         * @param managedThingId
         *        The id for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The runtime log configuration for a managed thing.
         * </p>
         * 
         * @param runtimeLogConfigurations
         *        The runtime log configuration for a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeLogConfigurations(RuntimeLogConfigurations runtimeLogConfigurations);

        /**
         * <p>
         * The runtime log configuration for a managed thing.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuntimeLogConfigurations.Builder}
         * avoiding the need to create one manually via {@link RuntimeLogConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeLogConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #runtimeLogConfigurations(RuntimeLogConfigurations)}.
         * 
         * @param runtimeLogConfigurations
         *        a consumer that will call methods on {@link RuntimeLogConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeLogConfigurations(RuntimeLogConfigurations)
         */
        default Builder runtimeLogConfigurations(Consumer<RuntimeLogConfigurations.Builder> runtimeLogConfigurations) {
            return runtimeLogConfigurations(RuntimeLogConfigurations.builder().applyMutation(runtimeLogConfigurations).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String managedThingId;

        private RuntimeLogConfigurations runtimeLogConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuntimeLogConfigurationRequest model) {
            super(model);
            managedThingId(model.managedThingId);
            runtimeLogConfigurations(model.runtimeLogConfigurations);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final RuntimeLogConfigurations.Builder getRuntimeLogConfigurations() {
            return runtimeLogConfigurations != null ? runtimeLogConfigurations.toBuilder() : null;
        }

        public final void setRuntimeLogConfigurations(RuntimeLogConfigurations.BuilderImpl runtimeLogConfigurations) {
            this.runtimeLogConfigurations = runtimeLogConfigurations != null ? runtimeLogConfigurations.build() : null;
        }

        @Override
        public final Builder runtimeLogConfigurations(RuntimeLogConfigurations runtimeLogConfigurations) {
            this.runtimeLogConfigurations = runtimeLogConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRuntimeLogConfigurationRequest build() {
            return new PutRuntimeLogConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
