/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAccountAssociationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<RegisterAccountAssociationRequest.Builder, RegisterAccountAssociationRequest> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(RegisterAccountAssociationRequest::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(RegisterAccountAssociationRequest::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final SdkField<String> DEVICE_DISCOVERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceDiscoveryId").getter(getter(RegisterAccountAssociationRequest::deviceDiscoveryId))
            .setter(setter(Builder::deviceDiscoveryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDiscoveryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            ACCOUNT_ASSOCIATION_ID_FIELD, DEVICE_DISCOVERY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final String accountAssociationId;

    private final String deviceDiscoveryId;

    private RegisterAccountAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.accountAssociationId = builder.accountAssociationId;
        this.deviceDiscoveryId = builder.deviceDiscoveryId;
    }

    /**
     * <p>
     * The identifier of the managed thing to register with the account association.
     * </p>
     * 
     * @return The identifier of the managed thing to register with the account association.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The identifier of the account association to register with the managed thing.
     * </p>
     * 
     * @return The identifier of the account association to register with the managed thing.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The identifier of the device discovery job associated with this registration.
     * </p>
     * 
     * @return The identifier of the device discovery job associated with this registration.
     */
    public final String deviceDiscoveryId() {
        return deviceDiscoveryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDiscoveryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountAssociationRequest)) {
            return false;
        }
        RegisterAccountAssociationRequest other = (RegisterAccountAssociationRequest) obj;
        return Objects.equals(managedThingId(), other.managedThingId())
                && Objects.equals(accountAssociationId(), other.accountAssociationId())
                && Objects.equals(deviceDiscoveryId(), other.deviceDiscoveryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAccountAssociationRequest").add("ManagedThingId", managedThingId())
                .add("AccountAssociationId", accountAssociationId()).add("DeviceDiscoveryId", deviceDiscoveryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "DeviceDiscoveryId":
            return Optional.ofNullable(clazz.cast(deviceDiscoveryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("DeviceDiscoveryId", DEVICE_DISCOVERY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountAssociationRequest, T> g) {
        return obj -> g.apply((RegisterAccountAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterAccountAssociationRequest> {
        /**
         * <p>
         * The identifier of the managed thing to register with the account association.
         * </p>
         * 
         * @param managedThingId
         *        The identifier of the managed thing to register with the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The identifier of the account association to register with the managed thing.
         * </p>
         * 
         * @param accountAssociationId
         *        The identifier of the account association to register with the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The identifier of the device discovery job associated with this registration.
         * </p>
         * 
         * @param deviceDiscoveryId
         *        The identifier of the device discovery job associated with this registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDiscoveryId(String deviceDiscoveryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String managedThingId;

        private String accountAssociationId;

        private String deviceDiscoveryId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountAssociationRequest model) {
            super(model);
            managedThingId(model.managedThingId);
            accountAssociationId(model.accountAssociationId);
            deviceDiscoveryId(model.deviceDiscoveryId);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getDeviceDiscoveryId() {
            return deviceDiscoveryId;
        }

        public final void setDeviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
        }

        @Override
        public final Builder deviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAccountAssociationRequest build() {
            return new RegisterAccountAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
