/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing one retry config criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryConfigCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<RetryConfigCriteria.Builder, RetryConfigCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureType").getter(getter(RetryConfigCriteria::failureTypeAsString))
            .setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()).build();

    private static final SdkField<Integer> MIN_NUMBER_OF_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinNumberOfRetries").getter(getter(RetryConfigCriteria::minNumberOfRetries))
            .setter(setter(Builder::minNumberOfRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinNumberOfRetries").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD,
            MIN_NUMBER_OF_RETRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String failureType;

    private final Integer minNumberOfRetries;

    private RetryConfigCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.minNumberOfRetries = builder.minNumberOfRetries;
    }

    /**
     * <p>
     * Over-the-air (OTA) retry criteria failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link RetryCriteriaFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return Over-the-air (OTA) retry criteria failure type.
     * @see RetryCriteriaFailureType
     */
    public final RetryCriteriaFailureType failureType() {
        return RetryCriteriaFailureType.fromValue(failureType);
    }

    /**
     * <p>
     * Over-the-air (OTA) retry criteria failure type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link RetryCriteriaFailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureTypeAsString}.
     * </p>
     * 
     * @return Over-the-air (OTA) retry criteria failure type.
     * @see RetryCriteriaFailureType
     */
    public final String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The number of retries allowed for a failure type for the over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of retries allowed for a failure type for the over-the-air (OTA) task.
     */
    public final Integer minNumberOfRetries() {
        return minNumberOfRetries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minNumberOfRetries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryConfigCriteria)) {
            return false;
        }
        RetryConfigCriteria other = (RetryConfigCriteria) obj;
        return Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(minNumberOfRetries(), other.minNumberOfRetries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryConfigCriteria").add("FailureType", failureTypeAsString())
                .add("MinNumberOfRetries", minNumberOfRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "MinNumberOfRetries":
            return Optional.ofNullable(clazz.cast(minNumberOfRetries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailureType", FAILURE_TYPE_FIELD);
        map.put("MinNumberOfRetries", MIN_NUMBER_OF_RETRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryConfigCriteria, T> g) {
        return obj -> g.apply((RetryConfigCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryConfigCriteria> {
        /**
         * <p>
         * Over-the-air (OTA) retry criteria failure type.
         * </p>
         * 
         * @param failureType
         *        Over-the-air (OTA) retry criteria failure type.
         * @see RetryCriteriaFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryCriteriaFailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * Over-the-air (OTA) retry criteria failure type.
         * </p>
         * 
         * @param failureType
         *        Over-the-air (OTA) retry criteria failure type.
         * @see RetryCriteriaFailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryCriteriaFailureType
         */
        Builder failureType(RetryCriteriaFailureType failureType);

        /**
         * <p>
         * The number of retries allowed for a failure type for the over-the-air (OTA) task.
         * </p>
         * 
         * @param minNumberOfRetries
         *        The number of retries allowed for a failure type for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minNumberOfRetries(Integer minNumberOfRetries);
    }

    static final class BuilderImpl implements Builder {
        private String failureType;

        private Integer minNumberOfRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryConfigCriteria model) {
            failureType(model.failureType);
            minNumberOfRetries(model.minNumberOfRetries);
        }

        public final String getFailureType() {
            return failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(RetryCriteriaFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getMinNumberOfRetries() {
            return minNumberOfRetries;
        }

        public final void setMinNumberOfRetries(Integer minNumberOfRetries) {
            this.minNumberOfRetries = minNumberOfRetries;
        }

        @Override
        public final Builder minNumberOfRetries(Integer minNumberOfRetries) {
            this.minNumberOfRetries = minNumberOfRetries;
            return this;
        }

        @Override
        public RetryConfigCriteria build() {
            return new RetryConfigCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
