/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The different configurations for runtime logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeLogConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeLogConfigurations.Builder, RuntimeLogConfigurations> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(RuntimeLogConfigurations::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final SdkField<String> LOG_FLUSH_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFlushLevel").getter(getter(RuntimeLogConfigurations::logFlushLevelAsString))
            .setter(setter(Builder::logFlushLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFlushLevel").build()).build();

    private static final SdkField<String> LOCAL_STORE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalStoreLocation").getter(getter(RuntimeLogConfigurations::localStoreLocation))
            .setter(setter(Builder::localStoreLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreLocation").build())
            .build();

    private static final SdkField<Integer> LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LocalStoreFileRotationMaxFiles")
            .getter(getter(RuntimeLogConfigurations::localStoreFileRotationMaxFiles))
            .setter(setter(Builder::localStoreFileRotationMaxFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreFileRotationMaxFiles")
                    .build()).build();

    private static final SdkField<Integer> LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LocalStoreFileRotationMaxBytes")
            .getter(getter(RuntimeLogConfigurations::localStoreFileRotationMaxBytes))
            .setter(setter(Builder::localStoreFileRotationMaxBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreFileRotationMaxBytes")
                    .build()).build();

    private static final SdkField<Boolean> UPLOAD_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UploadLog").getter(getter(RuntimeLogConfigurations::uploadLog)).setter(setter(Builder::uploadLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadLog").build()).build();

    private static final SdkField<Integer> UPLOAD_PERIOD_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UploadPeriodMinutes").getter(getter(RuntimeLogConfigurations::uploadPeriodMinutes))
            .setter(setter(Builder::uploadPeriodMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPeriodMinutes").build())
            .build();

    private static final SdkField<Boolean> DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteLocalStoreAfterUpload")
            .getter(getter(RuntimeLogConfigurations::deleteLocalStoreAfterUpload))
            .setter(setter(Builder::deleteLocalStoreAfterUpload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteLocalStoreAfterUpload")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD,
            LOG_FLUSH_LEVEL_FIELD, LOCAL_STORE_LOCATION_FIELD, LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD,
            LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD, UPLOAD_LOG_FIELD, UPLOAD_PERIOD_MINUTES_FIELD,
            DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logLevel;

    private final String logFlushLevel;

    private final String localStoreLocation;

    private final Integer localStoreFileRotationMaxFiles;

    private final Integer localStoreFileRotationMaxBytes;

    private final Boolean uploadLog;

    private final Integer uploadPeriodMinutes;

    private final Boolean deleteLocalStoreAfterUpload;

    private RuntimeLogConfigurations(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.logFlushLevel = builder.logFlushLevel;
        this.localStoreLocation = builder.localStoreLocation;
        this.localStoreFileRotationMaxFiles = builder.localStoreFileRotationMaxFiles;
        this.localStoreFileRotationMaxBytes = builder.localStoreFileRotationMaxBytes;
        this.uploadLog = builder.uploadLog;
        this.uploadPeriodMinutes = builder.uploadPeriodMinutes;
        this.deleteLocalStoreAfterUpload = builder.deleteLocalStoreAfterUpload;
    }

    /**
     * <p>
     * The different log levels available for configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The different log levels available for configuration.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * The different log levels available for configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The different log levels available for configuration.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * The different log levels available for configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFlushLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFlushLevelAsString}.
     * </p>
     * 
     * @return The different log levels available for configuration.
     * @see LogLevel
     */
    public final LogLevel logFlushLevel() {
        return LogLevel.fromValue(logFlushLevel);
    }

    /**
     * <p>
     * The different log levels available for configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFlushLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFlushLevelAsString}.
     * </p>
     * 
     * @return The different log levels available for configuration.
     * @see LogLevel
     */
    public final String logFlushLevelAsString() {
        return logFlushLevel;
    }

    /**
     * <p>
     * Configuration of where to store runtime logs in the device.
     * </p>
     * 
     * @return Configuration of where to store runtime logs in the device.
     */
    public final String localStoreLocation() {
        return localStoreLocation;
    }

    /**
     * <p>
     * Configuration to set the maximum number of runtime log files that can be stored on the device before the oldest
     * files are deleted or overwritten.
     * </p>
     * 
     * @return Configuration to set the maximum number of runtime log files that can be stored on the device before the
     *         oldest files are deleted or overwritten.
     */
    public final Integer localStoreFileRotationMaxFiles() {
        return localStoreFileRotationMaxFiles;
    }

    /**
     * <p>
     * Configuration to set the maximum bytes of runtime logs that can be stored on the device before the oldest logs
     * are deleted or overwritten.
     * </p>
     * 
     * @return Configuration to set the maximum bytes of runtime logs that can be stored on the device before the oldest
     *         logs are deleted or overwritten.
     */
    public final Integer localStoreFileRotationMaxBytes() {
        return localStoreFileRotationMaxBytes;
    }

    /**
     * <p>
     * Configuration to enable or disable uploading of runtime logs to the cloud.
     * </p>
     * 
     * @return Configuration to enable or disable uploading of runtime logs to the cloud.
     */
    public final Boolean uploadLog() {
        return uploadLog;
    }

    /**
     * <p>
     * Configuration to set the time interval in minutes between each batch of runtime logs that the device uploads to
     * the cloud.
     * </p>
     * 
     * @return Configuration to set the time interval in minutes between each batch of runtime logs that the device
     *         uploads to the cloud.
     */
    public final Integer uploadPeriodMinutes() {
        return uploadPeriodMinutes;
    }

    /**
     * <p>
     * Configuration to enable or disable deleting of runtime logs in the device once uploaded to the cloud.
     * </p>
     * 
     * @return Configuration to enable or disable deleting of runtime logs in the device once uploaded to the cloud.
     */
    public final Boolean deleteLocalStoreAfterUpload() {
        return deleteLocalStoreAfterUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logFlushLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(localStoreLocation());
        hashCode = 31 * hashCode + Objects.hashCode(localStoreFileRotationMaxFiles());
        hashCode = 31 * hashCode + Objects.hashCode(localStoreFileRotationMaxBytes());
        hashCode = 31 * hashCode + Objects.hashCode(uploadLog());
        hashCode = 31 * hashCode + Objects.hashCode(uploadPeriodMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(deleteLocalStoreAfterUpload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeLogConfigurations)) {
            return false;
        }
        RuntimeLogConfigurations other = (RuntimeLogConfigurations) obj;
        return Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(logFlushLevelAsString(), other.logFlushLevelAsString())
                && Objects.equals(localStoreLocation(), other.localStoreLocation())
                && Objects.equals(localStoreFileRotationMaxFiles(), other.localStoreFileRotationMaxFiles())
                && Objects.equals(localStoreFileRotationMaxBytes(), other.localStoreFileRotationMaxBytes())
                && Objects.equals(uploadLog(), other.uploadLog())
                && Objects.equals(uploadPeriodMinutes(), other.uploadPeriodMinutes())
                && Objects.equals(deleteLocalStoreAfterUpload(), other.deleteLocalStoreAfterUpload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeLogConfigurations").add("LogLevel", logLevelAsString())
                .add("LogFlushLevel", logFlushLevelAsString()).add("LocalStoreLocation", localStoreLocation())
                .add("LocalStoreFileRotationMaxFiles", localStoreFileRotationMaxFiles())
                .add("LocalStoreFileRotationMaxBytes", localStoreFileRotationMaxBytes()).add("UploadLog", uploadLog())
                .add("UploadPeriodMinutes", uploadPeriodMinutes())
                .add("DeleteLocalStoreAfterUpload", deleteLocalStoreAfterUpload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "LogFlushLevel":
            return Optional.ofNullable(clazz.cast(logFlushLevelAsString()));
        case "LocalStoreLocation":
            return Optional.ofNullable(clazz.cast(localStoreLocation()));
        case "LocalStoreFileRotationMaxFiles":
            return Optional.ofNullable(clazz.cast(localStoreFileRotationMaxFiles()));
        case "LocalStoreFileRotationMaxBytes":
            return Optional.ofNullable(clazz.cast(localStoreFileRotationMaxBytes()));
        case "UploadLog":
            return Optional.ofNullable(clazz.cast(uploadLog()));
        case "UploadPeriodMinutes":
            return Optional.ofNullable(clazz.cast(uploadPeriodMinutes()));
        case "DeleteLocalStoreAfterUpload":
            return Optional.ofNullable(clazz.cast(deleteLocalStoreAfterUpload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogLevel", LOG_LEVEL_FIELD);
        map.put("LogFlushLevel", LOG_FLUSH_LEVEL_FIELD);
        map.put("LocalStoreLocation", LOCAL_STORE_LOCATION_FIELD);
        map.put("LocalStoreFileRotationMaxFiles", LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD);
        map.put("LocalStoreFileRotationMaxBytes", LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD);
        map.put("UploadLog", UPLOAD_LOG_FIELD);
        map.put("UploadPeriodMinutes", UPLOAD_PERIOD_MINUTES_FIELD);
        map.put("DeleteLocalStoreAfterUpload", DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeLogConfigurations, T> g) {
        return obj -> g.apply((RuntimeLogConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeLogConfigurations> {
        /**
         * <p>
         * The different log levels available for configuration.
         * </p>
         * 
         * @param logLevel
         *        The different log levels available for configuration.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * The different log levels available for configuration.
         * </p>
         * 
         * @param logLevel
         *        The different log levels available for configuration.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * <p>
         * The different log levels available for configuration.
         * </p>
         * 
         * @param logFlushLevel
         *        The different log levels available for configuration.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logFlushLevel(String logFlushLevel);

        /**
         * <p>
         * The different log levels available for configuration.
         * </p>
         * 
         * @param logFlushLevel
         *        The different log levels available for configuration.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logFlushLevel(LogLevel logFlushLevel);

        /**
         * <p>
         * Configuration of where to store runtime logs in the device.
         * </p>
         * 
         * @param localStoreLocation
         *        Configuration of where to store runtime logs in the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStoreLocation(String localStoreLocation);

        /**
         * <p>
         * Configuration to set the maximum number of runtime log files that can be stored on the device before the
         * oldest files are deleted or overwritten.
         * </p>
         * 
         * @param localStoreFileRotationMaxFiles
         *        Configuration to set the maximum number of runtime log files that can be stored on the device before
         *        the oldest files are deleted or overwritten.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStoreFileRotationMaxFiles(Integer localStoreFileRotationMaxFiles);

        /**
         * <p>
         * Configuration to set the maximum bytes of runtime logs that can be stored on the device before the oldest
         * logs are deleted or overwritten.
         * </p>
         * 
         * @param localStoreFileRotationMaxBytes
         *        Configuration to set the maximum bytes of runtime logs that can be stored on the device before the
         *        oldest logs are deleted or overwritten.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStoreFileRotationMaxBytes(Integer localStoreFileRotationMaxBytes);

        /**
         * <p>
         * Configuration to enable or disable uploading of runtime logs to the cloud.
         * </p>
         * 
         * @param uploadLog
         *        Configuration to enable or disable uploading of runtime logs to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadLog(Boolean uploadLog);

        /**
         * <p>
         * Configuration to set the time interval in minutes between each batch of runtime logs that the device uploads
         * to the cloud.
         * </p>
         * 
         * @param uploadPeriodMinutes
         *        Configuration to set the time interval in minutes between each batch of runtime logs that the device
         *        uploads to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPeriodMinutes(Integer uploadPeriodMinutes);

        /**
         * <p>
         * Configuration to enable or disable deleting of runtime logs in the device once uploaded to the cloud.
         * </p>
         * 
         * @param deleteLocalStoreAfterUpload
         *        Configuration to enable or disable deleting of runtime logs in the device once uploaded to the cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteLocalStoreAfterUpload(Boolean deleteLocalStoreAfterUpload);
    }

    static final class BuilderImpl implements Builder {
        private String logLevel;

        private String logFlushLevel;

        private String localStoreLocation;

        private Integer localStoreFileRotationMaxFiles;

        private Integer localStoreFileRotationMaxBytes;

        private Boolean uploadLog;

        private Integer uploadPeriodMinutes;

        private Boolean deleteLocalStoreAfterUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeLogConfigurations model) {
            logLevel(model.logLevel);
            logFlushLevel(model.logFlushLevel);
            localStoreLocation(model.localStoreLocation);
            localStoreFileRotationMaxFiles(model.localStoreFileRotationMaxFiles);
            localStoreFileRotationMaxBytes(model.localStoreFileRotationMaxBytes);
            uploadLog(model.uploadLog);
            uploadPeriodMinutes(model.uploadPeriodMinutes);
            deleteLocalStoreAfterUpload(model.deleteLocalStoreAfterUpload);
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getLogFlushLevel() {
            return logFlushLevel;
        }

        public final void setLogFlushLevel(String logFlushLevel) {
            this.logFlushLevel = logFlushLevel;
        }

        @Override
        public final Builder logFlushLevel(String logFlushLevel) {
            this.logFlushLevel = logFlushLevel;
            return this;
        }

        @Override
        public final Builder logFlushLevel(LogLevel logFlushLevel) {
            this.logFlushLevel(logFlushLevel == null ? null : logFlushLevel.toString());
            return this;
        }

        public final String getLocalStoreLocation() {
            return localStoreLocation;
        }

        public final void setLocalStoreLocation(String localStoreLocation) {
            this.localStoreLocation = localStoreLocation;
        }

        @Override
        public final Builder localStoreLocation(String localStoreLocation) {
            this.localStoreLocation = localStoreLocation;
            return this;
        }

        public final Integer getLocalStoreFileRotationMaxFiles() {
            return localStoreFileRotationMaxFiles;
        }

        public final void setLocalStoreFileRotationMaxFiles(Integer localStoreFileRotationMaxFiles) {
            this.localStoreFileRotationMaxFiles = localStoreFileRotationMaxFiles;
        }

        @Override
        public final Builder localStoreFileRotationMaxFiles(Integer localStoreFileRotationMaxFiles) {
            this.localStoreFileRotationMaxFiles = localStoreFileRotationMaxFiles;
            return this;
        }

        public final Integer getLocalStoreFileRotationMaxBytes() {
            return localStoreFileRotationMaxBytes;
        }

        public final void setLocalStoreFileRotationMaxBytes(Integer localStoreFileRotationMaxBytes) {
            this.localStoreFileRotationMaxBytes = localStoreFileRotationMaxBytes;
        }

        @Override
        public final Builder localStoreFileRotationMaxBytes(Integer localStoreFileRotationMaxBytes) {
            this.localStoreFileRotationMaxBytes = localStoreFileRotationMaxBytes;
            return this;
        }

        public final Boolean getUploadLog() {
            return uploadLog;
        }

        public final void setUploadLog(Boolean uploadLog) {
            this.uploadLog = uploadLog;
        }

        @Override
        public final Builder uploadLog(Boolean uploadLog) {
            this.uploadLog = uploadLog;
            return this;
        }

        public final Integer getUploadPeriodMinutes() {
            return uploadPeriodMinutes;
        }

        public final void setUploadPeriodMinutes(Integer uploadPeriodMinutes) {
            this.uploadPeriodMinutes = uploadPeriodMinutes;
        }

        @Override
        public final Builder uploadPeriodMinutes(Integer uploadPeriodMinutes) {
            this.uploadPeriodMinutes = uploadPeriodMinutes;
            return this;
        }

        public final Boolean getDeleteLocalStoreAfterUpload() {
            return deleteLocalStoreAfterUpload;
        }

        public final void setDeleteLocalStoreAfterUpload(Boolean deleteLocalStoreAfterUpload) {
            this.deleteLocalStoreAfterUpload = deleteLocalStoreAfterUpload;
        }

        @Override
        public final Builder deleteLocalStoreAfterUpload(Boolean deleteLocalStoreAfterUpload) {
            this.deleteLocalStoreAfterUpload = deleteLocalStoreAfterUpload;
            return this;
        }

        @Override
        public RuntimeLogConfigurations build() {
            return new RuntimeLogConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
