/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendConnectorEventRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<SendConnectorEventRequest.Builder, SendConnectorEventRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(SendConnectorEventRequest::connectorId))
            .setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConnectorId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(SendConnectorEventRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(SendConnectorEventRequest::operationAsString))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> OPERATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationVersion").getter(getter(SendConnectorEventRequest::operationVersion))
            .setter(setter(Builder::operationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationVersion").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(SendConnectorEventRequest::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(SendConnectorEventRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> DEVICE_DISCOVERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceDiscoveryId").getter(getter(SendConnectorEventRequest::deviceDiscoveryId))
            .setter(setter(Builder::deviceDiscoveryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDiscoveryId").build()).build();

    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceId").getter(getter(SendConnectorEventRequest::connectorDeviceId))
            .setter(setter(Builder::connectorDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TraceId").getter(getter(SendConnectorEventRequest::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceId").build()).build();

    private static final SdkField<List<Device>> DEVICES_FIELD = SdkField
            .<List<Device>> builder(MarshallingType.LIST)
            .memberName("Devices")
            .getter(getter(SendConnectorEventRequest::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Device> builder(MarshallingType.SDK_POJO)
                                            .constructor(Device::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MatterEndpoint> MATTER_ENDPOINT_FIELD = SdkField
            .<MatterEndpoint> builder(MarshallingType.SDK_POJO).memberName("MatterEndpoint")
            .getter(getter(SendConnectorEventRequest::matterEndpoint)).setter(setter(Builder::matterEndpoint))
            .constructor(MatterEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatterEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            USER_ID_FIELD, OPERATION_FIELD, OPERATION_VERSION_FIELD, STATUS_CODE_FIELD, MESSAGE_FIELD, DEVICE_DISCOVERY_ID_FIELD,
            CONNECTOR_DEVICE_ID_FIELD, TRACE_ID_FIELD, DEVICES_FIELD, MATTER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorId;

    private final String userId;

    private final String operation;

    private final String operationVersion;

    private final Integer statusCode;

    private final String message;

    private final String deviceDiscoveryId;

    private final String connectorDeviceId;

    private final String traceId;

    private final List<Device> devices;

    private final MatterEndpoint matterEndpoint;

    private SendConnectorEventRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.userId = builder.userId;
        this.operation = builder.operation;
        this.operationVersion = builder.operationVersion;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.deviceDiscoveryId = builder.deviceDiscoveryId;
        this.connectorDeviceId = builder.connectorDeviceId;
        this.traceId = builder.traceId;
        this.devices = builder.devices;
        this.matterEndpoint = builder.matterEndpoint;
    }

    /**
     * <p>
     * The id of the connector between the third-party cloud provider and IoT managed integrations.
     * </p>
     * 
     * @return The id of the connector between the third-party cloud provider and IoT managed integrations.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The id of the third-party cloud provider.
     * </p>
     * 
     * @return The id of the third-party cloud provider.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.
     * </p>
     * <note>
     * <p>
     * The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link ConnectorEventOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationAsString}.
     * </p>
     * 
     * @return The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.</p>
     *         <note>
     *         <p>
     *         The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
     *         </p>
     * @see ConnectorEventOperation
     */
    public final ConnectorEventOperation operation() {
        return ConnectorEventOperation.fromValue(operation);
    }

    /**
     * <p>
     * The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.
     * </p>
     * <note>
     * <p>
     * The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link ConnectorEventOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationAsString}.
     * </p>
     * 
     * @return The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.</p>
     *         <note>
     *         <p>
     *         The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
     *         </p>
     * @see ConnectorEventOperation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The Open Connectivity Foundation (OCF) security specification version for the operation being requested on the
     * managed thing. For more information, see <a
     * href="https://openconnectivity.org/specs/OCF_Security_Specification_v1.0.0.pdf">OCF Security Specification</a>.
     * </p>
     * 
     * @return The Open Connectivity Foundation (OCF) security specification version for the operation being requested
     *         on the managed thing. For more information, see <a
     *         href="https://openconnectivity.org/specs/OCF_Security_Specification_v1.0.0.pdf">OCF Security
     *         Specification</a>.
     */
    public final String operationVersion() {
        return operationVersion;
    }

    /**
     * <p>
     * The status code of the Open Connectivity Foundation (OCF) operation being performed on the managed thing.
     * </p>
     * 
     * @return The status code of the Open Connectivity Foundation (OCF) operation being performed on the managed thing.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The device state change event payload.
     * </p>
     * <p>
     * This parameter will include the following three fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>uri</code>: <code>schema auc://&lt;PARTNER-DEVICE-ID&gt;/ResourcePath</code> (The <code>Resourcepath</code>
     * corresponds to an OCF resource.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>op</code>: For device state changes, this field must populate as <code>n+d</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cn</code>: The content depends on the OCF resource referenced in <code>ResourcePath</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The device state change event payload.</p>
     *         <p>
     *         This parameter will include the following three fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>uri</code>: <code>schema auc://&lt;PARTNER-DEVICE-ID&gt;/ResourcePath</code> (The
     *         <code>Resourcepath</code> corresponds to an OCF resource.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>op</code>: For device state changes, this field must populate as <code>n+d</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cn</code>: The content depends on the OCF resource referenced in <code>ResourcePath</code>.
     *         </p>
     *         </li>
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The id for the device discovery job.
     * </p>
     * 
     * @return The id for the device discovery job.
     */
    public final String deviceDiscoveryId() {
        return deviceDiscoveryId;
    }

    /**
     * <p>
     * The third-party device id as defined by the connector. This device id must not contain personal identifiable
     * information (PII).
     * </p>
     * <note>
     * <p>
     * This parameter is used for cloud-to-cloud devices only.
     * </p>
     * </note>
     * 
     * @return The third-party device id as defined by the connector. This device id must not contain personal
     *         identifiable information (PII).</p> <note>
     *         <p>
     *         This parameter is used for cloud-to-cloud devices only.
     *         </p>
     */
    public final String connectorDeviceId() {
        return connectorDeviceId;
    }

    /**
     * <p>
     * The trace request identifier used to correlate a command request and response. This is specified by the device
     * owner, but will be generated by IoT managed integrations if not provided by the device owner.
     * </p>
     * 
     * @return The trace request identifier used to correlate a command request and response. This is specified by the
     *         device owner, but will be generated by IoT managed integrations if not provided by the device owner.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Devices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevices} method.
     * </p>
     * 
     * @return The list of devices.
     */
    public final List<Device> devices() {
        return devices;
    }

    /**
     * <p>
     * The device endpoint.
     * </p>
     * 
     * @return The device endpoint.
     */
    public final MatterEndpoint matterEndpoint() {
        return matterEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matterEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendConnectorEventRequest)) {
            return false;
        }
        SendConnectorEventRequest other = (SendConnectorEventRequest) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(operationAsString(), other.operationAsString())
                && Objects.equals(operationVersion(), other.operationVersion())
                && Objects.equals(statusCode(), other.statusCode()) && Objects.equals(message(), other.message())
                && Objects.equals(deviceDiscoveryId(), other.deviceDiscoveryId())
                && Objects.equals(connectorDeviceId(), other.connectorDeviceId()) && Objects.equals(traceId(), other.traceId())
                && hasDevices() == other.hasDevices() && Objects.equals(devices(), other.devices())
                && Objects.equals(matterEndpoint(), other.matterEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendConnectorEventRequest").add("ConnectorId", connectorId())
                .add("UserId", userId() == null ? null : "*** Sensitive Data Redacted ***").add("Operation", operationAsString())
                .add("OperationVersion", operationVersion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StatusCode", statusCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DeviceDiscoveryId", deviceDiscoveryId())
                .add("ConnectorDeviceId", connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TraceId", traceId()).add("Devices", hasDevices() ? devices() : null)
                .add("MatterEndpoint", matterEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "OperationVersion":
            return Optional.ofNullable(clazz.cast(operationVersion()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "DeviceDiscoveryId":
            return Optional.ofNullable(clazz.cast(deviceDiscoveryId()));
        case "ConnectorDeviceId":
            return Optional.ofNullable(clazz.cast(connectorDeviceId()));
        case "TraceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "Devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "MatterEndpoint":
            return Optional.ofNullable(clazz.cast(matterEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("OperationVersion", OPERATION_VERSION_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("DeviceDiscoveryId", DEVICE_DISCOVERY_ID_FIELD);
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("TraceId", TRACE_ID_FIELD);
        map.put("Devices", DEVICES_FIELD);
        map.put("MatterEndpoint", MATTER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendConnectorEventRequest, T> g) {
        return obj -> g.apply((SendConnectorEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendConnectorEventRequest> {
        /**
         * <p>
         * The id of the connector between the third-party cloud provider and IoT managed integrations.
         * </p>
         * 
         * @param connectorId
         *        The id of the connector between the third-party cloud provider and IoT managed integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The id of the third-party cloud provider.
         * </p>
         * 
         * @param userId
         *        The id of the third-party cloud provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.
         * </p>
         * <note>
         * <p>
         * The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
         * </p>
         * </note>
         * 
         * @param operation
         *        The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.</p>
         *        <note>
         *        <p>
         *        The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
         *        </p>
         * @see ConnectorEventOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorEventOperation
         */
        Builder operation(String operation);

        /**
         * <p>
         * The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.
         * </p>
         * <note>
         * <p>
         * The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
         * </p>
         * </note>
         * 
         * @param operation
         *        The Open Connectivity Foundation (OCF) operation requested to be performed on the managed thing.</p>
         *        <note>
         *        <p>
         *        The field op can have a value of "I" or "U". The field "cn" will contain the capability types.
         *        </p>
         * @see ConnectorEventOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorEventOperation
         */
        Builder operation(ConnectorEventOperation operation);

        /**
         * <p>
         * The Open Connectivity Foundation (OCF) security specification version for the operation being requested on
         * the managed thing. For more information, see <a
         * href="https://openconnectivity.org/specs/OCF_Security_Specification_v1.0.0.pdf">OCF Security
         * Specification</a>.
         * </p>
         * 
         * @param operationVersion
         *        The Open Connectivity Foundation (OCF) security specification version for the operation being
         *        requested on the managed thing. For more information, see <a
         *        href="https://openconnectivity.org/specs/OCF_Security_Specification_v1.0.0.pdf">OCF Security
         *        Specification</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationVersion(String operationVersion);

        /**
         * <p>
         * The status code of the Open Connectivity Foundation (OCF) operation being performed on the managed thing.
         * </p>
         * 
         * @param statusCode
         *        The status code of the Open Connectivity Foundation (OCF) operation being performed on the managed
         *        thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * The device state change event payload.
         * </p>
         * <p>
         * This parameter will include the following three fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>uri</code>: <code>schema auc://&lt;PARTNER-DEVICE-ID&gt;/ResourcePath</code> (The
         * <code>Resourcepath</code> corresponds to an OCF resource.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>op</code>: For device state changes, this field must populate as <code>n+d</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cn</code>: The content depends on the OCF resource referenced in <code>ResourcePath</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param message
         *        The device state change event payload.</p>
         *        <p>
         *        This parameter will include the following three fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>uri</code>: <code>schema auc://&lt;PARTNER-DEVICE-ID&gt;/ResourcePath</code> (The
         *        <code>Resourcepath</code> corresponds to an OCF resource.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>op</code>: For device state changes, this field must populate as <code>n+d</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cn</code>: The content depends on the OCF resource referenced in <code>ResourcePath</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The id for the device discovery job.
         * </p>
         * 
         * @param deviceDiscoveryId
         *        The id for the device discovery job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDiscoveryId(String deviceDiscoveryId);

        /**
         * <p>
         * The third-party device id as defined by the connector. This device id must not contain personal identifiable
         * information (PII).
         * </p>
         * <note>
         * <p>
         * This parameter is used for cloud-to-cloud devices only.
         * </p>
         * </note>
         * 
         * @param connectorDeviceId
         *        The third-party device id as defined by the connector. This device id must not contain personal
         *        identifiable information (PII).</p> <note>
         *        <p>
         *        This parameter is used for cloud-to-cloud devices only.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceId(String connectorDeviceId);

        /**
         * <p>
         * The trace request identifier used to correlate a command request and response. This is specified by the
         * device owner, but will be generated by IoT managed integrations if not provided by the device owner.
         * </p>
         * 
         * @param traceId
         *        The trace request identifier used to correlate a command request and response. This is specified by
         *        the device owner, but will be generated by IoT managed integrations if not provided by the device
         *        owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * <p>
         * The list of devices.
         * </p>
         * 
         * @param devices
         *        The list of devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<Device> devices);

        /**
         * <p>
         * The list of devices.
         * </p>
         * 
         * @param devices
         *        The list of devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Device... devices);

        /**
         * <p>
         * The list of devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.Device.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotmanagedintegrations.model.Device#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.Device.Builder#build()} is called
         * immediately and its result is passed to {@link #devices(List<Device>)}.
         * 
         * @param devices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(java.util.Collection<Device>)
         */
        Builder devices(Consumer<Device.Builder>... devices);

        /**
         * <p>
         * The device endpoint.
         * </p>
         * 
         * @param matterEndpoint
         *        The device endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matterEndpoint(MatterEndpoint matterEndpoint);

        /**
         * <p>
         * The device endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatterEndpoint.Builder} avoiding the need
         * to create one manually via {@link MatterEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatterEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #matterEndpoint(MatterEndpoint)}.
         * 
         * @param matterEndpoint
         *        a consumer that will call methods on {@link MatterEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matterEndpoint(MatterEndpoint)
         */
        default Builder matterEndpoint(Consumer<MatterEndpoint.Builder> matterEndpoint) {
            return matterEndpoint(MatterEndpoint.builder().applyMutation(matterEndpoint).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String userId;

        private String operation;

        private String operationVersion;

        private Integer statusCode;

        private String message;

        private String deviceDiscoveryId;

        private String connectorDeviceId;

        private String traceId;

        private List<Device> devices = DefaultSdkAutoConstructList.getInstance();

        private MatterEndpoint matterEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(SendConnectorEventRequest model) {
            super(model);
            connectorId(model.connectorId);
            userId(model.userId);
            operation(model.operation);
            operationVersion(model.operationVersion);
            statusCode(model.statusCode);
            message(model.message);
            deviceDiscoveryId(model.deviceDiscoveryId);
            connectorDeviceId(model.connectorDeviceId);
            traceId(model.traceId);
            devices(model.devices);
            matterEndpoint(model.matterEndpoint);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(ConnectorEventOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getOperationVersion() {
            return operationVersion;
        }

        public final void setOperationVersion(String operationVersion) {
            this.operationVersion = operationVersion;
        }

        @Override
        public final Builder operationVersion(String operationVersion) {
            this.operationVersion = operationVersion;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getDeviceDiscoveryId() {
            return deviceDiscoveryId;
        }

        public final void setDeviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
        }

        @Override
        public final Builder deviceDiscoveryId(String deviceDiscoveryId) {
            this.deviceDiscoveryId = deviceDiscoveryId;
            return this;
        }

        public final String getConnectorDeviceId() {
            return connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final List<Device.Builder> getDevices() {
            List<Device.Builder> result = DevicesCopier.copyToBuilder(this.devices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevices(Collection<Device.BuilderImpl> devices) {
            this.devices = DevicesCopier.copyFromBuilder(devices);
        }

        @Override
        public final Builder devices(Collection<Device> devices) {
            this.devices = DevicesCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Device... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<Device.Builder>... devices) {
            devices(Stream.of(devices).map(c -> Device.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MatterEndpoint.Builder getMatterEndpoint() {
            return matterEndpoint != null ? matterEndpoint.toBuilder() : null;
        }

        public final void setMatterEndpoint(MatterEndpoint.BuilderImpl matterEndpoint) {
            this.matterEndpoint = matterEndpoint != null ? matterEndpoint.build() : null;
        }

        @Override
        public final Builder matterEndpoint(MatterEndpoint matterEndpoint) {
            this.matterEndpoint = matterEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendConnectorEventRequest build() {
            return new SendConnectorEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
