/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountAssociationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<UpdateAccountAssociationRequest.Builder, UpdateAccountAssociationRequest> {
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(UpdateAccountAssociationRequest::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AccountAssociationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAccountAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAccountAssociationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSOCIATION_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountAssociationId;

    private final String name;

    private final String description;

    private UpdateAccountAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.accountAssociationId = builder.accountAssociationId;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The unique identifier of the account association to update.
     * </p>
     * 
     * @return The unique identifier of the account association to update.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The new name to assign to the account association.
     * </p>
     * 
     * @return The new name to assign to the account association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new description to assign to the account association.
     * </p>
     * 
     * @return The new description to assign to the account association.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountAssociationRequest)) {
            return false;
        }
        UpdateAccountAssociationRequest other = (UpdateAccountAssociationRequest) obj;
        return Objects.equals(accountAssociationId(), other.accountAssociationId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountAssociationRequest").add("AccountAssociationId", accountAssociationId())
                .add("Name", name()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountAssociationRequest, T> g) {
        return obj -> g.apply((UpdateAccountAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountAssociationRequest> {
        /**
         * <p>
         * The unique identifier of the account association to update.
         * </p>
         * 
         * @param accountAssociationId
         *        The unique identifier of the account association to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The new name to assign to the account association.
         * </p>
         * 
         * @param name
         *        The new name to assign to the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new description to assign to the account association.
         * </p>
         * 
         * @param description
         *        The new description to assign to the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String accountAssociationId;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountAssociationRequest model) {
            super(model);
            accountAssociationId(model.accountAssociationId);
            name(model.name);
            description(model.description);
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountAssociationRequest build() {
            return new UpdateAccountAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
