/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDestinationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<UpdateDestinationRequest.Builder, UpdateDestinationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryDestinationArn").getter(getter(UpdateDestinationRequest::deliveryDestinationArn))
            .setter(setter(Builder::deliveryDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationArn").build())
            .build();

    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryDestinationType").getter(getter(UpdateDestinationRequest::deliveryDestinationTypeAsString))
            .setter(setter(Builder::deliveryDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationType").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateDestinationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDestinationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DELIVERY_DESTINATION_ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String deliveryDestinationArn;

    private final String deliveryDestinationType;

    private final String roleArn;

    private final String description;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the customer-managed destination.
     * </p>
     * 
     * @return The name of the customer-managed destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer-managed destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer-managed destination.
     */
    public final String deliveryDestinationArn() {
        return deliveryDestinationArn;
    }

    /**
     * <p>
     * The destination type for the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination type for the customer-managed destination.
     * @see DeliveryDestinationType
     */
    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(deliveryDestinationType);
    }

    /**
     * <p>
     * The destination type for the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination type for the customer-managed destination.
     * @see DeliveryDestinationType
     */
    public final String deliveryDestinationTypeAsString() {
        return deliveryDestinationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the delivery destination role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the delivery destination role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The description of the customer-managed destination.
     * </p>
     * 
     * @return The description of the customer-managed destination.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(deliveryDestinationArn(), other.deliveryDestinationArn())
                && Objects.equals(deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDestinationRequest").add("Name", name())
                .add("DeliveryDestinationArn", deliveryDestinationArn())
                .add("DeliveryDestinationType", deliveryDestinationTypeAsString()).add("RoleArn", roleArn())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DeliveryDestinationArn":
            return Optional.ofNullable(clazz.cast(deliveryDestinationArn()));
        case "DeliveryDestinationType":
            return Optional.ofNullable(clazz.cast(deliveryDestinationTypeAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("DeliveryDestinationArn", DELIVERY_DESTINATION_ARN_FIELD);
        map.put("DeliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDestinationRequest> {
        /**
         * <p>
         * The name of the customer-managed destination.
         * </p>
         * 
         * @param name
         *        The name of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationArn
         *        The Amazon Resource Name (ARN) of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationArn(String deliveryDestinationArn);

        /**
         * <p>
         * The destination type for the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationType
         *        The destination type for the customer-managed destination.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(String deliveryDestinationType);

        /**
         * <p>
         * The destination type for the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationType
         *        The destination type for the customer-managed destination.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the delivery destination role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the delivery destination role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The description of the customer-managed destination.
         * </p>
         * 
         * @param description
         *        The description of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String name;

        private String deliveryDestinationArn;

        private String deliveryDestinationType;

        private String roleArn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            name(model.name);
            deliveryDestinationArn(model.deliveryDestinationArn);
            deliveryDestinationType(model.deliveryDestinationType);
            roleArn(model.roleArn);
            description(model.description);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDeliveryDestinationArn() {
            return deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
