/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventLogConfigurationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<UpdateEventLogConfigurationRequest.Builder, UpdateEventLogConfigurationRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateEventLogConfigurationRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> EVENT_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventLogLevel").getter(getter(UpdateEventLogConfigurationRequest::eventLogLevelAsString))
            .setter(setter(Builder::eventLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            EVENT_LOG_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String eventLogLevel;

    private UpdateEventLogConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.eventLogLevel = builder.eventLogLevel;
    }

    /**
     * <p>
     * The log configuration id.
     * </p>
     * 
     * @return The log configuration id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The log level for the event in terms of severity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventLogLevelAsString}.
     * </p>
     * 
     * @return The log level for the event in terms of severity.
     * @see LogLevel
     */
    public final LogLevel eventLogLevel() {
        return LogLevel.fromValue(eventLogLevel);
    }

    /**
     * <p>
     * The log level for the event in terms of severity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventLogLevelAsString}.
     * </p>
     * 
     * @return The log level for the event in terms of severity.
     * @see LogLevel
     */
    public final String eventLogLevelAsString() {
        return eventLogLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(eventLogLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventLogConfigurationRequest)) {
            return false;
        }
        UpdateEventLogConfigurationRequest other = (UpdateEventLogConfigurationRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(eventLogLevelAsString(), other.eventLogLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventLogConfigurationRequest").add("Id", id())
                .add("EventLogLevel", eventLogLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "EventLogLevel":
            return Optional.ofNullable(clazz.cast(eventLogLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("EventLogLevel", EVENT_LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventLogConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateEventLogConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEventLogConfigurationRequest> {
        /**
         * <p>
         * The log configuration id.
         * </p>
         * 
         * @param id
         *        The log configuration id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The log level for the event in terms of severity.
         * </p>
         * 
         * @param eventLogLevel
         *        The log level for the event in terms of severity.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder eventLogLevel(String eventLogLevel);

        /**
         * <p>
         * The log level for the event in terms of severity.
         * </p>
         * 
         * @param eventLogLevel
         *        The log level for the event in terms of severity.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder eventLogLevel(LogLevel eventLogLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String id;

        private String eventLogLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventLogConfigurationRequest model) {
            super(model);
            id(model.id);
            eventLogLevel(model.eventLogLevel);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEventLogLevel() {
            return eventLogLevel;
        }

        public final void setEventLogLevel(String eventLogLevel) {
            this.eventLogLevel = eventLogLevel;
        }

        @Override
        public final Builder eventLogLevel(String eventLogLevel) {
            this.eventLogLevel = eventLogLevel;
            return this;
        }

        @Override
        public final Builder eventLogLevel(LogLevel eventLogLevel) {
            this.eventLogLevel(eventLogLevel == null ? null : eventLogLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventLogConfigurationRequest build() {
            return new UpdateEventLogConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
