/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    DEVICE_COMMAND("DEVICE_COMMAND"),
    DEVICE_COMMAND_REQUEST("DEVICE_COMMAND_REQUEST"),
    DEVICE_DISCOVERY_STATUS("DEVICE_DISCOVERY_STATUS"),
    DEVICE_EVENT("DEVICE_EVENT"),
    DEVICE_LIFE_CYCLE("DEVICE_LIFE_CYCLE"),
    DEVICE_STATE("DEVICE_STATE"),
    DEVICE_OTA("DEVICE_OTA"),
    CONNECTOR_ASSOCIATION("CONNECTOR_ASSOCIATION"),
    ACCOUNT_ASSOCIATION("ACCOUNT_ASSOCIATION"),
    CONNECTOR_ERROR_REPORT("CONNECTOR_ERROR_REPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

