/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeliveryDestinationType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDestinationResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetDestinationResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDestinationResponse.getter(GetDestinationResponse::description)).setter(GetDestinationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryDestinationArn").getter(GetDestinationResponse.getter(GetDestinationResponse::deliveryDestinationArn)).setter(GetDestinationResponse.setter(Builder::deliveryDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationArn").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryDestinationType").getter(GetDestinationResponse.getter(GetDestinationResponse::deliveryDestinationTypeAsString)).setter(GetDestinationResponse.setter(Builder::deliveryDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDestinationResponse.getter(GetDestinationResponse::name)).setter(GetDestinationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GetDestinationResponse.getter(GetDestinationResponse::roleArn)).setter(GetDestinationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetDestinationResponse.getter(GetDestinationResponse::createdAt)).setter(GetDestinationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetDestinationResponse.getter(GetDestinationResponse::updatedAt)).setter(GetDestinationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetDestinationResponse.getter(GetDestinationResponse::tags)).setter(GetDestinationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DELIVERY_DESTINATION_ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, NAME_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDestinationResponse.memberNameToFieldInitializer();
    private final String description;
    private final String deliveryDestinationArn;
    private final String deliveryDestinationType;
    private final String name;
    private final String roleArn;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;

    private GetDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String deliveryDestinationArn() {
        return this.deliveryDestinationArn;
    }

    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(this.deliveryDestinationType);
    }

    public final String deliveryDestinationTypeAsString() {
        return this.deliveryDestinationType;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    @Deprecated
    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    @Deprecated
    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDestinationResponse)) {
            return false;
        }
        GetDestinationResponse other = (GetDestinationResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.deliveryDestinationArn(), other.deliveryDestinationArn()) && Objects.equals(this.deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDestinationResponse").add("Description", (Object)this.description()).add("DeliveryDestinationArn", (Object)this.deliveryDestinationArn()).add("DeliveryDestinationType", (Object)this.deliveryDestinationTypeAsString()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeliveryDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationArn()));
            }
            case "DeliveryDestinationType": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeliveryDestinationArn", DELIVERY_DESTINATION_ARN_FIELD);
        map.put("DeliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDestinationResponse, T> g) {
        return obj -> g.apply((GetDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String description;
        private String deliveryDestinationArn;
        private String deliveryDestinationType;
        private String name;
        private String roleArn;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDestinationResponse model) {
            super(model);
            this.description(model.description);
            this.deliveryDestinationArn(model.deliveryDestinationArn);
            this.deliveryDestinationType(model.deliveryDestinationType);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeliveryDestinationArn() {
            return this.deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return this.deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDestinationResponse build() {
            return new GetDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDestinationResponse> {
        public Builder description(String var1);

        public Builder deliveryDestinationArn(String var1);

        public Builder deliveryDestinationType(String var1);

        public Builder deliveryDestinationType(DeliveryDestinationType var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        @Deprecated
        public Builder tags(Map<String, String> var1);
    }
}

