/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AccessDeniedException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConflictException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCertificateRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCertificateResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InternalFailureException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InternalServerException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.InvalidRequestException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.LimitExceededException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ThrottlingException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UnauthorizedException;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ValidationException;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable;
import software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable;

/**
 * Service client for accessing Managed integrations for AWS IoT Device Management. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Managed integrations is a feature of AWS IoT Device Management that enables developers to quickly build innovative
 * IoT solutions. Customers can use managed integrations to automate device setup workflows and support interoperability
 * across many devices, regardless of device vendor or connectivity protocol. This allows developers to use a single
 * user-interface to control, manage, and operate a range of devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotManagedIntegrationsClient extends AwsClient {
    String SERVICE_NAME = "iotmanagedintegrations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.iotmanagedintegrations";

    /**
     * <p>
     * Creates a new account association via the destination id.
     * </p>
     *
     * @param createAccountAssociationRequest
     * @return Result of the CreateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountAssociationResponse createAccountAssociation(
            CreateAccountAssociationRequest createAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ConflictException, ServiceUnavailableException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new account association via the destination id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAccountAssociationRequest#builder()}
     * </p>
     *
     * @param createAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateAccountAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccountAssociationResponse createAccountAssociation(
            Consumer<CreateAccountAssociationRequest.Builder> createAccountAssociationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return createAccountAssociation(CreateAccountAssociationRequest.builder().applyMutation(createAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a C2C (cloud-to-cloud) connector.
     * </p>
     *
     * @param createCloudConnectorRequest
     * @return Result of the CreateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudConnectorResponse createCloudConnector(CreateCloudConnectorRequest createCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a C2C (cloud-to-cloud) connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCloudConnectorRequest#builder()}
     * </p>
     *
     * @param createCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCloudConnectorRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudConnectorResponse createCloudConnector(
            Consumer<CreateCloudConnectorRequest.Builder> createCloudConnectorRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return createCloudConnector(CreateCloudConnectorRequest.builder().applyMutation(createCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Create a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     *
     * @param createConnectorDestinationRequest
     * @return Result of the CreateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDestinationResponse createConnectorDestination(
            CreateConnectorDestinationRequest createConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a connector destination for connecting a cloud-to-cloud (C2C) connector to the customer's Amazon Web
     * Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param createConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConnectorDestinationResponse createConnectorDestination(
            Consumer<CreateConnectorDestinationRequest.Builder> createConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return createConnectorDestination(CreateConnectorDestinationRequest.builder()
                .applyMutation(createConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Create a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation will not trigger the creation of all the manufacturing resources.
     * </p>
     * </note>
     *
     * @param createCredentialLockerRequest
     * @return Result of the CreateCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCredentialLockerResponse createCredentialLocker(CreateCredentialLockerRequest createCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation will not trigger the creation of all the manufacturing resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCredentialLockerRequest#builder()}
     * </p>
     *
     * @param createCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateCredentialLockerRequest.Builder}
     *        to create a request.
     * @return Result of the CreateCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCredentialLockerResponse createCredentialLocker(
            Consumer<CreateCredentialLockerRequest.Builder> createCredentialLockerRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceQuotaExceededException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return createCredentialLocker(CreateCredentialLockerRequest.builder().applyMutation(createCredentialLockerRequest)
                .build());
    }

    /**
     * <p>
     * Create a notification destination such as Kinesis Data Streams that receive events and notifications from Managed
     * integrations. Managed integrations uses the destination to determine where to deliver notifications.
     * </p>
     *
     * @param createDestinationRequest
     * @return Result of the CreateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDestinationResponse createDestination(CreateDestinationRequest createDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a notification destination such as Kinesis Data Streams that receive events and notifications from Managed
     * integrations. Managed integrations uses the destination to determine where to deliver notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDestinationResponse createDestination(Consumer<CreateDestinationRequest.Builder> createDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Set the event log configuration for the account, resource type, or specific resource.
     * </p>
     *
     * @param createEventLogConfigurationRequest
     * @return Result of the CreateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventLogConfigurationResponse createEventLogConfiguration(
            CreateEventLogConfigurationRequest createEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the event log configuration for the account, resource type, or specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param createEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded for this request.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventLogConfigurationResponse createEventLogConfiguration(
            Consumer<CreateEventLogConfigurationRequest.Builder> createEventLogConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return createEventLogConfiguration(CreateEventLogConfigurationRequest.builder()
                .applyMutation(createEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a managed thing. A managed thing contains the device identifier, protocol supported, and capabilities of
     * the device in a data model format defined by Managed integrations.
     * </p>
     *
     * @param createManagedThingRequest
     * @return Result of the CreateManagedThing operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateManagedThingResponse createManagedThing(CreateManagedThingRequest createManagedThingRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed thing. A managed thing contains the device identifier, protocol supported, and capabilities of
     * the device in a data model format defined by Managed integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateManagedThingRequest#builder()}
     * </p>
     *
     * @param createManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateManagedThingRequest.Builder} to
     *        create a request.
     * @return Result of the CreateManagedThing operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateManagedThingResponse createManagedThing(Consumer<CreateManagedThingRequest.Builder> createManagedThingRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return createManagedThing(CreateManagedThingRequest.builder().applyMutation(createManagedThingRequest).build());
    }

    /**
     * <p>
     * Creates a notification configuration. A configuration is a connection between an event type and a destination
     * that you have already created.
     * </p>
     *
     * @param createNotificationConfigurationRequest
     * @return Result of the CreateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationConfigurationResponse createNotificationConfiguration(
            CreateNotificationConfigurationRequest createNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a notification configuration. A configuration is a connection between an event type and a destination
     * that you have already created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationConfigurationResponse createNotificationConfiguration(
            Consumer<CreateNotificationConfigurationRequest.Builder> createNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return createNotificationConfiguration(CreateNotificationConfigurationRequest.builder()
                .applyMutation(createNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Create an over-the-air (OTA) task to target a device.
     * </p>
     *
     * @param createOtaTaskRequest
     * @return Result of the CreateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOtaTaskResponse createOtaTask(CreateOtaTaskRequest createOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an over-the-air (OTA) task to target a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOtaTaskRequest#builder()}
     * </p>
     *
     * @param createOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskRequest.Builder} to
     *        create a request.
     * @return Result of the CreateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOtaTaskResponse createOtaTask(Consumer<CreateOtaTaskRequest.Builder> createOtaTaskRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return createOtaTask(CreateOtaTaskRequest.builder().applyMutation(createOtaTaskRequest).build());
    }

    /**
     * <p>
     * Create a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param createOtaTaskConfigurationRequest
     * @return Result of the CreateOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOtaTaskConfigurationResponse createOtaTaskConfiguration(
            CreateOtaTaskConfigurationRequest createOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a configuraiton for the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param createOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOtaTaskConfigurationResponse createOtaTaskConfiguration(
            Consumer<CreateOtaTaskConfigurationRequest.Builder> createOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return createOtaTaskConfiguration(CreateOtaTaskConfigurationRequest.builder()
                .applyMutation(createOtaTaskConfigurationRequest).build());
    }

    /**
     * <p>
     * Create a provisioning profile for a device to execute the provisioning flows using a provisioning template. The
     * provisioning template is a document that defines the set of resources and policies applied to a device during the
     * provisioning process.
     * </p>
     *
     * @param createProvisioningProfileRequest
     * @return Result of the CreateProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisioningProfileResponse createProvisioningProfile(
            CreateProvisioningProfileRequest createProvisioningProfileRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ConflictException, ServiceUnavailableException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a provisioning profile for a device to execute the provisioning flows using a provisioning template. The
     * provisioning template is a document that defines the set of resources and policies applied to a device during the
     * provisioning process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningProfileRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param createProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CreateProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return Result of the CreateProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.CreateProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/CreateProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProvisioningProfileResponse createProvisioningProfile(
            Consumer<CreateProvisioningProfileRequest.Builder> createProvisioningProfileRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return createProvisioningProfile(CreateProvisioningProfileRequest.builder()
                .applyMutation(createProvisioningProfileRequest).build());
    }

    /**
     * <p>
     * Remove a third-party account association for an end user.
     * </p>
     * <note>
     * <p>
     * You must first call the <code>DeregisterAccountAssociation</code> to remove the connection between the managed
     * thing and the third-party account before calling the <code>DeleteAccountAssociation</code> API.
     * </p>
     * </note>
     *
     * @param deleteAccountAssociationRequest
     * @return Result of the DeleteAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAssociationResponse deleteAccountAssociation(
            DeleteAccountAssociationRequest deleteAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ServiceUnavailableException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a third-party account association for an end user.
     * </p>
     * <note>
     * <p>
     * You must first call the <code>DeregisterAccountAssociation</code> to remove the connection between the managed
     * thing and the third-party account before calling the <code>DeleteAccountAssociation</code> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccountAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteAccountAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccountAssociationResponse deleteAccountAssociation(
            Consumer<DeleteAccountAssociationRequest.Builder> deleteAccountAssociationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteAccountAssociation(DeleteAccountAssociationRequest.builder().applyMutation(deleteAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Delete a cloud connector.
     * </p>
     *
     * @param deleteCloudConnectorRequest
     * @return Result of the DeleteCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudConnectorResponse deleteCloudConnector(DeleteCloudConnectorRequest deleteCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a cloud connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCloudConnectorRequest#builder()}
     * </p>
     *
     * @param deleteCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCloudConnectorRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudConnectorResponse deleteCloudConnector(
            Consumer<DeleteCloudConnectorRequest.Builder> deleteCloudConnectorRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteCloudConnector(DeleteCloudConnectorRequest.builder().applyMutation(deleteCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Delete a connector destination linked to a cloud-to-cloud (C2C) connector.
     * </p>
     * <note>
     * <p>
     * Deletion can't be done if the account association has used this connector destination.
     * </p>
     * </note>
     *
     * @param deleteConnectorDestinationRequest
     * @return Result of the DeleteConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorDestinationResponse deleteConnectorDestination(
            DeleteConnectorDestinationRequest deleteConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a connector destination linked to a cloud-to-cloud (C2C) connector.
     * </p>
     * <note>
     * <p>
     * Deletion can't be done if the account association has used this connector destination.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConnectorDestinationResponse deleteConnectorDestination(
            Consumer<DeleteConnectorDestinationRequest.Builder> deleteConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return deleteConnectorDestination(DeleteConnectorDestinationRequest.builder()
                .applyMutation(deleteConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Delete a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation can't be undone and any existing device won't be able to use IoT managed integrations.
     * </p>
     * </note>
     *
     * @param deleteCredentialLockerRequest
     * @return Result of the DeleteCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCredentialLockerResponse deleteCredentialLocker(DeleteCredentialLockerRequest deleteCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a credential locker.
     * </p>
     * <note>
     * <p>
     * This operation can't be undone and any existing device won't be able to use IoT managed integrations.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCredentialLockerRequest#builder()}
     * </p>
     *
     * @param deleteCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteCredentialLockerRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCredentialLockerResponse deleteCredentialLocker(
            Consumer<DeleteCredentialLockerRequest.Builder> deleteCredentialLockerRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteCredentialLocker(DeleteCredentialLockerRequest.builder().applyMutation(deleteCredentialLockerRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a notification destination specified by name.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notification destination specified by name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDestinationResponse deleteDestination(Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Delete an event log configuration.
     * </p>
     *
     * @param deleteEventLogConfigurationRequest
     * @return Result of the DeleteEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventLogConfigurationResponse deleteEventLogConfiguration(
            DeleteEventLogConfigurationRequest deleteEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an event log configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventLogConfigurationResponse deleteEventLogConfiguration(
            Consumer<DeleteEventLogConfigurationRequest.Builder> deleteEventLogConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteEventLogConfiguration(DeleteEventLogConfigurationRequest.builder()
                .applyMutation(deleteEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete a managed thing. For direct-connected and hub-connected devices connecting with Managed integrations via a
     * controller, all of the devices connected to it will have their status changed to <code>PENDING</code>. It is not
     * possible to remove a cloud-to-cloud device.
     * </p>
     *
     * @param deleteManagedThingRequest
     * @return Result of the DeleteManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteManagedThingResponse deleteManagedThing(DeleteManagedThingRequest deleteManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a managed thing. For direct-connected and hub-connected devices connecting with Managed integrations via a
     * controller, all of the devices connected to it will have their status changed to <code>PENDING</code>. It is not
     * possible to remove a cloud-to-cloud device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteManagedThingRequest#builder()}
     * </p>
     *
     * @param deleteManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteManagedThingRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteManagedThingResponse deleteManagedThing(Consumer<DeleteManagedThingRequest.Builder> deleteManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return deleteManagedThing(DeleteManagedThingRequest.builder().applyMutation(deleteManagedThingRequest).build());
    }

    /**
     * <p>
     * Deletes a notification configuration.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task.
     * </p>
     *
     * @param deleteOtaTaskRequest
     * @return Result of the DeleteOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws LimitExceededException
     *         The request exceeds a service limit or quota. Adjust your request parameters and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOtaTaskResponse deleteOtaTask(DeleteOtaTaskRequest deleteOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOtaTaskRequest#builder()}
     * </p>
     *
     * @param deleteOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws LimitExceededException
     *         The request exceeds a service limit or quota. Adjust your request parameters and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOtaTaskResponse deleteOtaTask(Consumer<DeleteOtaTaskRequest.Builder> deleteOtaTaskRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deleteOtaTask(DeleteOtaTaskRequest.builder().applyMutation(deleteOtaTaskRequest).build());
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task configuration.
     * </p>
     *
     * @param deleteOtaTaskConfigurationRequest
     * @return Result of the DeleteOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOtaTaskConfigurationResponse deleteOtaTaskConfiguration(
            DeleteOtaTaskConfigurationRequest deleteOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the over-the-air (OTA) task configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOtaTaskConfigurationResponse deleteOtaTaskConfiguration(
            Consumer<DeleteOtaTaskConfigurationRequest.Builder> deleteOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return deleteOtaTaskConfiguration(DeleteOtaTaskConfigurationRequest.builder()
                .applyMutation(deleteOtaTaskConfigurationRequest).build());
    }

    /**
     * <p>
     * Delete a provisioning profile.
     * </p>
     *
     * @param deleteProvisioningProfileRequest
     * @return Result of the DeleteProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisioningProfileResponse deleteProvisioningProfile(
            DeleteProvisioningProfileRequest deleteProvisioningProfileRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a provisioning profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeleteProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeleteProvisioningProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeleteProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProvisioningProfileResponse deleteProvisioningProfile(
            Consumer<DeleteProvisioningProfileRequest.Builder> deleteProvisioningProfileRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return deleteProvisioningProfile(DeleteProvisioningProfileRequest.builder()
                .applyMutation(deleteProvisioningProfileRequest).build());
    }

    /**
     * <p>
     * Deregister an account association from a managed thing.
     * </p>
     *
     * @param deregisterAccountAssociationRequest
     *        Request for deregister a managed thing from account association
     * @return Result of the DeregisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeregisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeregisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterAccountAssociationResponse deregisterAccountAssociation(
            DeregisterAccountAssociationRequest deregisterAccountAssociationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregister an account association from a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterAccountAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterAccountAssociationRequest#builder()}
     * </p>
     *
     * @param deregisterAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.DeregisterAccountAssociationRequest.Builder}
     *        to create a request. Request for deregister a managed thing from account association
     * @return Result of the DeregisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.DeregisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/DeregisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterAccountAssociationResponse deregisterAccountAssociation(
            Consumer<DeregisterAccountAssociationRequest.Builder> deregisterAccountAssociationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return deregisterAccountAssociation(DeregisterAccountAssociationRequest.builder()
                .applyMutation(deregisterAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Get an account association for an Amazon Web Services account linked to a customer-managed destination.
     * </p>
     *
     * @param getAccountAssociationRequest
     * @return Result of the GetAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetAccountAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAssociationResponse getAccountAssociation(GetAccountAssociationRequest getAccountAssociationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an account association for an Amazon Web Services account linked to a customer-managed destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountAssociationRequest#builder()}
     * </p>
     *
     * @param getAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetAccountAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetAccountAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountAssociationResponse getAccountAssociation(
            Consumer<GetAccountAssociationRequest.Builder> getAccountAssociationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getAccountAssociation(GetAccountAssociationRequest.builder().applyMutation(getAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Get configuration details for a cloud connector.
     * </p>
     *
     * @param getCloudConnectorRequest
     * @return Result of the GetCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudConnectorResponse getCloudConnector(GetCloudConnectorRequest getCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get configuration details for a cloud connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link GetCloudConnectorRequest#builder()}
     * </p>
     *
     * @param getCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCloudConnectorRequest.Builder} to
     *        create a request.
     * @return Result of the GetCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudConnectorResponse getCloudConnector(Consumer<GetCloudConnectorRequest.Builder> getCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getCloudConnector(GetCloudConnectorRequest.builder().applyMutation(getCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Get connector destination details linked to a cloud-to-cloud (C2C) connector.
     * </p>
     *
     * @param getConnectorDestinationRequest
     * @return Result of the GetConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDestinationResponse getConnectorDestination(GetConnectorDestinationRequest getConnectorDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get connector destination details linked to a cloud-to-cloud (C2C) connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param getConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return Result of the GetConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConnectorDestinationResponse getConnectorDestination(
            Consumer<GetConnectorDestinationRequest.Builder> getConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return getConnectorDestination(GetConnectorDestinationRequest.builder().applyMutation(getConnectorDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Get information on an existing credential locker
     * </p>
     *
     * @param getCredentialLockerRequest
     * @return Result of the GetCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCredentialLockerResponse getCredentialLocker(GetCredentialLockerRequest getCredentialLockerRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information on an existing credential locker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCredentialLockerRequest.Builder} avoiding the
     * need to create one manually via {@link GetCredentialLockerRequest#builder()}
     * </p>
     *
     * @param getCredentialLockerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCredentialLockerRequest.Builder} to
     *        create a request.
     * @return Result of the GetCredentialLocker operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCredentialLocker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCredentialLocker"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCredentialLockerResponse getCredentialLocker(
            Consumer<GetCredentialLockerRequest.Builder> getCredentialLockerRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getCredentialLocker(GetCredentialLockerRequest.builder().applyMutation(getCredentialLockerRequest).build());
    }

    /**
     * <p>
     * Returns the IoT managed integrations custom endpoint.
     * </p>
     *
     * @param getCustomEndpointRequest
     * @return Result of the GetCustomEndpoint operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomEndpointResponse getCustomEndpoint(GetCustomEndpointRequest getCustomEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the IoT managed integrations custom endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link GetCustomEndpointRequest#builder()}
     * </p>
     *
     * @param getCustomEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetCustomEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the GetCustomEndpoint operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCustomEndpointResponse getCustomEndpoint(Consumer<GetCustomEndpointRequest.Builder> getCustomEndpointRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getCustomEndpoint(GetCustomEndpointRequest.builder().applyMutation(getCustomEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     *
     * @param getDefaultEncryptionConfigurationRequest
     * @return Result of the GetDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultEncryptionConfigurationResponse getDefaultEncryptionConfiguration(
            GetDefaultEncryptionConfigurationRequest getDefaultEncryptionConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalFailureException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>AWS IoT SiteWise User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param getDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultEncryptionConfigurationResponse getDefaultEncryptionConfiguration(
            Consumer<GetDefaultEncryptionConfigurationRequest.Builder> getDefaultEncryptionConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalFailureException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getDefaultEncryptionConfiguration(GetDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(getDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a destination by name.
     * </p>
     *
     * @param getDestinationRequest
     * @return Result of the GetDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDestinationResponse getDestination(GetDestinationRequest getDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a destination by name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the GetDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDestinationResponse getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Get the current state of a device discovery.
     * </p>
     *
     * @param getDeviceDiscoveryRequest
     * @return Result of the GetDeviceDiscovery operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDiscoveryResponse getDeviceDiscovery(GetDeviceDiscoveryRequest getDeviceDiscoveryRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the current state of a device discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceDiscoveryRequest.Builder} avoiding the
     * need to create one manually via {@link GetDeviceDiscoveryRequest#builder()}
     * </p>
     *
     * @param getDeviceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetDeviceDiscoveryRequest.Builder} to
     *        create a request.
     * @return Result of the GetDeviceDiscovery operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeviceDiscoveryResponse getDeviceDiscovery(Consumer<GetDeviceDiscoveryRequest.Builder> getDeviceDiscoveryRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getDeviceDiscovery(GetDeviceDiscoveryRequest.builder().applyMutation(getDeviceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Get an event log configuration.
     * </p>
     *
     * @param getEventLogConfigurationRequest
     * @return Result of the GetEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventLogConfigurationResponse getEventLogConfiguration(
            GetEventLogConfigurationRequest getEventLogConfigurationRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an event log configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param getEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventLogConfigurationResponse getEventLogConfiguration(
            Consumer<GetEventLogConfigurationRequest.Builder> getEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return getEventLogConfiguration(GetEventLogConfigurationRequest.builder().applyMutation(getEventLogConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get a hub configuration.
     * </p>
     *
     * @param getHubConfigurationRequest
     * @return Result of the GetHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHubConfigurationResponse getHubConfiguration(GetHubConfigurationRequest getHubConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a hub configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHubConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetHubConfigurationRequest#builder()}
     * </p>
     *
     * @param getHubConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetHubConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHubConfigurationResponse getHubConfiguration(
            Consumer<GetHubConfigurationRequest.Builder> getHubConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getHubConfiguration(GetHubConfigurationRequest.builder().applyMutation(getHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Get details of a managed thing including its attributes and capabilities.
     * </p>
     *
     * @param getManagedThingRequest
     * @return Result of the GetManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingResponse getManagedThing(GetManagedThingRequest getManagedThingRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of a managed thing including its attributes and capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingRequest.Builder} avoiding the need
     * to create one manually via {@link GetManagedThingRequest#builder()}
     * </p>
     *
     * @param getManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingRequest.Builder} to
     *        create a request.
     * @return Result of the GetManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingResponse getManagedThing(Consumer<GetManagedThingRequest.Builder> getManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThing(GetManagedThingRequest.builder().applyMutation(getManagedThingRequest).build());
    }

    /**
     * <p>
     * Get the capabilities for a managed thing using the device ID.
     * </p>
     *
     * @param getManagedThingCapabilitiesRequest
     * @return Result of the GetManagedThingCapabilities operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingCapabilities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCapabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingCapabilitiesResponse getManagedThingCapabilities(
            GetManagedThingCapabilitiesRequest getManagedThingCapabilitiesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the capabilities for a managed thing using the device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingCapabilitiesRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedThingCapabilitiesRequest#builder()}
     * </p>
     *
     * @param getManagedThingCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCapabilitiesRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedThingCapabilities operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingCapabilities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCapabilities"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingCapabilitiesResponse getManagedThingCapabilities(
            Consumer<GetManagedThingCapabilitiesRequest.Builder> getManagedThingCapabilitiesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThingCapabilities(GetManagedThingCapabilitiesRequest.builder()
                .applyMutation(getManagedThingCapabilitiesRequest).build());
    }

    /**
     * <p>
     * Retrieves the certificate PEM for a managed IoT thing.
     * </p>
     *
     * @param getManagedThingCertificateRequest
     * @return Result of the GetManagedThingCertificate operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingCertificateResponse getManagedThingCertificate(
            GetManagedThingCertificateRequest getManagedThingCertificateRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the certificate PEM for a managed IoT thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link GetManagedThingCertificateRequest#builder()}
     * </p>
     *
     * @param getManagedThingCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingCertificateRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedThingCertificate operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingCertificate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingCertificateResponse getManagedThingCertificate(
            Consumer<GetManagedThingCertificateRequest.Builder> getManagedThingCertificateRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThingCertificate(GetManagedThingCertificateRequest.builder()
                .applyMutation(getManagedThingCertificateRequest).build());
    }

    /**
     * <p>
     * Get the connectivity status of a managed thing.
     * </p>
     *
     * @param getManagedThingConnectivityDataRequest
     * @return Result of the GetManagedThingConnectivityData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingConnectivityData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingConnectivityData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingConnectivityDataResponse getManagedThingConnectivityData(
            GetManagedThingConnectivityDataRequest getManagedThingConnectivityDataRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the connectivity status of a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingConnectivityDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedThingConnectivityDataRequest#builder()}
     * </p>
     *
     * @param getManagedThingConnectivityDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingConnectivityDataRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedThingConnectivityData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingConnectivityData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingConnectivityData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingConnectivityDataResponse getManagedThingConnectivityData(
            Consumer<GetManagedThingConnectivityDataRequest.Builder> getManagedThingConnectivityDataRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThingConnectivityData(GetManagedThingConnectivityDataRequest.builder()
                .applyMutation(getManagedThingConnectivityDataRequest).build());
    }

    /**
     * <p>
     * Get the metadata information for a managed thing.
     * </p>
     * <note>
     * <p>
     * The <code>managedThing</code> <code>metadata</code> parameter is used for associating attributes with a
     * <code>managedThing</code> that can be used for grouping over-the-air (OTA) tasks. Name value pairs in
     * <code>metadata</code> can be used in the <code>OtaTargetQueryString</code> parameter for the
     * <code>CreateOtaTask</code> API operation.
     * </p>
     * </note>
     *
     * @param getManagedThingMetaDataRequest
     * @return Result of the GetManagedThingMetaData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingMetaData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingMetaData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingMetaDataResponse getManagedThingMetaData(GetManagedThingMetaDataRequest getManagedThingMetaDataRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the metadata information for a managed thing.
     * </p>
     * <note>
     * <p>
     * The <code>managedThing</code> <code>metadata</code> parameter is used for associating attributes with a
     * <code>managedThing</code> that can be used for grouping over-the-air (OTA) tasks. Name value pairs in
     * <code>metadata</code> can be used in the <code>OtaTargetQueryString</code> parameter for the
     * <code>CreateOtaTask</code> API operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingMetaDataRequest.Builder} avoiding
     * the need to create one manually via {@link GetManagedThingMetaDataRequest#builder()}
     * </p>
     *
     * @param getManagedThingMetaDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingMetaDataRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedThingMetaData operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingMetaData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingMetaData"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingMetaDataResponse getManagedThingMetaData(
            Consumer<GetManagedThingMetaDataRequest.Builder> getManagedThingMetaDataRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThingMetaData(GetManagedThingMetaDataRequest.builder().applyMutation(getManagedThingMetaDataRequest)
                .build());
    }

    /**
     * <p>
     * Returns the managed thing state for the given device Id.
     * </p>
     *
     * @param getManagedThingStateRequest
     * @return Result of the GetManagedThingState operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingStateResponse getManagedThingState(GetManagedThingStateRequest getManagedThingStateRequest)
            throws ValidationException, AccessDeniedException, InternalFailureException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the managed thing state for the given device Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedThingStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetManagedThingStateRequest#builder()}
     * </p>
     *
     * @param getManagedThingStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetManagedThingStateRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedThingState operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetManagedThingState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetManagedThingState"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedThingStateResponse getManagedThingState(
            Consumer<GetManagedThingStateRequest.Builder> getManagedThingStateRequest) throws ValidationException,
            AccessDeniedException, InternalFailureException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getManagedThingState(GetManagedThingStateRequest.builder().applyMutation(getManagedThingStateRequest).build());
    }

    /**
     * <p>
     * Get a notification configuration for a specified event type.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a notification configuration for a specified event type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            Consumer<GetNotificationConfigurationRequest.Builder> getNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return getNotificationConfiguration(GetNotificationConfigurationRequest.builder()
                .applyMutation(getNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Get details of the over-the-air (OTA) task by its task id.
     * </p>
     *
     * @param getOtaTaskRequest
     * @return Result of the GetOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOtaTaskResponse getOtaTask(GetOtaTaskRequest getOtaTaskRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of the over-the-air (OTA) task by its task id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetOtaTaskRequest#builder()}
     * </p>
     *
     * @param getOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOtaTaskResponse getOtaTask(Consumer<GetOtaTaskRequest.Builder> getOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return getOtaTask(GetOtaTaskRequest.builder().applyMutation(getOtaTaskRequest).build());
    }

    /**
     * <p>
     * Get a configuraiton for the over-the-air (OTA) task.
     * </p>
     *
     * @param getOtaTaskConfigurationRequest
     * @return Result of the GetOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOtaTaskConfigurationResponse getOtaTaskConfiguration(GetOtaTaskConfigurationRequest getOtaTaskConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a configuraiton for the over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaTaskConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetOtaTaskConfigurationRequest#builder()}
     * </p>
     *
     * @param getOtaTaskConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetOtaTaskConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetOtaTaskConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetOtaTaskConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetOtaTaskConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOtaTaskConfigurationResponse getOtaTaskConfiguration(
            Consumer<GetOtaTaskConfigurationRequest.Builder> getOtaTaskConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return getOtaTaskConfiguration(GetOtaTaskConfigurationRequest.builder().applyMutation(getOtaTaskConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Get a provisioning profile by template name.
     * </p>
     *
     * @param getProvisioningProfileRequest
     * @return Result of the GetProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetProvisioningProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisioningProfileResponse getProvisioningProfile(GetProvisioningProfileRequest getProvisioningProfileRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a provisioning profile by template name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisioningProfileRequest.Builder} avoiding the
     * need to create one manually via {@link GetProvisioningProfileRequest#builder()}
     * </p>
     *
     * @param getProvisioningProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetProvisioningProfileRequest.Builder}
     *        to create a request.
     * @return Result of the GetProvisioningProfile operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetProvisioningProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetProvisioningProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProvisioningProfileResponse getProvisioningProfile(
            Consumer<GetProvisioningProfileRequest.Builder> getProvisioningProfileRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getProvisioningProfile(GetProvisioningProfileRequest.builder().applyMutation(getProvisioningProfileRequest)
                .build());
    }

    /**
     * <p>
     * Get the runtime log configuration for a specific managed thing.
     * </p>
     *
     * @param getRuntimeLogConfigurationRequest
     * @return Result of the GetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRuntimeLogConfigurationResponse getRuntimeLogConfiguration(
            GetRuntimeLogConfigurationRequest getRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the runtime log configuration for a specific managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuntimeLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param getRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRuntimeLogConfigurationResponse getRuntimeLogConfiguration(
            Consumer<GetRuntimeLogConfigurationRequest.Builder> getRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return getRuntimeLogConfiguration(GetRuntimeLogConfigurationRequest.builder()
                .applyMutation(getRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a schema version with the provided information.
     * </p>
     *
     * @param getSchemaVersionRequest
     * @return Result of the GetSchemaVersion operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaVersionResponse getSchemaVersion(GetSchemaVersionRequest getSchemaVersionRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a schema version with the provided information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaVersionRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.GetSchemaVersionRequest.Builder} to
     *        create a request.
     * @return Result of the GetSchemaVersion operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/GetSchemaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaVersionResponse getSchemaVersion(Consumer<GetSchemaVersionRequest.Builder> getSchemaVersionRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return getSchemaVersion(GetSchemaVersionRequest.builder().applyMutation(getSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Lists all account associations, with optional filtering by connector destination ID.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsResponse listAccountAssociations(ListAccountAssociationsRequest listAccountAssociationsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account associations, with optional filtering by connector destination ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsResponse listAccountAssociations(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listAccountAssociations(ListAccountAssociationsRequest.builder().applyMutation(listAccountAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client
     *             .listAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsIterable listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListAccountAssociationsIterable(this, listAccountAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client
     *             .listAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsIterable listAccountAssociationsPaginator(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listAccountAssociationsPaginator(ListAccountAssociationsRequest.builder()
                .applyMutation(listAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of connectors filtered by its Lambda Amazon Resource Name (ARN) and <code>type</code>.
     * </p>
     *
     * @param listCloudConnectorsRequest
     * @return Result of the ListCloudConnectors operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsResponse listCloudConnectors(ListCloudConnectorsRequest listCloudConnectorsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of connectors filtered by its Lambda Amazon Resource Name (ARN) and <code>type</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudConnectorsRequest#builder()}
     * </p>
     *
     * @param listCloudConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCloudConnectors operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsResponse listCloudConnectors(
            Consumer<ListCloudConnectorsRequest.Builder> listCloudConnectorsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listCloudConnectors(ListCloudConnectorsRequest.builder().applyMutation(listCloudConnectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client.listCloudConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client
     *             .listCloudConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client.listCloudConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudConnectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsIterable listCloudConnectorsPaginator(ListCloudConnectorsRequest listCloudConnectorsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return new ListCloudConnectorsIterable(this, listCloudConnectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client.listCloudConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client
     *             .listCloudConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCloudConnectorsIterable responses = client.listCloudConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudConnectors(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudConnectorsRequest#builder()}
     * </p>
     *
     * @param listCloudConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCloudConnectorsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCloudConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCloudConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudConnectorsIterable listCloudConnectorsPaginator(
            Consumer<ListCloudConnectorsRequest.Builder> listCloudConnectorsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listCloudConnectorsPaginator(ListCloudConnectorsRequest.builder().applyMutation(listCloudConnectorsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all connector destinations, with optional filtering by cloud connector ID.
     * </p>
     *
     * @param listConnectorDestinationsRequest
     * @return Result of the ListConnectorDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsResponse listConnectorDestinations(
            ListConnectorDestinationsRequest listConnectorDestinationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all connector destinations, with optional filtering by cloud connector ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDestinationsRequest#builder()}
     * </p>
     *
     * @param listConnectorDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListConnectorDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsResponse listConnectorDestinations(
            Consumer<ListConnectorDestinationsRequest.Builder> listConnectorDestinationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listConnectorDestinations(ListConnectorDestinationsRequest.builder()
                .applyMutation(listConnectorDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client.listConnectorDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client
     *             .listConnectorDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client.listConnectorDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConnectorDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsIterable listConnectorDestinationsPaginator(
            ListConnectorDestinationsRequest listConnectorDestinationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListConnectorDestinationsIterable(this, listConnectorDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client.listConnectorDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client
     *             .listConnectorDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListConnectorDestinationsIterable responses = client.listConnectorDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectorDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConnectorDestinationsRequest#builder()}
     * </p>
     *
     * @param listConnectorDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListConnectorDestinations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListConnectorDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConnectorDestinationsIterable listConnectorDestinationsPaginator(
            Consumer<ListConnectorDestinationsRequest.Builder> listConnectorDestinationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listConnectorDestinationsPaginator(ListConnectorDestinationsRequest.builder()
                .applyMutation(listConnectorDestinationsRequest).build());
    }

    /**
     * <p>
     * List information on an existing credential locker.
     * </p>
     *
     * @param listCredentialLockersRequest
     * @return Result of the ListCredentialLockers operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersResponse listCredentialLockers(ListCredentialLockersRequest listCredentialLockersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List information on an existing credential locker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCredentialLockersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCredentialLockersRequest#builder()}
     * </p>
     *
     * @param listCredentialLockersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest.Builder}
     *        to create a request.
     * @return Result of the ListCredentialLockers operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersResponse listCredentialLockers(
            Consumer<ListCredentialLockersRequest.Builder> listCredentialLockersRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listCredentialLockers(ListCredentialLockersRequest.builder().applyMutation(listCredentialLockersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client.listCredentialLockersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client
     *             .listCredentialLockersPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client.listCredentialLockersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCredentialLockersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersIterable listCredentialLockersPaginator(ListCredentialLockersRequest listCredentialLockersRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return new ListCredentialLockersIterable(this, listCredentialLockersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client.listCredentialLockersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client
     *             .listCredentialLockersPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListCredentialLockersIterable responses = client.listCredentialLockersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCredentialLockers(software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCredentialLockersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCredentialLockersRequest#builder()}
     * </p>
     *
     * @param listCredentialLockersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListCredentialLockersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListCredentialLockers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListCredentialLockers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCredentialLockersIterable listCredentialLockersPaginator(
            Consumer<ListCredentialLockersRequest.Builder> listCredentialLockersRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listCredentialLockersPaginator(ListCredentialLockersRequest.builder().applyMutation(listCredentialLockersRequest)
                .build());
    }

    /**
     * <p>
     * List all notification destinations.
     * </p>
     *
     * @param listDestinationsRequest
     * @return Result of the ListDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(ListDestinationsRequest listDestinationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all notification destinations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDestinations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsResponse listDestinations(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return new ListDestinationsIterable(this, listDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client
     *             .listDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDestinationsIterable responses = client.listDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDestinationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsIterable listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists all device discovery tasks, with optional filtering by type and status.
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     * @return Result of the ListDeviceDiscoveries operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesResponse listDeviceDiscoveries(ListDeviceDiscoveriesRequest listDeviceDiscoveriesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all device discovery tasks, with optional filtering by type and status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDiscoveriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDiscoveriesRequest#builder()}
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest.Builder}
     *        to create a request.
     * @return Result of the ListDeviceDiscoveries operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesResponse listDeviceDiscoveries(
            Consumer<ListDeviceDiscoveriesRequest.Builder> listDeviceDiscoveriesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listDeviceDiscoveries(ListDeviceDiscoveriesRequest.builder().applyMutation(listDeviceDiscoveriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client.listDeviceDiscoveriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client
     *             .listDeviceDiscoveriesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client.listDeviceDiscoveriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesIterable listDeviceDiscoveriesPaginator(ListDeviceDiscoveriesRequest listDeviceDiscoveriesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListDeviceDiscoveriesIterable(this, listDeviceDiscoveriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client.listDeviceDiscoveriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client
     *             .listDeviceDiscoveriesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDeviceDiscoveriesIterable responses = client.listDeviceDiscoveriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceDiscoveries(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceDiscoveriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceDiscoveriesRequest#builder()}
     * </p>
     *
     * @param listDeviceDiscoveriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDeviceDiscoveriesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDeviceDiscoveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDeviceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceDiscoveriesIterable listDeviceDiscoveriesPaginator(
            Consumer<ListDeviceDiscoveriesRequest.Builder> listDeviceDiscoveriesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listDeviceDiscoveriesPaginator(ListDeviceDiscoveriesRequest.builder().applyMutation(listDeviceDiscoveriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all devices discovered during a specific device discovery task.
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     * @return Result of the ListDiscoveredDevices operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesResponse listDiscoveredDevices(ListDiscoveredDevicesRequest listDiscoveredDevicesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all devices discovered during a specific device discovery task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDiscoveredDevicesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest.Builder}
     *        to create a request.
     * @return Result of the ListDiscoveredDevices operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesResponse listDiscoveredDevices(
            Consumer<ListDiscoveredDevicesRequest.Builder> listDiscoveredDevicesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listDiscoveredDevices(ListDiscoveredDevicesRequest.builder().applyMutation(listDiscoveredDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client.listDiscoveredDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client
     *             .listDiscoveredDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client.listDiscoveredDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesIterable listDiscoveredDevicesPaginator(ListDiscoveredDevicesRequest listDiscoveredDevicesRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListDiscoveredDevicesIterable(this, listDiscoveredDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client.listDiscoveredDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client
     *             .listDiscoveredDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListDiscoveredDevicesIterable responses = client.listDiscoveredDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredDevices(software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredDevicesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDiscoveredDevicesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListDiscoveredDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListDiscoveredDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredDevicesIterable listDiscoveredDevicesPaginator(
            Consumer<ListDiscoveredDevicesRequest.Builder> listDiscoveredDevicesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listDiscoveredDevicesPaginator(ListDiscoveredDevicesRequest.builder().applyMutation(listDiscoveredDevicesRequest)
                .build());
    }

    /**
     * <p>
     * List all event log configurations for an account.
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     * @return Result of the ListEventLogConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsResponse listEventLogConfigurations(
            ListEventLogConfigurationsRequest listEventLogConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all event log configurations for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventLogConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventLogConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEventLogConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsResponse listEventLogConfigurations(
            Consumer<ListEventLogConfigurationsRequest.Builder> listEventLogConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listEventLogConfigurations(ListEventLogConfigurationsRequest.builder()
                .applyMutation(listEventLogConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client.listEventLogConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client
     *             .listEventLogConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client.listEventLogConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsIterable listEventLogConfigurationsPaginator(
            ListEventLogConfigurationsRequest listEventLogConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListEventLogConfigurationsIterable(this, listEventLogConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client.listEventLogConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client
     *             .listEventLogConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListEventLogConfigurationsIterable responses = client.listEventLogConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventLogConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventLogConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventLogConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEventLogConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListEventLogConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListEventLogConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventLogConfigurationsIterable listEventLogConfigurationsPaginator(
            Consumer<ListEventLogConfigurationsRequest.Builder> listEventLogConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listEventLogConfigurationsPaginator(ListEventLogConfigurationsRequest.builder()
                .applyMutation(listEventLogConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all account associations for a specific managed thing.
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     * @return Result of the ListManagedThingAccountAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsResponse listManagedThingAccountAssociations(
            ListManagedThingAccountAssociationsRequest listManagedThingAccountAssociationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all account associations for a specific managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingAccountAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedThingAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedThingAccountAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsResponse listManagedThingAccountAssociations(
            Consumer<ListManagedThingAccountAssociationsRequest.Builder> listManagedThingAccountAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listManagedThingAccountAssociations(ListManagedThingAccountAssociationsRequest.builder()
                .applyMutation(listManagedThingAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client.listManagedThingAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client
     *             .listManagedThingAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client.listManagedThingAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsIterable listManagedThingAccountAssociationsPaginator(
            ListManagedThingAccountAssociationsRequest listManagedThingAccountAssociationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListManagedThingAccountAssociationsIterable(this, listManagedThingAccountAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client.listManagedThingAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client
     *             .listManagedThingAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingAccountAssociationsIterable responses = client.listManagedThingAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingAccountAssociations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingAccountAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedThingAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedThingAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingAccountAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingAccountAssociationsIterable listManagedThingAccountAssociationsPaginator(
            Consumer<ListManagedThingAccountAssociationsRequest.Builder> listManagedThingAccountAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listManagedThingAccountAssociationsPaginator(ListManagedThingAccountAssociationsRequest.builder()
                .applyMutation(listManagedThingAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * List schemas associated with a managed thing.
     * </p>
     *
     * @param listManagedThingSchemasRequest
     * @return Result of the ListManagedThingSchemas operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasResponse listManagedThingSchemas(ListManagedThingSchemasRequest listManagedThingSchemasRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List schemas associated with a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingSchemasRequest.Builder} avoiding
     * the need to create one manually via {@link ListManagedThingSchemasRequest#builder()}
     * </p>
     *
     * @param listManagedThingSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedThingSchemas operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasResponse listManagedThingSchemas(
            Consumer<ListManagedThingSchemasRequest.Builder> listManagedThingSchemasRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listManagedThingSchemas(ListManagedThingSchemasRequest.builder().applyMutation(listManagedThingSchemasRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client.listManagedThingSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client
     *             .listManagedThingSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client.listManagedThingSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasIterable listManagedThingSchemasPaginator(
            ListManagedThingSchemasRequest listManagedThingSchemasRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return new ListManagedThingSchemasIterable(this, listManagedThingSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client.listManagedThingSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client
     *             .listManagedThingSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingSchemasIterable responses = client.listManagedThingSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThingSchemas(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingSchemasRequest.Builder} avoiding
     * the need to create one manually via {@link ListManagedThingSchemasRequest#builder()}
     * </p>
     *
     * @param listManagedThingSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingSchemasRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThingSchemas
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThingSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingSchemasIterable listManagedThingSchemasPaginator(
            Consumer<ListManagedThingSchemasRequest.Builder> listManagedThingSchemasRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listManagedThingSchemasPaginator(ListManagedThingSchemasRequest.builder()
                .applyMutation(listManagedThingSchemasRequest).build());
    }

    /**
     * <p>
     * Listing all managed things with provision for filters.
     * </p>
     *
     * @param listManagedThingsRequest
     * @return Result of the ListManagedThings operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsResponse listManagedThings(ListManagedThingsRequest listManagedThingsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Listing all managed things with provision for filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedThingsRequest#builder()}
     * </p>
     *
     * @param listManagedThingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest.Builder} to
     *        create a request.
     * @return Result of the ListManagedThings operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsResponse listManagedThings(Consumer<ListManagedThingsRequest.Builder> listManagedThingsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listManagedThings(ListManagedThingsRequest.builder().applyMutation(listManagedThingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client.listManagedThingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client
     *             .listManagedThingsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client.listManagedThingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedThingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsIterable listManagedThingsPaginator(ListManagedThingsRequest listManagedThingsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListManagedThingsIterable(this, listManagedThingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client.listManagedThingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client
     *             .listManagedThingsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListManagedThingsIterable responses = client.listManagedThingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedThings(software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedThingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListManagedThingsRequest#builder()}
     * </p>
     *
     * @param listManagedThingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListManagedThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListManagedThings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedThingsIterable listManagedThingsPaginator(
            Consumer<ListManagedThingsRequest.Builder> listManagedThingsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listManagedThingsPaginator(ListManagedThingsRequest.builder().applyMutation(listManagedThingsRequest).build());
    }

    /**
     * <p>
     * List all notification configurations.
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return Result of the ListNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsResponse listNotificationConfigurations(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all notification configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsResponse listNotificationConfigurations(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listNotificationConfigurations(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client
     *             .listNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsIterable listNotificationConfigurationsPaginator(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListNotificationConfigurationsIterable(this, listNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client
     *             .listNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsIterable listNotificationConfigurationsPaginator(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listNotificationConfigurationsPaginator(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task configurations.
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     * @return Result of the ListOtaTaskConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsResponse listOtaTaskConfigurations(
            ListOtaTaskConfigurationsRequest listOtaTaskConfigurationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOtaTaskConfigurationsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListOtaTaskConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsResponse listOtaTaskConfigurations(
            Consumer<ListOtaTaskConfigurationsRequest.Builder> listOtaTaskConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listOtaTaskConfigurations(ListOtaTaskConfigurationsRequest.builder()
                .applyMutation(listOtaTaskConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client.listOtaTaskConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client
     *             .listOtaTaskConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client.listOtaTaskConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsIterable listOtaTaskConfigurationsPaginator(
            ListOtaTaskConfigurationsRequest listOtaTaskConfigurationsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListOtaTaskConfigurationsIterable(this, listOtaTaskConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client.listOtaTaskConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client
     *             .listOtaTaskConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskConfigurationsIterable responses = client.listOtaTaskConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskConfigurations(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOtaTaskConfigurationsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskConfigurationsIterable listOtaTaskConfigurationsPaginator(
            Consumer<ListOtaTaskConfigurationsRequest.Builder> listOtaTaskConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listOtaTaskConfigurationsPaginator(ListOtaTaskConfigurationsRequest.builder()
                .applyMutation(listOtaTaskConfigurationsRequest).build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task executions.
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     * @return Result of the ListOtaTaskExecutions operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsResponse listOtaTaskExecutions(ListOtaTaskExecutionsRequest listOtaTaskExecutionsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) task executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOtaTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListOtaTaskExecutions operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsResponse listOtaTaskExecutions(
            Consumer<ListOtaTaskExecutionsRequest.Builder> listOtaTaskExecutionsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listOtaTaskExecutions(ListOtaTaskExecutionsRequest.builder().applyMutation(listOtaTaskExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client.listOtaTaskExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client
     *             .listOtaTaskExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client.listOtaTaskExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsIterable listOtaTaskExecutionsPaginator(ListOtaTaskExecutionsRequest listOtaTaskExecutionsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return new ListOtaTaskExecutionsIterable(this, listOtaTaskExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client.listOtaTaskExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client
     *             .listOtaTaskExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTaskExecutionsIterable responses = client.listOtaTaskExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTaskExecutions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTaskExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListOtaTaskExecutionsRequest#builder()}
     * </p>
     *
     * @param listOtaTaskExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTaskExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTaskExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTaskExecutionsIterable listOtaTaskExecutionsPaginator(
            Consumer<ListOtaTaskExecutionsRequest.Builder> listOtaTaskExecutionsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return listOtaTaskExecutionsPaginator(ListOtaTaskExecutionsRequest.builder().applyMutation(listOtaTaskExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) tasks.
     * </p>
     *
     * @param listOtaTasksRequest
     * @return Result of the ListOtaTasks operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksResponse listOtaTasks(ListOtaTasksRequest listOtaTasksRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the over-the-air (OTA) tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListOtaTasksRequest#builder()}
     * </p>
     *
     * @param listOtaTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest.Builder} to create
     *        a request.
     * @return Result of the ListOtaTasks operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksResponse listOtaTasks(Consumer<ListOtaTasksRequest.Builder> listOtaTasksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listOtaTasks(ListOtaTasksRequest.builder().applyMutation(listOtaTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client.listOtaTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client
     *             .listOtaTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client.listOtaTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOtaTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksIterable listOtaTasksPaginator(ListOtaTasksRequest listOtaTasksRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return new ListOtaTasksIterable(this, listOtaTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client.listOtaTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client
     *             .listOtaTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListOtaTasksIterable responses = client.listOtaTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOtaTasks(software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListOtaTasksRequest#builder()}
     * </p>
     *
     * @param listOtaTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTasksRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListOtaTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListOtaTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOtaTasksIterable listOtaTasksPaginator(Consumer<ListOtaTasksRequest.Builder> listOtaTasksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listOtaTasksPaginator(ListOtaTasksRequest.builder().applyMutation(listOtaTasksRequest).build());
    }

    /**
     * <p>
     * List the provisioning profiles within the Amazon Web Services account.
     * </p>
     *
     * @param listProvisioningProfilesRequest
     * @return Result of the ListProvisioningProfiles operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesResponse listProvisioningProfiles(
            ListProvisioningProfilesRequest listProvisioningProfilesRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the provisioning profiles within the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningProfilesRequest#builder()}
     * </p>
     *
     * @param listProvisioningProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest.Builder}
     *        to create a request.
     * @return Result of the ListProvisioningProfiles operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesResponse listProvisioningProfiles(
            Consumer<ListProvisioningProfilesRequest.Builder> listProvisioningProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listProvisioningProfiles(ListProvisioningProfilesRequest.builder().applyMutation(listProvisioningProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client.listProvisioningProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client
     *             .listProvisioningProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client.listProvisioningProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesIterable listProvisioningProfilesPaginator(
            ListProvisioningProfilesRequest listProvisioningProfilesRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, UnauthorizedException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return new ListProvisioningProfilesIterable(this, listProvisioningProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client.listProvisioningProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client
     *             .listProvisioningProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListProvisioningProfilesIterable responses = client.listProvisioningProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningProfiles(software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningProfilesRequest#builder()}
     * </p>
     *
     * @param listProvisioningProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListProvisioningProfilesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListProvisioningProfiles
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListProvisioningProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisioningProfilesIterable listProvisioningProfilesPaginator(
            Consumer<ListProvisioningProfilesRequest.Builder> listProvisioningProfilesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listProvisioningProfilesPaginator(ListProvisioningProfilesRequest.builder()
                .applyMutation(listProvisioningProfilesRequest).build());
    }

    /**
     * <p>
     * Lists schema versions with the provided information.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists schema versions with the provided information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSchemaVersions operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsResponse listSchemaVersions(Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listSchemaVersions(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(ListSchemaVersionsRequest listSchemaVersionsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return new ListSchemaVersionsIterable(this, listSchemaVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client
     *             .listSchemaVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotmanagedintegrations.paginators.ListSchemaVersionsIterable responses = client.listSchemaVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListSchemaVersionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListSchemaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSchemaVersionsIterable listSchemaVersionsPaginator(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ServiceUnavailableException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return listSchemaVersionsPaginator(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * List tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws UnauthorizedException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws UnauthorizedException,
            InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * AWS IoT SiteWise User Guide.
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalFailureException, UnauthorizedException, ServiceUnavailableException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * AWS IoT SiteWise User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDefaultEncryptionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutDefaultEncryptionConfigurationRequest#builder()}
     * </p>
     *
     * @param putDefaultEncryptionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutDefaultEncryptionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutDefaultEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDefaultEncryptionConfigurationResponse putDefaultEncryptionConfiguration(
            Consumer<PutDefaultEncryptionConfigurationRequest.Builder> putDefaultEncryptionConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalFailureException, UnauthorizedException,
            ServiceUnavailableException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest.builder()
                .applyMutation(putDefaultEncryptionConfigurationRequest).build());
    }

    /**
     * <p>
     * Update a hub configuration.
     * </p>
     *
     * @param putHubConfigurationRequest
     * @return Result of the PutHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutHubConfigurationResponse putHubConfiguration(PutHubConfigurationRequest putHubConfigurationRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a hub configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutHubConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link PutHubConfigurationRequest#builder()}
     * </p>
     *
     * @param putHubConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutHubConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutHubConfiguration operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutHubConfigurationResponse putHubConfiguration(
            Consumer<PutHubConfigurationRequest.Builder> putHubConfigurationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return putHubConfiguration(PutHubConfigurationRequest.builder().applyMutation(putHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Set the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     *
     * @param putRuntimeLogConfigurationRequest
     * @return Result of the PutRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRuntimeLogConfigurationResponse putRuntimeLogConfiguration(
            PutRuntimeLogConfigurationRequest putRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the runtime log configuration for a specific managed thing or for all managed things as a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuntimeLogConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param putRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.PutRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the PutRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.PutRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/PutRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRuntimeLogConfigurationResponse putRuntimeLogConfiguration(
            Consumer<PutRuntimeLogConfigurationRequest.Builder> putRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return putRuntimeLogConfiguration(PutRuntimeLogConfigurationRequest.builder()
                .applyMutation(putRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Registers an account association with a managed thing, establishing a connection between a device and a
     * third-party account.
     * </p>
     *
     * @param registerAccountAssociationRequest
     * @return Result of the RegisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterAccountAssociationResponse registerAccountAssociation(
            RegisterAccountAssociationRequest registerAccountAssociationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an account association with a managed thing, establishing a connection between a device and a
     * third-party account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterAccountAssociationRequest#builder()}
     * </p>
     *
     * @param registerAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterAccountAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the RegisterAccountAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterAccountAssociationResponse registerAccountAssociation(
            Consumer<RegisterAccountAssociationRequest.Builder> registerAccountAssociationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ConflictException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return registerAccountAssociation(RegisterAccountAssociationRequest.builder()
                .applyMutation(registerAccountAssociationRequest).build());
    }

    /**
     * <p>
     * Customers can request IoT managed integrations to manage the server trust for them or bring their own external
     * server trusts for the custom domain. Returns an IoT managed integrations endpoint.
     * </p>
     *
     * @param registerCustomEndpointRequest
     * @return Result of the RegisterCustomEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterCustomEndpointResponse registerCustomEndpoint(RegisterCustomEndpointRequest registerCustomEndpointRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Customers can request IoT managed integrations to manage the server trust for them or bring their own external
     * server trusts for the custom domain. Returns an IoT managed integrations endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCustomEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterCustomEndpointRequest#builder()}
     * </p>
     *
     * @param registerCustomEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.RegisterCustomEndpointRequest.Builder}
     *        to create a request.
     * @return Result of the RegisterCustomEndpoint operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.RegisterCustomEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/RegisterCustomEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterCustomEndpointResponse registerCustomEndpoint(
            Consumer<RegisterCustomEndpointRequest.Builder> registerCustomEndpointRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ServiceUnavailableException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return registerCustomEndpoint(RegisterCustomEndpointRequest.builder().applyMutation(registerCustomEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Reset a runtime log configuration for a specific managed thing.
     * </p>
     *
     * @param resetRuntimeLogConfigurationRequest
     * @return Result of the ResetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ResetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ResetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetRuntimeLogConfigurationResponse resetRuntimeLogConfiguration(
            ResetRuntimeLogConfigurationRequest resetRuntimeLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reset a runtime log configuration for a specific managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetRuntimeLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ResetRuntimeLogConfigurationRequest#builder()}
     * </p>
     *
     * @param resetRuntimeLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.ResetRuntimeLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the ResetRuntimeLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.ResetRuntimeLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/ResetRuntimeLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetRuntimeLogConfigurationResponse resetRuntimeLogConfiguration(
            Consumer<ResetRuntimeLogConfigurationRequest.Builder> resetRuntimeLogConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return resetRuntimeLogConfiguration(ResetRuntimeLogConfigurationRequest.builder()
                .applyMutation(resetRuntimeLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Relays third-party device events for a connector such as a new device or a device state change event.
     * </p>
     *
     * @param sendConnectorEventRequest
     * @return Result of the SendConnectorEvent operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendConnectorEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendConnectorEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendConnectorEventResponse sendConnectorEvent(SendConnectorEventRequest sendConnectorEventRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Relays third-party device events for a connector such as a new device or a device state change event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendConnectorEventRequest.Builder} avoiding the
     * need to create one manually via {@link SendConnectorEventRequest#builder()}
     * </p>
     *
     * @param sendConnectorEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.SendConnectorEventRequest.Builder} to
     *        create a request.
     * @return Result of the SendConnectorEvent operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendConnectorEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendConnectorEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default SendConnectorEventResponse sendConnectorEvent(Consumer<SendConnectorEventRequest.Builder> sendConnectorEventRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return sendConnectorEvent(SendConnectorEventRequest.builder().applyMutation(sendConnectorEventRequest).build());
    }

    /**
     * <p>
     * Send the command to the device represented by the managed thing.
     * </p>
     *
     * @param sendManagedThingCommandRequest
     * @return Result of the SendManagedThingCommand operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendManagedThingCommand
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendManagedThingCommand"
     *      target="_top">AWS API Documentation</a>
     */
    default SendManagedThingCommandResponse sendManagedThingCommand(SendManagedThingCommandRequest sendManagedThingCommandRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Send the command to the device represented by the managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendManagedThingCommandRequest.Builder} avoiding
     * the need to create one manually via {@link SendManagedThingCommandRequest#builder()}
     * </p>
     *
     * @param sendManagedThingCommandRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.SendManagedThingCommandRequest.Builder}
     *        to create a request.
     * @return Result of the SendManagedThingCommand operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.SendManagedThingCommand
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/SendManagedThingCommand"
     *      target="_top">AWS API Documentation</a>
     */
    default SendManagedThingCommandResponse sendManagedThingCommand(
            Consumer<SendManagedThingCommandRequest.Builder> sendManagedThingCommandRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, UnauthorizedException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return sendManagedThingCommand(SendManagedThingCommandRequest.builder().applyMutation(sendManagedThingCommandRequest)
                .build());
    }

    /**
     * <p>
     * Initiates a refresh of an existing account association to update its authorization and connection status.
     * </p>
     *
     * @param startAccountAssociationRefreshRequest
     * @return Result of the StartAccountAssociationRefresh operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartAccountAssociationRefresh
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartAccountAssociationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAccountAssociationRefreshResponse startAccountAssociationRefresh(
            StartAccountAssociationRefreshRequest startAccountAssociationRefreshRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a refresh of an existing account association to update its authorization and connection status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAccountAssociationRefreshRequest.Builder}
     * avoiding the need to create one manually via {@link StartAccountAssociationRefreshRequest#builder()}
     * </p>
     *
     * @param startAccountAssociationRefreshRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StartAccountAssociationRefreshRequest.Builder}
     *        to create a request.
     * @return Result of the StartAccountAssociationRefresh operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartAccountAssociationRefresh
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartAccountAssociationRefresh"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAccountAssociationRefreshResponse startAccountAssociationRefresh(
            Consumer<StartAccountAssociationRefreshRequest.Builder> startAccountAssociationRefreshRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return startAccountAssociationRefresh(StartAccountAssociationRefreshRequest.builder()
                .applyMutation(startAccountAssociationRefreshRequest).build());
    }

    /**
     * <p>
     * This API is used to start device discovery for hub-connected and third-party-connected devices. The
     * authentication material (install code) is delivered as a message to the controller instructing it to start the
     * discovery.
     * </p>
     *
     * @param startDeviceDiscoveryRequest
     * @return Result of the StartDeviceDiscovery operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceDiscoveryResponse startDeviceDiscovery(StartDeviceDiscoveryRequest startDeviceDiscoveryRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used to start device discovery for hub-connected and third-party-connected devices. The
     * authentication material (install code) is delivered as a message to the controller instructing it to start the
     * discovery.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeviceDiscoveryRequest.Builder} avoiding the
     * need to create one manually via {@link StartDeviceDiscoveryRequest#builder()}
     * </p>
     *
     * @param startDeviceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StartDeviceDiscoveryRequest.Builder}
     *        to create a request.
     * @return Result of the StartDeviceDiscovery operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.StartDeviceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/StartDeviceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceDiscoveryResponse startDeviceDiscovery(
            Consumer<StartDeviceDiscoveryRequest.Builder> startDeviceDiscoveryRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ConflictException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return startDeviceDiscovery(StartDeviceDiscoveryRequest.builder().applyMutation(startDeviceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Add tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws UnauthorizedException,
            ConflictException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.TagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws UnauthorizedException, ConflictException, InvalidRequestException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags for the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws UnauthorizedException,
            ConflictException, InvalidRequestException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws UnauthorizedException, ConflictException, InvalidRequestException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an existing account association.
     * </p>
     *
     * @param updateAccountAssociationRequest
     * @return Result of the UpdateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountAssociationResponse updateAccountAssociation(
            UpdateAccountAssociationRequest updateAccountAssociationRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, ConflictException, ServiceUnavailableException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an existing account association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountAssociationRequest#builder()}
     * </p>
     *
     * @param updateAccountAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateAccountAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateAccountAssociation operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateAccountAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateAccountAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountAssociationResponse updateAccountAssociation(
            Consumer<UpdateAccountAssociationRequest.Builder> updateAccountAssociationRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, ConflictException, ServiceUnavailableException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return updateAccountAssociation(UpdateAccountAssociationRequest.builder().applyMutation(updateAccountAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Update an existing cloud connector.
     * </p>
     *
     * @param updateCloudConnectorRequest
     * @return Result of the UpdateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudConnectorResponse updateCloudConnector(UpdateCloudConnectorRequest updateCloudConnectorRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing cloud connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCloudConnectorRequest#builder()}
     * </p>
     *
     * @param updateCloudConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateCloudConnectorRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateCloudConnector operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateCloudConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateCloudConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudConnectorResponse updateCloudConnector(
            Consumer<UpdateCloudConnectorRequest.Builder> updateCloudConnectorRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return updateCloudConnector(UpdateCloudConnectorRequest.builder().applyMutation(updateCloudConnectorRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an existing connector destination.
     * </p>
     *
     * @param updateConnectorDestinationRequest
     * @return Result of the UpdateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorDestinationResponse updateConnectorDestination(
            UpdateConnectorDestinationRequest updateConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an existing connector destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConnectorDestinationRequest#builder()}
     * </p>
     *
     * @param updateConnectorDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateConnectorDestinationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateConnectorDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateConnectorDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateConnectorDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConnectorDestinationResponse updateConnectorDestination(
            Consumer<UpdateConnectorDestinationRequest.Builder> updateConnectorDestinationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        return updateConnectorDestination(UpdateConnectorDestinationRequest.builder()
                .applyMutation(updateConnectorDestinationRequest).build());
    }

    /**
     * <p>
     * Update a destination specified by name.
     * </p>
     *
     * @param updateDestinationRequest
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a destination specified by name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDestination operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDestinationResponse updateDestination(Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Update an event log configuration by log configuration ID.
     * </p>
     *
     * @param updateEventLogConfigurationRequest
     * @return Result of the UpdateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventLogConfigurationResponse updateEventLogConfiguration(
            UpdateEventLogConfigurationRequest updateEventLogConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an event log configuration by log configuration ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventLogConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEventLogConfigurationRequest#builder()}
     * </p>
     *
     * @param updateEventLogConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateEventLogConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateEventLogConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateEventLogConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateEventLogConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventLogConfigurationResponse updateEventLogConfiguration(
            Consumer<UpdateEventLogConfigurationRequest.Builder> updateEventLogConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return updateEventLogConfiguration(UpdateEventLogConfigurationRequest.builder()
                .applyMutation(updateEventLogConfigurationRequest).build());
    }

    /**
     * <p>
     * Update the attributes and capabilities associated with a managed thing.
     * </p>
     *
     * @param updateManagedThingRequest
     * @return Result of the UpdateManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateManagedThingResponse updateManagedThing(UpdateManagedThingRequest updateManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the attributes and capabilities associated with a managed thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateManagedThingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateManagedThingRequest#builder()}
     * </p>
     *
     * @param updateManagedThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateManagedThingRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateManagedThing operation returned by the service.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictException
     *         There is a conflict with the request.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateManagedThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateManagedThing"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateManagedThingResponse updateManagedThing(Consumer<UpdateManagedThingRequest.Builder> updateManagedThingRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, UnauthorizedException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotManagedIntegrationsException {
        return updateManagedThing(UpdateManagedThingRequest.builder().applyMutation(updateManagedThingRequest).build());
    }

    /**
     * <p>
     * Update a notification configuration.
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     * @return Result of the UpdateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotificationConfigurationResponse updateNotificationConfiguration(
            UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a notification configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotificationConfigurationResponse updateNotificationConfiguration(
            Consumer<UpdateNotificationConfigurationRequest.Builder> updateNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return updateNotificationConfiguration(UpdateNotificationConfigurationRequest.builder()
                .applyMutation(updateNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Update an over-the-air (OTA) task.
     * </p>
     *
     * @param updateOtaTaskRequest
     * @return Result of the UpdateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOtaTaskResponse updateOtaTask(UpdateOtaTaskRequest updateOtaTaskRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, IotManagedIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an over-the-air (OTA) task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOtaTaskRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateOtaTaskRequest#builder()}
     * </p>
     *
     * @param updateOtaTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.UpdateOtaTaskRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOtaTask operation returned by the service.
     * @throws AccessDeniedException
     *         User is not authorized.
     * @throws ValidationException
     *         A validation error occurred when performing the API request.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotManagedIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotManagedIntegrationsClient.UpdateOtaTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/UpdateOtaTask"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOtaTaskResponse updateOtaTask(Consumer<UpdateOtaTaskRequest.Builder> updateOtaTaskRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, IotManagedIntegrationsException {
        return updateOtaTask(UpdateOtaTaskRequest.builder().applyMutation(updateOtaTaskRequest).build());
    }

    /**
     * Create a {@link IotManagedIntegrationsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotManagedIntegrationsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotManagedIntegrationsClient}.
     */
    static IotManagedIntegrationsClientBuilder builder() {
        return new DefaultIotManagedIntegrationsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IotManagedIntegrationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
