/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Action for an Amazon Web Services capability, containing the action parameters for control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityAction.Builder, CapabilityAction> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CapabilityAction::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REF_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ref")
            .getter(getter(CapabilityAction::ref)).setter(setter(Builder::ref))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ref").build()).build();

    private static final SdkField<String> ACTION_TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionTraceId").getter(getter(CapabilityAction::actionTraceId)).setter(setter(Builder::actionTraceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTraceId").build()).build();

    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("parameters").getter(getter(CapabilityAction::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REF_FIELD,
            ACTION_TRACE_ID_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String ref;

    private final String actionTraceId;

    private final Document parameters;

    private CapabilityAction(BuilderImpl builder) {
        this.name = builder.name;
        this.ref = builder.ref;
        this.actionTraceId = builder.actionTraceId;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * Describe a capability action with a name.
     * </p>
     * 
     * @return Describe a capability action with a name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describe a capability action with an reference.
     * </p>
     * 
     * @return Describe a capability action with an reference.
     */
    public final String ref() {
        return ref;
    }

    /**
     * <p>
     * Describe a capability action with an <code>actionTraceId</code> for a response command.
     * </p>
     * 
     * @return Describe a capability action with an <code>actionTraceId</code> for a response command.
     */
    public final String actionTraceId() {
        return actionTraceId;
    }

    /**
     * <p>
     * Describe a capability action with a capability property.
     * </p>
     * 
     * @return Describe a capability action with a capability property.
     */
    public final Document parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ref());
        hashCode = 31 * hashCode + Objects.hashCode(actionTraceId());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityAction)) {
            return false;
        }
        CapabilityAction other = (CapabilityAction) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ref(), other.ref())
                && Objects.equals(actionTraceId(), other.actionTraceId()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityAction").add("Name", name()).add("Ref", ref()).add("ActionTraceId", actionTraceId())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ref":
            return Optional.ofNullable(clazz.cast(ref()));
        case "actionTraceId":
            return Optional.ofNullable(clazz.cast(actionTraceId()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("ref", REF_FIELD);
        map.put("actionTraceId", ACTION_TRACE_ID_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityAction, T> g) {
        return obj -> g.apply((CapabilityAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityAction> {
        /**
         * <p>
         * Describe a capability action with a name.
         * </p>
         * 
         * @param name
         *        Describe a capability action with a name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describe a capability action with an reference.
         * </p>
         * 
         * @param ref
         *        Describe a capability action with an reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ref(String ref);

        /**
         * <p>
         * Describe a capability action with an <code>actionTraceId</code> for a response command.
         * </p>
         * 
         * @param actionTraceId
         *        Describe a capability action with an <code>actionTraceId</code> for a response command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTraceId(String actionTraceId);

        /**
         * <p>
         * Describe a capability action with a capability property.
         * </p>
         * 
         * @param parameters
         *        Describe a capability action with a capability property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Document parameters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String ref;

        private String actionTraceId;

        private Document parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityAction model) {
            name(model.name);
            ref(model.ref);
            actionTraceId(model.actionTraceId);
            parameters(model.parameters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRef() {
            return ref;
        }

        public final void setRef(String ref) {
            this.ref = ref;
        }

        @Override
        public final Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public final String getActionTraceId() {
            return actionTraceId;
        }

        public final void setActionTraceId(String actionTraceId) {
            this.actionTraceId = actionTraceId;
        }

        @Override
        public final Builder actionTraceId(String actionTraceId) {
            this.actionTraceId = actionTraceId;
            return this;
        }

        public final Document getParameters() {
            return parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public CapabilityAction build() {
            return new CapabilityAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
