/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountAssociationResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<CreateAccountAssociationResponse.Builder, CreateAccountAssociationResponse> {
    private static final SdkField<String> O_AUTH_AUTHORIZATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuthAuthorizationUrl").getter(getter(CreateAccountAssociationResponse::oAuthAuthorizationUrl))
            .setter(setter(Builder::oAuthAuthorizationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthAuthorizationUrl").build())
            .build();

    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(CreateAccountAssociationResponse::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationState").getter(getter(CreateAccountAssociationResponse::associationStateAsString))
            .setter(setter(Builder::associationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateAccountAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            O_AUTH_AUTHORIZATION_URL_FIELD, ACCOUNT_ASSOCIATION_ID_FIELD, ASSOCIATION_STATE_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String oAuthAuthorizationUrl;

    private final String accountAssociationId;

    private final String associationState;

    private final String arn;

    private CreateAccountAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.oAuthAuthorizationUrl = builder.oAuthAuthorizationUrl;
        this.accountAssociationId = builder.accountAssociationId;
        this.associationState = builder.associationState;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * Third-party IoT platform OAuth authorization server URL backed with all the required parameters to perform
     * end-user authentication.
     * </p>
     * 
     * @return Third-party IoT platform OAuth authorization server URL backed with all the required parameters to
     *         perform end-user authentication.
     */
    public final String oAuthAuthorizationUrl() {
        return oAuthAuthorizationUrl;
    }

    /**
     * <p>
     * The identifier for the account association request.
     * </p>
     * 
     * @return The identifier for the account association request.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The current state of the account association request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The current state of the account association request.
     * @see AssociationState
     */
    public final AssociationState associationState() {
        return AssociationState.fromValue(associationState);
    }

    /**
     * <p>
     * The current state of the account association request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The current state of the account association request.
     * @see AssociationState
     */
    public final String associationStateAsString() {
        return associationState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account association.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(oAuthAuthorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountAssociationResponse)) {
            return false;
        }
        CreateAccountAssociationResponse other = (CreateAccountAssociationResponse) obj;
        return Objects.equals(oAuthAuthorizationUrl(), other.oAuthAuthorizationUrl())
                && Objects.equals(accountAssociationId(), other.accountAssociationId())
                && Objects.equals(associationStateAsString(), other.associationStateAsString())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccountAssociationResponse")
                .add("OAuthAuthorizationUrl", oAuthAuthorizationUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccountAssociationId", accountAssociationId()).add("AssociationState", associationStateAsString())
                .add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OAuthAuthorizationUrl":
            return Optional.ofNullable(clazz.cast(oAuthAuthorizationUrl()));
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "AssociationState":
            return Optional.ofNullable(clazz.cast(associationStateAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OAuthAuthorizationUrl", O_AUTH_AUTHORIZATION_URL_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountAssociationResponse, T> g) {
        return obj -> g.apply((CreateAccountAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccountAssociationResponse> {
        /**
         * <p>
         * Third-party IoT platform OAuth authorization server URL backed with all the required parameters to perform
         * end-user authentication.
         * </p>
         * 
         * @param oAuthAuthorizationUrl
         *        Third-party IoT platform OAuth authorization server URL backed with all the required parameters to
         *        perform end-user authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl);

        /**
         * <p>
         * The identifier for the account association request.
         * </p>
         * 
         * @param accountAssociationId
         *        The identifier for the account association request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The current state of the account association request.
         * </p>
         * 
         * @param associationState
         *        The current state of the account association request.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder associationState(String associationState);

        /**
         * <p>
         * The current state of the account association request.
         * </p>
         * 
         * @param associationState
         *        The current state of the account association request.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder associationState(AssociationState associationState);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String oAuthAuthorizationUrl;

        private String accountAssociationId;

        private String associationState;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountAssociationResponse model) {
            super(model);
            oAuthAuthorizationUrl(model.oAuthAuthorizationUrl);
            accountAssociationId(model.accountAssociationId);
            associationState(model.associationState);
            arn(model.arn);
        }

        public final String getOAuthAuthorizationUrl() {
            return oAuthAuthorizationUrl;
        }

        public final void setOAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
        }

        @Override
        public final Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
            return this;
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAssociationState() {
            return associationState;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(AssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public CreateAccountAssociationResponse build() {
            return new CreateAccountAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
