/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing summary information about a device discovered during a device discovery job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoveredDeviceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DiscoveredDeviceSummary.Builder, DiscoveredDeviceSummary> {
    private static final SdkField<String> CONNECTOR_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceId").getter(getter(DiscoveredDeviceSummary::connectorDeviceId))
            .setter(setter(Builder::connectorDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceId").build()).build();

    private static final SdkField<String> CONNECTOR_DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDeviceName").getter(getter(DiscoveredDeviceSummary::connectorDeviceName))
            .setter(setter(Builder::connectorDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDeviceName").build())
            .build();

    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceTypes")
            .getter(getter(DiscoveredDeviceSummary::deviceTypes))
            .setter(setter(Builder::deviceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(DiscoveredDeviceSummary::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final SdkField<String> MODIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Modification").getter(getter(DiscoveredDeviceSummary::modificationAsString))
            .setter(setter(Builder::modification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Modification").build()).build();

    private static final SdkField<Instant> DISCOVERED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DiscoveredAt").getter(getter(DiscoveredDeviceSummary::discoveredAt))
            .setter(setter(Builder::discoveredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveredAt").build()).build();

    private static final SdkField<String> BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Brand")
            .getter(getter(DiscoveredDeviceSummary::brand)).setter(setter(Builder::brand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(DiscoveredDeviceSummary::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> AUTHENTICATION_MATERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMaterial").getter(getter(DiscoveredDeviceSummary::authenticationMaterial))
            .setter(setter(Builder::authenticationMaterial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterial").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DEVICE_ID_FIELD,
            CONNECTOR_DEVICE_NAME_FIELD, DEVICE_TYPES_FIELD, MANAGED_THING_ID_FIELD, MODIFICATION_FIELD, DISCOVERED_AT_FIELD,
            BRAND_FIELD, MODEL_FIELD, AUTHENTICATION_MATERIAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorDeviceId;

    private final String connectorDeviceName;

    private final List<String> deviceTypes;

    private final String managedThingId;

    private final String modification;

    private final Instant discoveredAt;

    private final String brand;

    private final String model;

    private final String authenticationMaterial;

    private DiscoveredDeviceSummary(BuilderImpl builder) {
        this.connectorDeviceId = builder.connectorDeviceId;
        this.connectorDeviceName = builder.connectorDeviceName;
        this.deviceTypes = builder.deviceTypes;
        this.managedThingId = builder.managedThingId;
        this.modification = builder.modification;
        this.discoveredAt = builder.discoveredAt;
        this.brand = builder.brand;
        this.model = builder.model;
        this.authenticationMaterial = builder.authenticationMaterial;
    }

    /**
     * <p>
     * The third-party device identifier as defined by the connector. This identifier must not contain personal
     * identifiable information (PII).
     * </p>
     * 
     * @return The third-party device identifier as defined by the connector. This identifier must not contain personal
     *         identifiable information (PII).
     */
    public final String connectorDeviceId() {
        return connectorDeviceId;
    }

    /**
     * <p>
     * The name of the device as defined by the connector or third-party system.
     * </p>
     * 
     * @return The name of the device as defined by the connector or third-party system.
     */
    public final String connectorDeviceName() {
        return connectorDeviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceTypes() {
        return deviceTypes != null && !(deviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of device types or categories that the discovered device belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceTypes} method.
     * </p>
     * 
     * @return The list of device types or categories that the discovered device belongs to.
     */
    public final List<String> deviceTypes() {
        return deviceTypes;
    }

    /**
     * <p>
     * The identifier of the managed thing created for this discovered device, if one exists.
     * </p>
     * 
     * @return The identifier of the managed thing created for this discovered device, if one exists.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The status of the discovered device, indicating whether it has been added, removed, or modified since the last
     * discovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modification} will
     * return {@link DiscoveryModification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modificationAsString}.
     * </p>
     * 
     * @return The status of the discovered device, indicating whether it has been added, removed, or modified since the
     *         last discovery.
     * @see DiscoveryModification
     */
    public final DiscoveryModification modification() {
        return DiscoveryModification.fromValue(modification);
    }

    /**
     * <p>
     * The status of the discovered device, indicating whether it has been added, removed, or modified since the last
     * discovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modification} will
     * return {@link DiscoveryModification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modificationAsString}.
     * </p>
     * 
     * @return The status of the discovered device, indicating whether it has been added, removed, or modified since the
     *         last discovery.
     * @see DiscoveryModification
     */
    public final String modificationAsString() {
        return modification;
    }

    /**
     * <p>
     * The timestamp indicating when the device was discovered.
     * </p>
     * 
     * @return The timestamp indicating when the device was discovered.
     */
    public final Instant discoveredAt() {
        return discoveredAt;
    }

    /**
     * <p>
     * The brand of the discovered device.
     * </p>
     * 
     * @return The brand of the discovered device.
     */
    public final String brand() {
        return brand;
    }

    /**
     * <p>
     * The model of the discovered device.
     * </p>
     * 
     * @return The model of the discovered device.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The authentication material required for connecting to the discovered device, such as credentials or tokens.
     * </p>
     * 
     * @return The authentication material required for connecting to the discovered device, such as credentials or
     *         tokens.
     */
    public final String authenticationMaterial() {
        return authenticationMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceTypes() ? deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(modificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(discoveredAt());
        hashCode = 31 * hashCode + Objects.hashCode(brand());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMaterial());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveredDeviceSummary)) {
            return false;
        }
        DiscoveredDeviceSummary other = (DiscoveredDeviceSummary) obj;
        return Objects.equals(connectorDeviceId(), other.connectorDeviceId())
                && Objects.equals(connectorDeviceName(), other.connectorDeviceName())
                && hasDeviceTypes() == other.hasDeviceTypes() && Objects.equals(deviceTypes(), other.deviceTypes())
                && Objects.equals(managedThingId(), other.managedThingId())
                && Objects.equals(modificationAsString(), other.modificationAsString())
                && Objects.equals(discoveredAt(), other.discoveredAt()) && Objects.equals(brand(), other.brand())
                && Objects.equals(model(), other.model())
                && Objects.equals(authenticationMaterial(), other.authenticationMaterial());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoveredDeviceSummary")
                .add("ConnectorDeviceId", connectorDeviceId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectorDeviceName", connectorDeviceName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DeviceTypes", hasDeviceTypes() ? deviceTypes() : null).add("ManagedThingId", managedThingId())
                .add("Modification", modificationAsString()).add("DiscoveredAt", discoveredAt())
                .add("Brand", brand() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Model", model() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationMaterial", authenticationMaterial() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorDeviceId":
            return Optional.ofNullable(clazz.cast(connectorDeviceId()));
        case "ConnectorDeviceName":
            return Optional.ofNullable(clazz.cast(connectorDeviceName()));
        case "DeviceTypes":
            return Optional.ofNullable(clazz.cast(deviceTypes()));
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "Modification":
            return Optional.ofNullable(clazz.cast(modificationAsString()));
        case "DiscoveredAt":
            return Optional.ofNullable(clazz.cast(discoveredAt()));
        case "Brand":
            return Optional.ofNullable(clazz.cast(brand()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "AuthenticationMaterial":
            return Optional.ofNullable(clazz.cast(authenticationMaterial()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorDeviceId", CONNECTOR_DEVICE_ID_FIELD);
        map.put("ConnectorDeviceName", CONNECTOR_DEVICE_NAME_FIELD);
        map.put("DeviceTypes", DEVICE_TYPES_FIELD);
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Modification", MODIFICATION_FIELD);
        map.put("DiscoveredAt", DISCOVERED_AT_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("AuthenticationMaterial", AUTHENTICATION_MATERIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoveredDeviceSummary, T> g) {
        return obj -> g.apply((DiscoveredDeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiscoveredDeviceSummary> {
        /**
         * <p>
         * The third-party device identifier as defined by the connector. This identifier must not contain personal
         * identifiable information (PII).
         * </p>
         * 
         * @param connectorDeviceId
         *        The third-party device identifier as defined by the connector. This identifier must not contain
         *        personal identifiable information (PII).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceId(String connectorDeviceId);

        /**
         * <p>
         * The name of the device as defined by the connector or third-party system.
         * </p>
         * 
         * @param connectorDeviceName
         *        The name of the device as defined by the connector or third-party system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDeviceName(String connectorDeviceName);

        /**
         * <p>
         * The list of device types or categories that the discovered device belongs to.
         * </p>
         * 
         * @param deviceTypes
         *        The list of device types or categories that the discovered device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(Collection<String> deviceTypes);

        /**
         * <p>
         * The list of device types or categories that the discovered device belongs to.
         * </p>
         * 
         * @param deviceTypes
         *        The list of device types or categories that the discovered device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(String... deviceTypes);

        /**
         * <p>
         * The identifier of the managed thing created for this discovered device, if one exists.
         * </p>
         * 
         * @param managedThingId
         *        The identifier of the managed thing created for this discovered device, if one exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The status of the discovered device, indicating whether it has been added, removed, or modified since the
         * last discovery.
         * </p>
         * 
         * @param modification
         *        The status of the discovered device, indicating whether it has been added, removed, or modified since
         *        the last discovery.
         * @see DiscoveryModification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryModification
         */
        Builder modification(String modification);

        /**
         * <p>
         * The status of the discovered device, indicating whether it has been added, removed, or modified since the
         * last discovery.
         * </p>
         * 
         * @param modification
         *        The status of the discovered device, indicating whether it has been added, removed, or modified since
         *        the last discovery.
         * @see DiscoveryModification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryModification
         */
        Builder modification(DiscoveryModification modification);

        /**
         * <p>
         * The timestamp indicating when the device was discovered.
         * </p>
         * 
         * @param discoveredAt
         *        The timestamp indicating when the device was discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveredAt(Instant discoveredAt);

        /**
         * <p>
         * The brand of the discovered device.
         * </p>
         * 
         * @param brand
         *        The brand of the discovered device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brand(String brand);

        /**
         * <p>
         * The model of the discovered device.
         * </p>
         * 
         * @param model
         *        The model of the discovered device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The authentication material required for connecting to the discovered device, such as credentials or tokens.
         * </p>
         * 
         * @param authenticationMaterial
         *        The authentication material required for connecting to the discovered device, such as credentials or
         *        tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMaterial(String authenticationMaterial);
    }

    static final class BuilderImpl implements Builder {
        private String connectorDeviceId;

        private String connectorDeviceName;

        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();

        private String managedThingId;

        private String modification;

        private Instant discoveredAt;

        private String brand;

        private String model;

        private String authenticationMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveredDeviceSummary model) {
            connectorDeviceId(model.connectorDeviceId);
            connectorDeviceName(model.connectorDeviceName);
            deviceTypes(model.deviceTypes);
            managedThingId(model.managedThingId);
            modification(model.modification);
            discoveredAt(model.discoveredAt);
            brand(model.brand);
            model(model.model);
            authenticationMaterial(model.authenticationMaterial);
        }

        public final String getConnectorDeviceId() {
            return connectorDeviceId;
        }

        public final void setConnectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
        }

        @Override
        public final Builder connectorDeviceId(String connectorDeviceId) {
            this.connectorDeviceId = connectorDeviceId;
            return this;
        }

        public final String getConnectorDeviceName() {
            return connectorDeviceName;
        }

        public final void setConnectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
        }

        @Override
        public final Builder connectorDeviceName(String connectorDeviceName) {
            this.connectorDeviceName = connectorDeviceName;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String... deviceTypes) {
            deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final String getModification() {
            return modification;
        }

        public final void setModification(String modification) {
            this.modification = modification;
        }

        @Override
        public final Builder modification(String modification) {
            this.modification = modification;
            return this;
        }

        @Override
        public final Builder modification(DiscoveryModification modification) {
            this.modification(modification == null ? null : modification.toString());
            return this;
        }

        public final Instant getDiscoveredAt() {
            return discoveredAt;
        }

        public final void setDiscoveredAt(Instant discoveredAt) {
            this.discoveredAt = discoveredAt;
        }

        @Override
        public final Builder discoveredAt(Instant discoveredAt) {
            this.discoveredAt = discoveredAt;
            return this;
        }

        public final String getBrand() {
            return brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getAuthenticationMaterial() {
            return authenticationMaterial;
        }

        public final void setAuthenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
        }

        @Override
        public final Builder authenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
            return this;
        }

        @Override
        public DiscoveredDeviceSummary build() {
            return new DiscoveredDeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
