/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomEndpointResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetCustomEndpointResponse.Builder, GetCustomEndpointResponse> {
    private static final SdkField<String> ENDPOINT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointAddress").getter(getter(GetCustomEndpointResponse::endpointAddress))
            .setter(setter(Builder::endpointAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointAddress;

    private GetCustomEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointAddress = builder.endpointAddress;
    }

    /**
     * <p>
     * The IoT managed integrations dedicated, custom endpoint for the device to route traffic through.
     * </p>
     * 
     * @return The IoT managed integrations dedicated, custom endpoint for the device to route traffic through.
     */
    public final String endpointAddress() {
        return endpointAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomEndpointResponse)) {
            return false;
        }
        GetCustomEndpointResponse other = (GetCustomEndpointResponse) obj;
        return Objects.equals(endpointAddress(), other.endpointAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomEndpointResponse").add("EndpointAddress", endpointAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointAddress":
            return Optional.ofNullable(clazz.cast(endpointAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointAddress", ENDPOINT_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCustomEndpointResponse, T> g) {
        return obj -> g.apply((GetCustomEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCustomEndpointResponse> {
        /**
         * <p>
         * The IoT managed integrations dedicated, custom endpoint for the device to route traffic through.
         * </p>
         * 
         * @param endpointAddress
         *        The IoT managed integrations dedicated, custom endpoint for the device to route traffic through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointAddress(String endpointAddress);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String endpointAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomEndpointResponse model) {
            super(model);
            endpointAddress(model.endpointAddress);
        }

        public final String getEndpointAddress() {
            return endpointAddress;
        }

        public final void setEndpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
        }

        @Override
        public final Builder endpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        @Override
        public GetCustomEndpointResponse build() {
            return new GetCustomEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
