/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedThingCapabilitiesResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetManagedThingCapabilitiesResponse.Builder, GetManagedThingCapabilitiesResponse> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(GetManagedThingCapabilitiesResponse::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final SdkField<String> CAPABILITIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Capabilities").getter(getter(GetManagedThingCapabilitiesResponse::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<CapabilityReport> CAPABILITY_REPORT_FIELD = SdkField
            .<CapabilityReport> builder(MarshallingType.SDK_POJO).memberName("CapabilityReport")
            .getter(getter(GetManagedThingCapabilitiesResponse::capabilityReport)).setter(setter(Builder::capabilityReport))
            .constructor(CapabilityReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            CAPABILITIES_FIELD, CAPABILITY_REPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final String capabilities;

    private final CapabilityReport capabilityReport;

    private GetManagedThingCapabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.capabilities = builder.capabilities;
        this.capabilityReport = builder.capabilityReport;
    }

    /**
     * <p>
     * The id of the device.
     * </p>
     * 
     * @return The id of the device.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The capabilities of the device such as light bulb.
     * </p>
     * 
     * @return The capabilities of the device such as light bulb.
     */
    public final String capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * A report of the capabilities for the managed thing.
     * </p>
     * 
     * @return A report of the capabilities for the managed thing.
     */
    public final CapabilityReport capabilityReport() {
        return capabilityReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingCapabilitiesResponse)) {
            return false;
        }
        GetManagedThingCapabilitiesResponse other = (GetManagedThingCapabilitiesResponse) obj;
        return Objects.equals(managedThingId(), other.managedThingId()) && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(capabilityReport(), other.capabilityReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedThingCapabilitiesResponse").add("ManagedThingId", managedThingId())
                .add("Capabilities", capabilities()).add("CapabilityReport", capabilityReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "CapabilityReport":
            return Optional.ofNullable(clazz.cast(capabilityReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingCapabilitiesResponse, T> g) {
        return obj -> g.apply((GetManagedThingCapabilitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedThingCapabilitiesResponse> {
        /**
         * <p>
         * The id of the device.
         * </p>
         * 
         * @param managedThingId
         *        The id of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The capabilities of the device such as light bulb.
         * </p>
         * 
         * @param capabilities
         *        The capabilities of the device such as light bulb.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String capabilities);

        /**
         * <p>
         * A report of the capabilities for the managed thing.
         * </p>
         * 
         * @param capabilityReport
         *        A report of the capabilities for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityReport(CapabilityReport capabilityReport);

        /**
         * <p>
         * A report of the capabilities for the managed thing.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityReport.Builder} avoiding the
         * need to create one manually via {@link CapabilityReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityReport.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilityReport(CapabilityReport)}.
         * 
         * @param capabilityReport
         *        a consumer that will call methods on {@link CapabilityReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityReport(CapabilityReport)
         */
        default Builder capabilityReport(Consumer<CapabilityReport.Builder> capabilityReport) {
            return capabilityReport(CapabilityReport.builder().applyMutation(capabilityReport).build());
        }
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String managedThingId;

        private String capabilities;

        private CapabilityReport capabilityReport;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingCapabilitiesResponse model) {
            super(model);
            managedThingId(model.managedThingId);
            capabilities(model.capabilities);
            capabilityReport(model.capabilityReport);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final String getCapabilities() {
            return capabilities;
        }

        public final void setCapabilities(String capabilities) {
            this.capabilities = capabilities;
        }

        @Override
        public final Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final CapabilityReport.Builder getCapabilityReport() {
            return capabilityReport != null ? capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(CapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(CapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        @Override
        public GetManagedThingCapabilitiesResponse build() {
            return new GetManagedThingCapabilitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
