/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOtaTaskConfigurationResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetOtaTaskConfigurationResponse.Builder, GetOtaTaskConfigurationResponse> {
    private static final SdkField<String> TASK_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskConfigurationId").getter(getter(GetOtaTaskConfigurationResponse::taskConfigurationId))
            .setter(setter(Builder::taskConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfigurationId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetOtaTaskConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PushConfig> PUSH_CONFIG_FIELD = SdkField.<PushConfig> builder(MarshallingType.SDK_POJO)
            .memberName("PushConfig").getter(getter(GetOtaTaskConfigurationResponse::pushConfig))
            .setter(setter(Builder::pushConfig)).constructor(PushConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetOtaTaskConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetOtaTaskConfigurationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_CONFIGURATION_ID_FIELD,
            NAME_FIELD, PUSH_CONFIG_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String taskConfigurationId;

    private final String name;

    private final PushConfig pushConfig;

    private final String description;

    private final Instant createdAt;

    private GetOtaTaskConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.taskConfigurationId = builder.taskConfigurationId;
        this.name = builder.name;
        this.pushConfig = builder.pushConfig;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The over-the-air (OTA) task configuration id.
     * </p>
     * 
     * @return The over-the-air (OTA) task configuration id.
     */
    public final String taskConfigurationId() {
        return taskConfigurationId;
    }

    /**
     * <p>
     * The name of the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return The name of the over-the-air (OTA) task configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the type of configuration used for the over-the-air (OTA) task.
     * </p>
     * 
     * @return Describes the type of configuration used for the over-the-air (OTA) task.
     */
    public final PushConfig pushConfig() {
        return pushConfig;
    }

    /**
     * <p>
     * A description of the over-the-air (OTA) task configuration.
     * </p>
     * 
     * @return A description of the over-the-air (OTA) task configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp value of when the over-the-air (OTA) task configuration was created at.
     * </p>
     * 
     * @return The timestamp value of when the over-the-air (OTA) task configuration was created at.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pushConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOtaTaskConfigurationResponse)) {
            return false;
        }
        GetOtaTaskConfigurationResponse other = (GetOtaTaskConfigurationResponse) obj;
        return Objects.equals(taskConfigurationId(), other.taskConfigurationId()) && Objects.equals(name(), other.name())
                && Objects.equals(pushConfig(), other.pushConfig()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOtaTaskConfigurationResponse").add("TaskConfigurationId", taskConfigurationId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("PushConfig", pushConfig())
                .add("Description", description()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskConfigurationId":
            return Optional.ofNullable(clazz.cast(taskConfigurationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PushConfig":
            return Optional.ofNullable(clazz.cast(pushConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskConfigurationId", TASK_CONFIGURATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PushConfig", PUSH_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOtaTaskConfigurationResponse, T> g) {
        return obj -> g.apply((GetOtaTaskConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOtaTaskConfigurationResponse> {
        /**
         * <p>
         * The over-the-air (OTA) task configuration id.
         * </p>
         * 
         * @param taskConfigurationId
         *        The over-the-air (OTA) task configuration id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskConfigurationId(String taskConfigurationId);

        /**
         * <p>
         * The name of the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param name
         *        The name of the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the type of configuration used for the over-the-air (OTA) task.
         * </p>
         * 
         * @param pushConfig
         *        Describes the type of configuration used for the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushConfig(PushConfig pushConfig);

        /**
         * <p>
         * Describes the type of configuration used for the over-the-air (OTA) task.
         * </p>
         * This is a convenience method that creates an instance of the {@link PushConfig.Builder} avoiding the need to
         * create one manually via {@link PushConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PushConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #pushConfig(PushConfig)}.
         * 
         * @param pushConfig
         *        a consumer that will call methods on {@link PushConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pushConfig(PushConfig)
         */
        default Builder pushConfig(Consumer<PushConfig.Builder> pushConfig) {
            return pushConfig(PushConfig.builder().applyMutation(pushConfig).build());
        }

        /**
         * <p>
         * A description of the over-the-air (OTA) task configuration.
         * </p>
         * 
         * @param description
         *        A description of the over-the-air (OTA) task configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp value of when the over-the-air (OTA) task configuration was created at.
         * </p>
         * 
         * @param createdAt
         *        The timestamp value of when the over-the-air (OTA) task configuration was created at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String taskConfigurationId;

        private String name;

        private PushConfig pushConfig;

        private String description;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOtaTaskConfigurationResponse model) {
            super(model);
            taskConfigurationId(model.taskConfigurationId);
            name(model.name);
            pushConfig(model.pushConfig);
            description(model.description);
            createdAt(model.createdAt);
        }

        public final String getTaskConfigurationId() {
            return taskConfigurationId;
        }

        public final void setTaskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
        }

        @Override
        public final Builder taskConfigurationId(String taskConfigurationId) {
            this.taskConfigurationId = taskConfigurationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PushConfig.Builder getPushConfig() {
            return pushConfig != null ? pushConfig.toBuilder() : null;
        }

        public final void setPushConfig(PushConfig.BuilderImpl pushConfig) {
            this.pushConfig = pushConfig != null ? pushConfig.build() : null;
        }

        @Override
        public final Builder pushConfig(PushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public GetOtaTaskConfigurationResponse build() {
            return new GetOtaTaskConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
