/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaVersionRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<GetSchemaVersionRequest.Builder, GetSchemaVersionRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetSchemaVersionRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").build()).build();

    private static final SdkField<String> SCHEMA_VERSIONED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionedId").getter(getter(GetSchemaVersionRequest::schemaVersionedId))
            .setter(setter(Builder::schemaVersionedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SchemaVersionedId").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetSchemaVersionRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SCHEMA_VERSIONED_ID_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String schemaVersionedId;

    private final String format;

    private GetSchemaVersionRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.schemaVersionedId = builder.schemaVersionedId;
        this.format = builder.format;
    }

    /**
     * <p>
     * The type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema version.
     * @see SchemaVersionType
     */
    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(type);
    }

    /**
     * <p>
     * The type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema version.
     * @see SchemaVersionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Schema id with a version specified. If the version is missing, it defaults to latest version.
     * </p>
     * 
     * @return Schema id with a version specified. If the version is missing, it defaults to latest version.
     */
    public final String schemaVersionedId() {
        return schemaVersionedId;
    }

    /**
     * <p>
     * The format of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link SchemaVersionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the schema version.
     * @see SchemaVersionFormat
     */
    public final SchemaVersionFormat format() {
        return SchemaVersionFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link SchemaVersionFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the schema version.
     * @see SchemaVersionFormat
     */
    public final String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionedId());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionRequest)) {
            return false;
        }
        GetSchemaVersionRequest other = (GetSchemaVersionRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(schemaVersionedId(), other.schemaVersionedId())
                && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaVersionRequest").add("Type", typeAsString())
                .add("SchemaVersionedId", schemaVersionedId()).add("Format", formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SchemaVersionedId":
            return Optional.ofNullable(clazz.cast(schemaVersionedId()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("SchemaVersionedId", SCHEMA_VERSIONED_ID_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionRequest, T> g) {
        return obj -> g.apply((GetSchemaVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSchemaVersionRequest> {
        /**
         * <p>
         * The type of schema version.
         * </p>
         * 
         * @param type
         *        The type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of schema version.
         * </p>
         * 
         * @param type
         *        The type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(SchemaVersionType type);

        /**
         * <p>
         * Schema id with a version specified. If the version is missing, it defaults to latest version.
         * </p>
         * 
         * @param schemaVersionedId
         *        Schema id with a version specified. If the version is missing, it defaults to latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionedId(String schemaVersionedId);

        /**
         * <p>
         * The format of the schema version.
         * </p>
         * 
         * @param format
         *        The format of the schema version.
         * @see SchemaVersionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the schema version.
         * </p>
         * 
         * @param format
         *        The format of the schema version.
         * @see SchemaVersionFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionFormat
         */
        Builder format(SchemaVersionFormat format);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String type;

        private String schemaVersionedId;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionRequest model) {
            super(model);
            type(model.type);
            schemaVersionedId(model.schemaVersionedId);
            format(model.format);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSchemaVersionedId() {
            return schemaVersionedId;
        }

        public final void setSchemaVersionedId(String schemaVersionedId) {
            this.schemaVersionedId = schemaVersionedId;
        }

        @Override
        public final Builder schemaVersionedId(String schemaVersionedId) {
            this.schemaVersionedId = schemaVersionedId;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(SchemaVersionFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaVersionRequest build() {
            return new GetSchemaVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
