/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedThingSchemasRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<ListManagedThingSchemasRequest.Builder, ListManagedThingSchemasRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ListManagedThingSchemasRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointIdFilter").getter(getter(ListManagedThingSchemasRequest::endpointIdFilter))
            .setter(setter(Builder::endpointIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndpointIdFilter").build())
            .build();

    private static final SdkField<String> CAPABILITY_ID_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapabilityIdFilter").getter(getter(ListManagedThingSchemasRequest::capabilityIdFilter))
            .setter(setter(Builder::capabilityIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CapabilityIdFilter").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListManagedThingSchemasRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListManagedThingSchemasRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            ENDPOINT_ID_FILTER_FIELD, CAPABILITY_ID_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String endpointIdFilter;

    private final String capabilityIdFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListManagedThingSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.endpointIdFilter = builder.endpointIdFilter;
        this.capabilityIdFilter = builder.capabilityIdFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The managed thing id.
     * </p>
     * 
     * @return The managed thing id.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Filter on an endpoint id.
     * </p>
     * 
     * @return Filter on an endpoint id.
     */
    public final String endpointIdFilter() {
        return endpointIdFilter;
    }

    /**
     * <p>
     * Filter on a capability id.
     * </p>
     * 
     * @return Filter on a capability id.
     */
    public final String capabilityIdFilter() {
        return capabilityIdFilter;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityIdFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedThingSchemasRequest)) {
            return false;
        }
        ListManagedThingSchemasRequest other = (ListManagedThingSchemasRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(endpointIdFilter(), other.endpointIdFilter())
                && Objects.equals(capabilityIdFilter(), other.capabilityIdFilter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedThingSchemasRequest").add("Identifier", identifier())
                .add("EndpointIdFilter", endpointIdFilter()).add("CapabilityIdFilter", capabilityIdFilter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "EndpointIdFilter":
            return Optional.ofNullable(clazz.cast(endpointIdFilter()));
        case "CapabilityIdFilter":
            return Optional.ofNullable(clazz.cast(capabilityIdFilter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("EndpointIdFilter", ENDPOINT_ID_FILTER_FIELD);
        map.put("CapabilityIdFilter", CAPABILITY_ID_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedThingSchemasRequest, T> g) {
        return obj -> g.apply((ListManagedThingSchemasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedThingSchemasRequest> {
        /**
         * <p>
         * The managed thing id.
         * </p>
         * 
         * @param identifier
         *        The managed thing id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Filter on an endpoint id.
         * </p>
         * 
         * @param endpointIdFilter
         *        Filter on an endpoint id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIdFilter(String endpointIdFilter);

        /**
         * <p>
         * Filter on a capability id.
         * </p>
         * 
         * @param capabilityIdFilter
         *        Filter on a capability id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityIdFilter(String capabilityIdFilter);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String identifier;

        private String endpointIdFilter;

        private String capabilityIdFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedThingSchemasRequest model) {
            super(model);
            identifier(model.identifier);
            endpointIdFilter(model.endpointIdFilter);
            capabilityIdFilter(model.capabilityIdFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getEndpointIdFilter() {
            return endpointIdFilter;
        }

        public final void setEndpointIdFilter(String endpointIdFilter) {
            this.endpointIdFilter = endpointIdFilter;
        }

        @Override
        public final Builder endpointIdFilter(String endpointIdFilter) {
            this.endpointIdFilter = endpointIdFilter;
            return this;
        }

        public final String getCapabilityIdFilter() {
            return capabilityIdFilter;
        }

        public final void setCapabilityIdFilter(String capabilityIdFilter) {
            this.capabilityIdFilter = capabilityIdFilter;
        }

        @Override
        public final Builder capabilityIdFilter(String capabilityIdFilter) {
            this.capabilityIdFilter = capabilityIdFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedThingSchemasRequest build() {
            return new ListManagedThingSchemasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
