/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe a Matter cluster with an id, and the relevant attributes, commands, and events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatterCluster implements SdkPojo, Serializable, ToCopyableBuilder<MatterCluster.Builder, MatterCluster> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(MatterCluster::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Document> ATTRIBUTES_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("attributes").getter(getter(MatterCluster::attributes)).setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<Map<String, Document>> COMMANDS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("commands")
            .getter(getter(MatterCluster::commands))
            .setter(setter(Builder::commands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Document>> EVENTS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("events")
            .getter(getter(MatterCluster::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTRIBUTES_FIELD,
            COMMANDS_FIELD, EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Document attributes;

    private final Map<String, Document> commands;

    private final Map<String, Document> events;

    private MatterCluster(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
        this.commands = builder.commands;
        this.events = builder.events;
    }

    /**
     * <p>
     * The cluster id.
     * </p>
     * 
     * @return The cluster id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Matter attributes.
     * </p>
     * 
     * @return The Matter attributes.
     */
    public final Document attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Commands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommands() {
        return commands != null && !(commands instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describe the Matter commands with the Matter command identifier mapped to the command fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommands} method.
     * </p>
     * 
     * @return Describe the Matter commands with the Matter command identifier mapped to the command fields.
     */
    public final Map<String, Document> commands() {
        return commands;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describe the Matter events with the Matter event identifier mapped to the event fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return Describe the Matter events with the Matter event identifier mapped to the event fields.
     */
    public final Map<String, Document> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommands() ? commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCluster)) {
            return false;
        }
        MatterCluster other = (MatterCluster) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(attributes(), other.attributes())
                && hasCommands() == other.hasCommands() && Objects.equals(commands(), other.commands())
                && hasEvents() == other.hasEvents() && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatterCluster").add("Id", id())
                .add("Attributes", attributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Commands", commands() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Events", events() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "commands":
            return Optional.ofNullable(clazz.cast(commands()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("commands", COMMANDS_FIELD);
        map.put("events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCluster, T> g) {
        return obj -> g.apply((MatterCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatterCluster> {
        /**
         * <p>
         * The cluster id.
         * </p>
         * 
         * @param id
         *        The cluster id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Matter attributes.
         * </p>
         * 
         * @param attributes
         *        The Matter attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Document attributes);

        /**
         * <p>
         * Describe the Matter commands with the Matter command identifier mapped to the command fields.
         * </p>
         * 
         * @param commands
         *        Describe the Matter commands with the Matter command identifier mapped to the command fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Map<String, Document> commands);

        /**
         * <p>
         * Describe the Matter events with the Matter event identifier mapped to the event fields.
         * </p>
         * 
         * @param events
         *        Describe the Matter events with the Matter event identifier mapped to the event fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Map<String, Document> events);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Document attributes;

        private Map<String, Document> commands = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Document> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCluster model) {
            id(model.id);
            attributes(model.attributes);
            commands(model.commands);
            events(model.events);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Document getAttributes() {
            return attributes;
        }

        public final void setAttributes(Document attributes) {
            this.attributes = attributes;
        }

        @Override
        public final Builder attributes(Document attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Map<String, Document> getCommands() {
            if (commands instanceof SdkAutoConstructMap) {
                return null;
            }
            return commands;
        }

        public final void setCommands(Map<String, Document> commands) {
            this.commands = MatterCommandsCopier.copy(commands);
        }

        @Override
        public final Builder commands(Map<String, Document> commands) {
            this.commands = MatterCommandsCopier.copy(commands);
            return this;
        }

        public final Map<String, Document> getEvents() {
            if (events instanceof SdkAutoConstructMap) {
                return null;
            }
            return events;
        }

        public final void setEvents(Map<String, Document> events) {
            this.events = MatterEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Map<String, Document> events) {
            this.events = MatterEventsCopier.copy(events);
            return this;
        }

        @Override
        public MatterCluster build() {
            return new MatterCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
