/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure describing a notification configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfigurationSummary.Builder, NotificationConfigurationSummary> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventType").getter(getter(NotificationConfigurationSummary::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(NotificationConfigurationSummary::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            DESTINATION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final String destinationName;

    private NotificationConfigurationSummary(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.destinationName = builder.destinationName;
    }

    /**
     * <p>
     * The type of event triggering a device notification to the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event triggering a device notification to the customer-managed destination.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of event triggering a device notification to the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of event triggering a device notification to the customer-managed destination.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The name of the destination for the notification configuration.
     * </p>
     * 
     * @return The name of the destination for the notification configuration.
     */
    public final String destinationName() {
        return destinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfigurationSummary)) {
            return false;
        }
        NotificationConfigurationSummary other = (NotificationConfigurationSummary) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(destinationName(), other.destinationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfigurationSummary").add("EventType", eventTypeAsString())
                .add("DestinationName", destinationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfigurationSummary, T> g) {
        return obj -> g.apply((NotificationConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfigurationSummary> {
        /**
         * <p>
         * The type of event triggering a device notification to the customer-managed destination.
         * </p>
         * 
         * @param eventType
         *        The type of event triggering a device notification to the customer-managed destination.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of event triggering a device notification to the customer-managed destination.
         * </p>
         * 
         * @param eventType
         *        The type of event triggering a device notification to the customer-managed destination.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The name of the destination for the notification configuration.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination for the notification configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private String destinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfigurationSummary model) {
            eventType(model.eventType);
            destinationName(model.destinationName);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public NotificationConfigurationSummary build() {
            return new NotificationConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
