/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details for OAuth authentication with a third-party service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuthConfig implements SdkPojo, Serializable, ToCopyableBuilder<OAuthConfig.Builder, OAuthConfig> {
    private static final SdkField<String> AUTH_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authUrl").getter(getter(OAuthConfig::authUrl)).setter(setter(Builder::authUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authUrl").build()).build();

    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenUrl").getter(getter(OAuthConfig::tokenUrl)).setter(setter(Builder::tokenUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(OAuthConfig::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("tokenEndpointAuthenticationScheme")
            .getter(getter(OAuthConfig::tokenEndpointAuthenticationSchemeAsString))
            .setter(setter(Builder::tokenEndpointAuthenticationScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpointAuthenticationScheme")
                    .build()).build();

    private static final SdkField<String> O_AUTH_COMPLETE_REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oAuthCompleteRedirectUrl").getter(getter(OAuthConfig::oAuthCompleteRedirectUrl))
            .setter(setter(Builder::oAuthCompleteRedirectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthCompleteRedirectUrl").build())
            .build();

    private static final SdkField<ProactiveRefreshTokenRenewal> PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD = SdkField
            .<ProactiveRefreshTokenRenewal> builder(MarshallingType.SDK_POJO)
            .memberName("proactiveRefreshTokenRenewal")
            .getter(getter(OAuthConfig::proactiveRefreshTokenRenewal))
            .setter(setter(Builder::proactiveRefreshTokenRenewal))
            .constructor(ProactiveRefreshTokenRenewal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proactiveRefreshTokenRenewal")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_URL_FIELD,
            TOKEN_URL_FIELD, SCOPE_FIELD, TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD, O_AUTH_COMPLETE_REDIRECT_URL_FIELD,
            PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authUrl;

    private final String tokenUrl;

    private final String scope;

    private final String tokenEndpointAuthenticationScheme;

    private final String oAuthCompleteRedirectUrl;

    private final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

    private OAuthConfig(BuilderImpl builder) {
        this.authUrl = builder.authUrl;
        this.tokenUrl = builder.tokenUrl;
        this.scope = builder.scope;
        this.tokenEndpointAuthenticationScheme = builder.tokenEndpointAuthenticationScheme;
        this.oAuthCompleteRedirectUrl = builder.oAuthCompleteRedirectUrl;
        this.proactiveRefreshTokenRenewal = builder.proactiveRefreshTokenRenewal;
    }

    /**
     * <p>
     * The authorization URL for the OAuth service, where users are directed to authenticate and authorize access.
     * </p>
     * 
     * @return The authorization URL for the OAuth service, where users are directed to authenticate and authorize
     *         access.
     */
    public final String authUrl() {
        return authUrl;
    }

    /**
     * <p>
     * The token URL for the OAuth service, where authorization codes are exchanged for access tokens.
     * </p>
     * 
     * @return The token URL for the OAuth service, where authorization codes are exchanged for access tokens.
     */
    public final String tokenUrl() {
        return tokenUrl;
    }

    /**
     * <p>
     * The OAuth scopes requested during authorization, which define the permissions granted to the application.
     * </p>
     * 
     * @return The OAuth scopes requested during authorization, which define the permissions granted to the application.
     */
    public final String scope() {
        return scope;
    }

    /**
     * <p>
     * The authentication scheme used when requesting tokens from the token endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tokenEndpointAuthenticationScheme} will return
     * {@link TokenEndpointAuthenticationScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tokenEndpointAuthenticationSchemeAsString}.
     * </p>
     * 
     * @return The authentication scheme used when requesting tokens from the token endpoint.
     * @see TokenEndpointAuthenticationScheme
     */
    public final TokenEndpointAuthenticationScheme tokenEndpointAuthenticationScheme() {
        return TokenEndpointAuthenticationScheme.fromValue(tokenEndpointAuthenticationScheme);
    }

    /**
     * <p>
     * The authentication scheme used when requesting tokens from the token endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tokenEndpointAuthenticationScheme} will return
     * {@link TokenEndpointAuthenticationScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tokenEndpointAuthenticationSchemeAsString}.
     * </p>
     * 
     * @return The authentication scheme used when requesting tokens from the token endpoint.
     * @see TokenEndpointAuthenticationScheme
     */
    public final String tokenEndpointAuthenticationSchemeAsString() {
        return tokenEndpointAuthenticationScheme;
    }

    /**
     * <p>
     * The URL where users are redirected after completing the OAuth authorization process.
     * </p>
     * 
     * @return The URL where users are redirected after completing the OAuth authorization process.
     */
    public final String oAuthCompleteRedirectUrl() {
        return oAuthCompleteRedirectUrl;
    }

    /**
     * <p>
     * Configuration for proactively refreshing OAuth tokens before they expire.
     * </p>
     * 
     * @return Configuration for proactively refreshing OAuth tokens before they expire.
     */
    public final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal() {
        return proactiveRefreshTokenRenewal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authUrl());
        hashCode = 31 * hashCode + Objects.hashCode(tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpointAuthenticationSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthCompleteRedirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(proactiveRefreshTokenRenewal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthConfig)) {
            return false;
        }
        OAuthConfig other = (OAuthConfig) obj;
        return Objects.equals(authUrl(), other.authUrl()) && Objects.equals(tokenUrl(), other.tokenUrl())
                && Objects.equals(scope(), other.scope())
                && Objects.equals(tokenEndpointAuthenticationSchemeAsString(), other.tokenEndpointAuthenticationSchemeAsString())
                && Objects.equals(oAuthCompleteRedirectUrl(), other.oAuthCompleteRedirectUrl())
                && Objects.equals(proactiveRefreshTokenRenewal(), other.proactiveRefreshTokenRenewal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OAuthConfig").add("AuthUrl", authUrl()).add("TokenUrl", tokenUrl()).add("Scope", scope())
                .add("TokenEndpointAuthenticationScheme", tokenEndpointAuthenticationSchemeAsString())
                .add("OAuthCompleteRedirectUrl", oAuthCompleteRedirectUrl())
                .add("ProactiveRefreshTokenRenewal", proactiveRefreshTokenRenewal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authUrl":
            return Optional.ofNullable(clazz.cast(authUrl()));
        case "tokenUrl":
            return Optional.ofNullable(clazz.cast(tokenUrl()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "tokenEndpointAuthenticationScheme":
            return Optional.ofNullable(clazz.cast(tokenEndpointAuthenticationSchemeAsString()));
        case "oAuthCompleteRedirectUrl":
            return Optional.ofNullable(clazz.cast(oAuthCompleteRedirectUrl()));
        case "proactiveRefreshTokenRenewal":
            return Optional.ofNullable(clazz.cast(proactiveRefreshTokenRenewal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authUrl", AUTH_URL_FIELD);
        map.put("tokenUrl", TOKEN_URL_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("tokenEndpointAuthenticationScheme", TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD);
        map.put("oAuthCompleteRedirectUrl", O_AUTH_COMPLETE_REDIRECT_URL_FIELD);
        map.put("proactiveRefreshTokenRenewal", PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthConfig, T> g) {
        return obj -> g.apply((OAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuthConfig> {
        /**
         * <p>
         * The authorization URL for the OAuth service, where users are directed to authenticate and authorize access.
         * </p>
         * 
         * @param authUrl
         *        The authorization URL for the OAuth service, where users are directed to authenticate and authorize
         *        access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authUrl(String authUrl);

        /**
         * <p>
         * The token URL for the OAuth service, where authorization codes are exchanged for access tokens.
         * </p>
         * 
         * @param tokenUrl
         *        The token URL for the OAuth service, where authorization codes are exchanged for access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenUrl(String tokenUrl);

        /**
         * <p>
         * The OAuth scopes requested during authorization, which define the permissions granted to the application.
         * </p>
         * 
         * @param scope
         *        The OAuth scopes requested during authorization, which define the permissions granted to the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * The authentication scheme used when requesting tokens from the token endpoint.
         * </p>
         * 
         * @param tokenEndpointAuthenticationScheme
         *        The authentication scheme used when requesting tokens from the token endpoint.
         * @see TokenEndpointAuthenticationScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenEndpointAuthenticationScheme
         */
        Builder tokenEndpointAuthenticationScheme(String tokenEndpointAuthenticationScheme);

        /**
         * <p>
         * The authentication scheme used when requesting tokens from the token endpoint.
         * </p>
         * 
         * @param tokenEndpointAuthenticationScheme
         *        The authentication scheme used when requesting tokens from the token endpoint.
         * @see TokenEndpointAuthenticationScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenEndpointAuthenticationScheme
         */
        Builder tokenEndpointAuthenticationScheme(TokenEndpointAuthenticationScheme tokenEndpointAuthenticationScheme);

        /**
         * <p>
         * The URL where users are redirected after completing the OAuth authorization process.
         * </p>
         * 
         * @param oAuthCompleteRedirectUrl
         *        The URL where users are redirected after completing the OAuth authorization process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl);

        /**
         * <p>
         * Configuration for proactively refreshing OAuth tokens before they expire.
         * </p>
         * 
         * @param proactiveRefreshTokenRenewal
         *        Configuration for proactively refreshing OAuth tokens before they expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal);

        /**
         * <p>
         * Configuration for proactively refreshing OAuth tokens before they expire.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProactiveRefreshTokenRenewal.Builder}
         * avoiding the need to create one manually via {@link ProactiveRefreshTokenRenewal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProactiveRefreshTokenRenewal.Builder#build()} is called
         * immediately and its result is passed to {@link #proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal)}.
         * 
         * @param proactiveRefreshTokenRenewal
         *        a consumer that will call methods on {@link ProactiveRefreshTokenRenewal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal)
         */
        default Builder proactiveRefreshTokenRenewal(Consumer<ProactiveRefreshTokenRenewal.Builder> proactiveRefreshTokenRenewal) {
            return proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal.builder()
                    .applyMutation(proactiveRefreshTokenRenewal).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authUrl;

        private String tokenUrl;

        private String scope;

        private String tokenEndpointAuthenticationScheme;

        private String oAuthCompleteRedirectUrl;

        private ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthConfig model) {
            authUrl(model.authUrl);
            tokenUrl(model.tokenUrl);
            scope(model.scope);
            tokenEndpointAuthenticationScheme(model.tokenEndpointAuthenticationScheme);
            oAuthCompleteRedirectUrl(model.oAuthCompleteRedirectUrl);
            proactiveRefreshTokenRenewal(model.proactiveRefreshTokenRenewal);
        }

        public final String getAuthUrl() {
            return authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public final String getTokenUrl() {
            return tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final String getTokenEndpointAuthenticationScheme() {
            return tokenEndpointAuthenticationScheme;
        }

        public final void setTokenEndpointAuthenticationScheme(String tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme = tokenEndpointAuthenticationScheme;
        }

        @Override
        public final Builder tokenEndpointAuthenticationScheme(String tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme = tokenEndpointAuthenticationScheme;
            return this;
        }

        @Override
        public final Builder tokenEndpointAuthenticationScheme(TokenEndpointAuthenticationScheme tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme(tokenEndpointAuthenticationScheme == null ? null
                    : tokenEndpointAuthenticationScheme.toString());
            return this;
        }

        public final String getOAuthCompleteRedirectUrl() {
            return oAuthCompleteRedirectUrl;
        }

        public final void setOAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
        }

        @Override
        public final Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
            return this;
        }

        public final ProactiveRefreshTokenRenewal.Builder getProactiveRefreshTokenRenewal() {
            return proactiveRefreshTokenRenewal != null ? proactiveRefreshTokenRenewal.toBuilder() : null;
        }

        public final void setProactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal.BuilderImpl proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal != null ? proactiveRefreshTokenRenewal.build()
                    : null;
        }

        @Override
        public final Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal;
            return this;
        }

        @Override
        public OAuthConfig build() {
            return new OAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
