/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendManagedThingCommandRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<SendManagedThingCommandRequest.Builder, SendManagedThingCommandRequest> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(SendManagedThingCommandRequest::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagedThingId").build()).build();

    private static final SdkField<List<CommandEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<CommandEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(SendManagedThingCommandRequest::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTOR_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorAssociationId").getter(getter(SendManagedThingCommandRequest::connectorAssociationId))
            .setter(setter(Builder::connectorAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorAssociationId").build())
            .build();

    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(SendManagedThingCommandRequest::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            ENDPOINTS_FIELD, CONNECTOR_ASSOCIATION_ID_FIELD, ACCOUNT_ASSOCIATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final List<CommandEndpoint> endpoints;

    private final String connectorAssociationId;

    private final String accountAssociationId;

    private SendManagedThingCommandRequest(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.endpoints = builder.endpoints;
        this.connectorAssociationId = builder.connectorAssociationId;
        this.accountAssociationId = builder.accountAssociationId;
    }

    /**
     * <p>
     * The id of the device.
     * </p>
     * 
     * @return The id of the device.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The device endpoint.
     */
    public final List<CommandEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The ID tracking the current discovery process for one connector association.
     * </p>
     * 
     * @return The ID tracking the current discovery process for one connector association.
     * @deprecated ConnectorAssociationId has been deprecated
     */
    @Deprecated
    public final String connectorAssociationId() {
        return connectorAssociationId;
    }

    /**
     * <p>
     * The identifier of the account association to use when sending a command to a managed thing.
     * </p>
     * 
     * @return The identifier of the account association to use when sending a command to a managed thing.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectorAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendManagedThingCommandRequest)) {
            return false;
        }
        SendManagedThingCommandRequest other = (SendManagedThingCommandRequest) obj;
        return Objects.equals(managedThingId(), other.managedThingId()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(connectorAssociationId(), other.connectorAssociationId())
                && Objects.equals(accountAssociationId(), other.accountAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendManagedThingCommandRequest").add("ManagedThingId", managedThingId())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("ConnectorAssociationId", connectorAssociationId())
                .add("AccountAssociationId", accountAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "ConnectorAssociationId":
            return Optional.ofNullable(clazz.cast(connectorAssociationId()));
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("ConnectorAssociationId", CONNECTOR_ASSOCIATION_ID_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendManagedThingCommandRequest, T> g) {
        return obj -> g.apply((SendManagedThingCommandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendManagedThingCommandRequest> {
        /**
         * <p>
         * The id of the device.
         * </p>
         * 
         * @param managedThingId
         *        The id of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The device endpoint.
         * </p>
         * 
         * @param endpoints
         *        The device endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<CommandEndpoint> endpoints);

        /**
         * <p>
         * The device endpoint.
         * </p>
         * 
         * @param endpoints
         *        The device endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(CommandEndpoint... endpoints);

        /**
         * <p>
         * The device endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpoint.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpoint.Builder#build()} is
         * called immediately and its result is passed to {@link #endpoints(List<CommandEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CommandEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<CommandEndpoint>)
         */
        Builder endpoints(Consumer<CommandEndpoint.Builder>... endpoints);

        /**
         * <p>
         * The ID tracking the current discovery process for one connector association.
         * </p>
         * 
         * @param connectorAssociationId
         *        The ID tracking the current discovery process for one connector association.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated ConnectorAssociationId has been deprecated
         */
        @Deprecated
        Builder connectorAssociationId(String connectorAssociationId);

        /**
         * <p>
         * The identifier of the account association to use when sending a command to a managed thing.
         * </p>
         * 
         * @param accountAssociationId
         *        The identifier of the account association to use when sending a command to a managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String managedThingId;

        private List<CommandEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private String connectorAssociationId;

        private String accountAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendManagedThingCommandRequest model) {
            super(model);
            managedThingId(model.managedThingId);
            endpoints(model.endpoints);
            connectorAssociationId(model.connectorAssociationId);
            accountAssociationId(model.accountAssociationId);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final List<CommandEndpoint.Builder> getEndpoints() {
            List<CommandEndpoint.Builder> result = CommandEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<CommandEndpoint.BuilderImpl> endpoints) {
            this.endpoints = CommandEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<CommandEndpoint> endpoints) {
            this.endpoints = CommandEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(CommandEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<CommandEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> CommandEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getConnectorAssociationId() {
            return connectorAssociationId;
        }

        @Deprecated
        public final void setConnectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
        }

        @Override
        @Deprecated
        public final Builder connectorAssociationId(String connectorAssociationId) {
            this.connectorAssociationId = connectorAssociationId;
            return this;
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendManagedThingCommandRequest build() {
            return new SendManagedThingCommandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
