/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe the endpoint with an Id, a name, and the relevant capabilities for reporting state
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<StateEndpoint.Builder, StateEndpoint> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointId").getter(getter(StateEndpoint::endpointId)).setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointId").build()).build();

    private static final SdkField<List<StateCapability>> CAPABILITIES_FIELD = SdkField
            .<List<StateCapability>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(StateEndpoint::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StateCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(StateCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD,
            CAPABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointId;

    private final List<StateCapability> capabilities;

    private StateEndpoint(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * Numeric identifier of the endpoint
     * </p>
     * 
     * @return Numeric identifier of the endpoint
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
     */
    public final List<StateCapability> capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateEndpoint)) {
            return false;
        }
        StateEndpoint other = (StateEndpoint) obj;
        return Objects.equals(endpointId(), other.endpointId()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateEndpoint").add("EndpointId", endpointId())
                .add("Capabilities", hasCapabilities() ? capabilities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointId", ENDPOINT_ID_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateEndpoint, T> g) {
        return obj -> g.apply((StateEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateEndpoint> {
        /**
         * <p>
         * Numeric identifier of the endpoint
         * </p>
         * 
         * @param endpointId
         *        Numeric identifier of the endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
         * </p>
         * 
         * @param capabilities
         *        Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<StateCapability> capabilities);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
         * </p>
         * 
         * @param capabilities
         *        Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(StateCapability... capabilities);

        /**
         * <p>
         * Describe the endpoint with an id, a name, and the relevant capabilities for the reporting state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapability.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapability.Builder#build()} is
         * called immediately and its result is passed to {@link #capabilities(List<StateCapability>)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.StateCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(java.util.Collection<StateCapability>)
         */
        Builder capabilities(Consumer<StateCapability.Builder>... capabilities);
    }

    static final class BuilderImpl implements Builder {
        private String endpointId;

        private List<StateCapability> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StateEndpoint model) {
            endpointId(model.endpointId);
            capabilities(model.capabilities);
        }

        public final String getEndpointId() {
            return endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final List<StateCapability.Builder> getCapabilities() {
            List<StateCapability.Builder> result = StateCapabilitiesCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<StateCapability.BuilderImpl> capabilities) {
            this.capabilities = StateCapabilitiesCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<StateCapability> capabilities) {
            this.capabilities = StateCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(StateCapability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<StateCapability.Builder>... capabilities) {
            capabilities(Stream.of(capabilities).map(c -> StateCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StateEndpoint build() {
            return new StateEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
