/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateManagedThingRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<UpdateManagedThingRequest.Builder, UpdateManagedThingRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateManagedThingRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(UpdateManagedThingRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> CREDENTIAL_LOCKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialLockerId").getter(getter(UpdateManagedThingRequest::credentialLockerId))
            .setter(setter(Builder::credentialLockerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialLockerId").build())
            .build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(UpdateManagedThingRequest::serialNumber))
            .setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<String> BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Brand")
            .getter(getter(UpdateManagedThingRequest::brand)).setter(setter(Builder::brand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(UpdateManagedThingRequest::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateManagedThingRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<CapabilityReport> CAPABILITY_REPORT_FIELD = SdkField
            .<CapabilityReport> builder(MarshallingType.SDK_POJO).memberName("CapabilityReport")
            .getter(getter(UpdateManagedThingRequest::capabilityReport)).setter(setter(Builder::capabilityReport))
            .constructor(CapabilityReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilityReport").build()).build();

    private static final SdkField<List<CapabilitySchemaItem>> CAPABILITY_SCHEMAS_FIELD = SdkField
            .<List<CapabilitySchemaItem>> builder(MarshallingType.LIST)
            .memberName("CapabilitySchemas")
            .getter(getter(UpdateManagedThingRequest::capabilitySchemas))
            .setter(setter(Builder::capabilitySchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitySchemas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapabilitySchemaItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapabilitySchemaItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CAPABILITIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Capabilities").getter(getter(UpdateManagedThingRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(UpdateManagedThingRequest::classification))
            .setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<String> HUB_NETWORK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubNetworkMode").getter(getter(UpdateManagedThingRequest::hubNetworkModeAsString))
            .setter(setter(Builder::hubNetworkMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubNetworkMode").build()).build();

    private static final SdkField<Map<String, String>> META_DATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("MetaData")
            .getter(getter(UpdateManagedThingRequest::metaData))
            .setter(setter(Builder::metaData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, OWNER_FIELD,
            CREDENTIAL_LOCKER_ID_FIELD, SERIAL_NUMBER_FIELD, BRAND_FIELD, MODEL_FIELD, NAME_FIELD, CAPABILITY_REPORT_FIELD,
            CAPABILITY_SCHEMAS_FIELD, CAPABILITIES_FIELD, CLASSIFICATION_FIELD, HUB_NETWORK_MODE_FIELD, META_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String owner;

    private final String credentialLockerId;

    private final String serialNumber;

    private final String brand;

    private final String model;

    private final String name;

    private final CapabilityReport capabilityReport;

    private final List<CapabilitySchemaItem> capabilitySchemas;

    private final String capabilities;

    private final String classification;

    private final String hubNetworkMode;

    private final Map<String, String> metaData;

    private UpdateManagedThingRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.owner = builder.owner;
        this.credentialLockerId = builder.credentialLockerId;
        this.serialNumber = builder.serialNumber;
        this.brand = builder.brand;
        this.model = builder.model;
        this.name = builder.name;
        this.capabilityReport = builder.capabilityReport;
        this.capabilitySchemas = builder.capabilitySchemas;
        this.capabilities = builder.capabilities;
        this.classification = builder.classification;
        this.hubNetworkMode = builder.hubNetworkMode;
        this.metaData = builder.metaData;
    }

    /**
     * <p>
     * The id of the managed thing.
     * </p>
     * 
     * @return The id of the managed thing.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Owner of the device, usually an indication of whom the device belongs to. This value should not contain personal
     * identifiable information.
     * </p>
     * 
     * @return Owner of the device, usually an indication of whom the device belongs to. This value should not contain
     *         personal identifiable information.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The identifier of the credential for the managed thing.
     * </p>
     * 
     * @return The identifier of the credential for the managed thing.
     */
    public final String credentialLockerId() {
        return credentialLockerId;
    }

    /**
     * <p>
     * The serial number of the device.
     * </p>
     * 
     * @return The serial number of the device.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The brand of the device.
     * </p>
     * 
     * @return The brand of the device.
     */
    public final String brand() {
        return brand;
    }

    /**
     * <p>
     * The model of the device.
     * </p>
     * 
     * @return The model of the device.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The name of the managed thing representing the physical device.
     * </p>
     * 
     * @return The name of the managed thing representing the physical device.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A report of the capabilities for the managed thing.
     * </p>
     * 
     * @return A report of the capabilities for the managed thing.
     */
    public final CapabilityReport capabilityReport() {
        return capabilityReport;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapabilitySchemas property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilitySchemas() {
        return capabilitySchemas != null && !(capabilitySchemas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated capability schemas that define the functionality and features supported by the managed thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilitySchemas} method.
     * </p>
     * 
     * @return The updated capability schemas that define the functionality and features supported by the managed thing.
     */
    public final List<CapabilitySchemaItem> capabilitySchemas() {
        return capabilitySchemas;
    }

    /**
     * <p>
     * The capabilities of the device such as light bulb.
     * </p>
     * 
     * @return The capabilities of the device such as light bulb.
     */
    public final String capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The classification of the managed thing such as light bulb or thermostat.
     * </p>
     * 
     * @return The classification of the managed thing such as light bulb or thermostat.
     */
    public final String classification() {
        return classification;
    }

    /**
     * <p>
     * The network mode for the hub-connected device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubNetworkMode}
     * will return {@link HubNetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubNetworkModeAsString}.
     * </p>
     * 
     * @return The network mode for the hub-connected device.
     * @see HubNetworkMode
     */
    public final HubNetworkMode hubNetworkMode() {
        return HubNetworkMode.fromValue(hubNetworkMode);
    }

    /**
     * <p>
     * The network mode for the hub-connected device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubNetworkMode}
     * will return {@link HubNetworkMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubNetworkModeAsString}.
     * </p>
     * 
     * @return The network mode for the hub-connected device.
     * @see HubNetworkMode
     */
    public final String hubNetworkModeAsString() {
        return hubNetworkMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetaData property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetaData() {
        return metaData != null && !(metaData instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata for the managed thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetaData} method.
     * </p>
     * 
     * @return The metadata for the managed thing.
     */
    public final Map<String, String> metaData() {
        return metaData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(credentialLockerId());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(brand());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityReport());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilitySchemas() ? capabilitySchemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(hubNetworkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetaData() ? metaData() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedThingRequest)) {
            return false;
        }
        UpdateManagedThingRequest other = (UpdateManagedThingRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(owner(), other.owner())
                && Objects.equals(credentialLockerId(), other.credentialLockerId())
                && Objects.equals(serialNumber(), other.serialNumber()) && Objects.equals(brand(), other.brand())
                && Objects.equals(model(), other.model()) && Objects.equals(name(), other.name())
                && Objects.equals(capabilityReport(), other.capabilityReport())
                && hasCapabilitySchemas() == other.hasCapabilitySchemas()
                && Objects.equals(capabilitySchemas(), other.capabilitySchemas())
                && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(classification(), other.classification())
                && Objects.equals(hubNetworkModeAsString(), other.hubNetworkModeAsString())
                && hasMetaData() == other.hasMetaData() && Objects.equals(metaData(), other.metaData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateManagedThingRequest").add("Identifier", identifier())
                .add("Owner", owner() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CredentialLockerId", credentialLockerId())
                .add("SerialNumber", serialNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Brand", brand() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Model", model() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("CapabilityReport", capabilityReport())
                .add("CapabilitySchemas", hasCapabilitySchemas() ? capabilitySchemas() : null)
                .add("Capabilities", capabilities())
                .add("Classification", classification() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HubNetworkMode", hubNetworkModeAsString()).add("MetaData", hasMetaData() ? metaData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "CredentialLockerId":
            return Optional.ofNullable(clazz.cast(credentialLockerId()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Brand":
            return Optional.ofNullable(clazz.cast(brand()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CapabilityReport":
            return Optional.ofNullable(clazz.cast(capabilityReport()));
        case "CapabilitySchemas":
            return Optional.ofNullable(clazz.cast(capabilitySchemas()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "HubNetworkMode":
            return Optional.ofNullable(clazz.cast(hubNetworkModeAsString()));
        case "MetaData":
            return Optional.ofNullable(clazz.cast(metaData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("CredentialLockerId", CREDENTIAL_LOCKER_ID_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("Brand", BRAND_FIELD);
        map.put("Model", MODEL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CapabilityReport", CAPABILITY_REPORT_FIELD);
        map.put("CapabilitySchemas", CAPABILITY_SCHEMAS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Classification", CLASSIFICATION_FIELD);
        map.put("HubNetworkMode", HUB_NETWORK_MODE_FIELD);
        map.put("MetaData", META_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateManagedThingRequest, T> g) {
        return obj -> g.apply((UpdateManagedThingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateManagedThingRequest> {
        /**
         * <p>
         * The id of the managed thing.
         * </p>
         * 
         * @param identifier
         *        The id of the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Owner of the device, usually an indication of whom the device belongs to. This value should not contain
         * personal identifiable information.
         * </p>
         * 
         * @param owner
         *        Owner of the device, usually an indication of whom the device belongs to. This value should not
         *        contain personal identifiable information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The identifier of the credential for the managed thing.
         * </p>
         * 
         * @param credentialLockerId
         *        The identifier of the credential for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialLockerId(String credentialLockerId);

        /**
         * <p>
         * The serial number of the device.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The brand of the device.
         * </p>
         * 
         * @param brand
         *        The brand of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brand(String brand);

        /**
         * <p>
         * The model of the device.
         * </p>
         * 
         * @param model
         *        The model of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The name of the managed thing representing the physical device.
         * </p>
         * 
         * @param name
         *        The name of the managed thing representing the physical device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A report of the capabilities for the managed thing.
         * </p>
         * 
         * @param capabilityReport
         *        A report of the capabilities for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityReport(CapabilityReport capabilityReport);

        /**
         * <p>
         * A report of the capabilities for the managed thing.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityReport.Builder} avoiding the
         * need to create one manually via {@link CapabilityReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityReport.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilityReport(CapabilityReport)}.
         * 
         * @param capabilityReport
         *        a consumer that will call methods on {@link CapabilityReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityReport(CapabilityReport)
         */
        default Builder capabilityReport(Consumer<CapabilityReport.Builder> capabilityReport) {
            return capabilityReport(CapabilityReport.builder().applyMutation(capabilityReport).build());
        }

        /**
         * <p>
         * The updated capability schemas that define the functionality and features supported by the managed thing.
         * </p>
         * 
         * @param capabilitySchemas
         *        The updated capability schemas that define the functionality and features supported by the managed
         *        thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitySchemas(Collection<CapabilitySchemaItem> capabilitySchemas);

        /**
         * <p>
         * The updated capability schemas that define the functionality and features supported by the managed thing.
         * </p>
         * 
         * @param capabilitySchemas
         *        The updated capability schemas that define the functionality and features supported by the managed
         *        thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitySchemas(CapabilitySchemaItem... capabilitySchemas);

        /**
         * <p>
         * The updated capability schemas that define the functionality and features supported by the managed thing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder#build()} is
         * called immediately and its result is passed to {@link #capabilitySchemas(List<CapabilitySchemaItem>)}.
         * 
         * @param capabilitySchemas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilitySchemaItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilitySchemas(java.util.Collection<CapabilitySchemaItem>)
         */
        Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder>... capabilitySchemas);

        /**
         * <p>
         * The capabilities of the device such as light bulb.
         * </p>
         * 
         * @param capabilities
         *        The capabilities of the device such as light bulb.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String capabilities);

        /**
         * <p>
         * The classification of the managed thing such as light bulb or thermostat.
         * </p>
         * 
         * @param classification
         *        The classification of the managed thing such as light bulb or thermostat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The network mode for the hub-connected device.
         * </p>
         * 
         * @param hubNetworkMode
         *        The network mode for the hub-connected device.
         * @see HubNetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubNetworkMode
         */
        Builder hubNetworkMode(String hubNetworkMode);

        /**
         * <p>
         * The network mode for the hub-connected device.
         * </p>
         * 
         * @param hubNetworkMode
         *        The network mode for the hub-connected device.
         * @see HubNetworkMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubNetworkMode
         */
        Builder hubNetworkMode(HubNetworkMode hubNetworkMode);

        /**
         * <p>
         * The metadata for the managed thing.
         * </p>
         * 
         * @param metaData
         *        The metadata for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaData(Map<String, String> metaData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String identifier;

        private String owner;

        private String credentialLockerId;

        private String serialNumber;

        private String brand;

        private String model;

        private String name;

        private CapabilityReport capabilityReport;

        private List<CapabilitySchemaItem> capabilitySchemas = DefaultSdkAutoConstructList.getInstance();

        private String capabilities;

        private String classification;

        private String hubNetworkMode;

        private Map<String, String> metaData = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedThingRequest model) {
            super(model);
            identifier(model.identifier);
            owner(model.owner);
            credentialLockerId(model.credentialLockerId);
            serialNumber(model.serialNumber);
            brand(model.brand);
            model(model.model);
            name(model.name);
            capabilityReport(model.capabilityReport);
            capabilitySchemas(model.capabilitySchemas);
            capabilities(model.capabilities);
            classification(model.classification);
            hubNetworkMode(model.hubNetworkMode);
            metaData(model.metaData);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getCredentialLockerId() {
            return credentialLockerId;
        }

        public final void setCredentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
        }

        @Override
        public final Builder credentialLockerId(String credentialLockerId) {
            this.credentialLockerId = credentialLockerId;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getBrand() {
            return brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CapabilityReport.Builder getCapabilityReport() {
            return capabilityReport != null ? capabilityReport.toBuilder() : null;
        }

        public final void setCapabilityReport(CapabilityReport.BuilderImpl capabilityReport) {
            this.capabilityReport = capabilityReport != null ? capabilityReport.build() : null;
        }

        @Override
        public final Builder capabilityReport(CapabilityReport capabilityReport) {
            this.capabilityReport = capabilityReport;
            return this;
        }

        public final List<CapabilitySchemaItem.Builder> getCapabilitySchemas() {
            List<CapabilitySchemaItem.Builder> result = CapabilitySchemasCopier.copyToBuilder(this.capabilitySchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilitySchemas(Collection<CapabilitySchemaItem.BuilderImpl> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copyFromBuilder(capabilitySchemas);
        }

        @Override
        public final Builder capabilitySchemas(Collection<CapabilitySchemaItem> capabilitySchemas) {
            this.capabilitySchemas = CapabilitySchemasCopier.copy(capabilitySchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(CapabilitySchemaItem... capabilitySchemas) {
            capabilitySchemas(Arrays.asList(capabilitySchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitySchemas(Consumer<CapabilitySchemaItem.Builder>... capabilitySchemas) {
            capabilitySchemas(Stream.of(capabilitySchemas).map(c -> CapabilitySchemaItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCapabilities() {
            return capabilities;
        }

        public final void setCapabilities(String capabilities) {
            this.capabilities = capabilities;
        }

        @Override
        public final Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getClassification() {
            return classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getHubNetworkMode() {
            return hubNetworkMode;
        }

        public final void setHubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
        }

        @Override
        public final Builder hubNetworkMode(String hubNetworkMode) {
            this.hubNetworkMode = hubNetworkMode;
            return this;
        }

        @Override
        public final Builder hubNetworkMode(HubNetworkMode hubNetworkMode) {
            this.hubNetworkMode(hubNetworkMode == null ? null : hubNetworkMode.toString());
            return this;
        }

        public final Map<String, String> getMetaData() {
            if (metaData instanceof SdkAutoConstructMap) {
                return null;
            }
            return metaData;
        }

        public final void setMetaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
        }

        @Override
        public final Builder metaData(Map<String, String> metaData) {
            this.metaData = MetaDataCopier.copy(metaData);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateManagedThingRequest build() {
            return new UpdateManagedThingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
