/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.iotmanagedintegrations.auth.scheme.IotManagedIntegrationsAuthSchemeProvider;
import software.amazon.awssdk.services.iotmanagedintegrations.endpoints.IotManagedIntegrationsEndpointProvider;

/**
 * This includes configuration specific to Managed integrations for AWS IoT Device Management that is supported by both
 * {@link IotManagedIntegrationsClientBuilder} and {@link IotManagedIntegrationsAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface IotManagedIntegrationsBaseClientBuilder<B extends IotManagedIntegrationsBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
    /**
     * Set the {@link IotManagedIntegrationsEndpointProvider} implementation that will be used by the client to
     * determine the endpoint for each request. This is optional; if none is provided a default implementation will be
     * used the SDK.
     */
    default B endpointProvider(IotManagedIntegrationsEndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link IotManagedIntegrationsAuthSchemeProvider} implementation that will be used by the client to
     * resolve the auth scheme for each request. This is optional; if none is provided a default implementation will be
     * used the SDK.
     */
    default B authSchemeProvider(IotManagedIntegrationsAuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
